/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.OPR_O38_OBSERVATION_REQUEST;
import ca.uhn.hl7v2.model.v26.group.OPR_O38_TIMING;
import ca.uhn.hl7v2.model.v26.segment.OBX;
import ca.uhn.hl7v2.model.v26.segment.SAC;
import ca.uhn.hl7v2.model.v26.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OPR_O38_SPECIMEN
extends AbstractGroup {
    public OPR_O38_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, true, false);
            this.add(OBX.class, false, true);
            this.add(SAC.class, false, true);
            this.add(OPR_O38_OBSERVATION_REQUEST.class, false, true);
            this.add(OPR_O38_TIMING.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating OPR_O38_SPECIMEN - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public SPM getSPM() {
        SPM ret = null;
        try {
            ret = (SPM)this.get("SPM");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBX getOBX() {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBX getOBX(int rep) {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBXReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBX").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", (Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public SAC getSAC() {
        SAC ret = null;
        try {
            ret = (SAC)this.get("SAC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SAC getSAC(int rep) {
        SAC ret = null;
        try {
            ret = (SAC)this.get("SAC", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSACReps() {
        int reps = -1;
        try {
            reps = this.getAll("SAC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSAC(SAC structure, int rep) throws HL7Exception {
        super.insertRepetition("SAC", (Structure)structure, rep);
    }

    public SAC insertSAC(int rep) throws HL7Exception {
        return (SAC)super.insertRepetition("SAC", rep);
    }

    public SAC removeSAC(int rep) throws HL7Exception {
        return (SAC)super.removeRepetition("SAC", rep);
    }

    public OPR_O38_OBSERVATION_REQUEST getOBSERVATION_REQUEST() {
        OPR_O38_OBSERVATION_REQUEST ret = null;
        try {
            ret = (OPR_O38_OBSERVATION_REQUEST)this.get("OBSERVATION_REQUEST");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OPR_O38_OBSERVATION_REQUEST getOBSERVATION_REQUEST(int rep) {
        OPR_O38_OBSERVATION_REQUEST ret = null;
        try {
            ret = (OPR_O38_OBSERVATION_REQUEST)this.get("OBSERVATION_REQUEST", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBSERVATION_REQUESTReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBSERVATION_REQUEST").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBSERVATION_REQUEST(OPR_O38_OBSERVATION_REQUEST structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION_REQUEST", (Structure)structure, rep);
    }

    public OPR_O38_OBSERVATION_REQUEST insertOBSERVATION_REQUEST(int rep) throws HL7Exception {
        return (OPR_O38_OBSERVATION_REQUEST)super.insertRepetition("OBSERVATION_REQUEST", rep);
    }

    public OPR_O38_OBSERVATION_REQUEST removeOBSERVATION_REQUEST(int rep) throws HL7Exception {
        return (OPR_O38_OBSERVATION_REQUEST)super.removeRepetition("OBSERVATION_REQUEST", rep);
    }

    public OPR_O38_TIMING getTIMING() {
        OPR_O38_TIMING ret = null;
        try {
            ret = (OPR_O38_TIMING)this.get("TIMING");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OPR_O38_TIMING getTIMING(int rep) {
        OPR_O38_TIMING ret = null;
        try {
            ret = (OPR_O38_TIMING)this.get("TIMING", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMINGReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertTIMING(OPR_O38_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public OPR_O38_TIMING insertTIMING(int rep) throws HL7Exception {
        return (OPR_O38_TIMING)super.insertRepetition("TIMING", rep);
    }

    public OPR_O38_TIMING removeTIMING(int rep) throws HL7Exception {
        return (OPR_O38_TIMING)super.removeRepetition("TIMING", rep);
    }
}

