/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.mapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MappingType {
    BIJECTION,
    SURJECTION,
    INJECTION,
    FUNCTION,
    INVERSE_SURJECTION,
    PARTIAL_SURJECTION,
    PARTIAL_INJECTION,
    PARTIAL_FUNCTION,
    INVERSE_INJECTION,
    INVERSE_PARTIAL_INJECTION,
    TEN,
    ELEVEN,
    INVERSE_FUNCTION,
    INVERSE_PARTIAL_FUNCTION,
    FOURTEEN,
    MULTI_FUNCTION;

    private final int inverseOrdinal = (this.ordinal() & 3) << 2 | (this.ordinal() & 0xC) >> 2;
    private static final int OPTIONAL_SOURCE = 1;
    private static final int MULTIPLE_SOURCE = 2;
    private static final int OPTIONAL_TARGET = 4;
    private static final int MULTIPLE_TARGET = 8;

    public MappingType inverse() {
        return MappingType.values()[this.inverseOrdinal];
    }

    public boolean isA(MappingType mappingType) {
        return (this.ordinal() & mappingType.ordinal()) == this.ordinal();
    }

    public boolean isFunction() {
        return (this.ordinal() & 0xC) == 0;
    }

    public boolean isPartialFunction() {
        return (this.ordinal() & 8) == 0;
    }

    public boolean isSurjection() {
        return (this.ordinal() & 0xD) == 0;
    }

    public boolean isInjection() {
        return (this.ordinal() & 0xE) == 0;
    }

    public boolean isBijection() {
        return (this.ordinal() & 0xF) == 0;
    }

    public boolean isMandatoryTarget() {
        return (this.ordinal() & 4) != 4;
    }

    public boolean isSingleTarget() {
        return (this.ordinal() & 8) != 8;
    }

    public boolean isMandatorySource() {
        return (this.ordinal() & 1) != 1;
    }

    public boolean isSingleSource() {
        return (this.ordinal() & 2) != 2;
    }
}

