/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.AuthorizationProvider;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.hdfs.util.Diff;
import org.apache.hadoop.util.ChunkedArrayList;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public abstract class INode
implements INodeAttributes,
Diff.Element<byte[]>,
AuthorizationProvider.INodeAuthorizationInfo {
    public static final Log LOG = LogFactory.getLog(INode.class);
    private INode parent = null;

    INode(INode parent) {
        this.parent = parent;
    }

    @Override
    public abstract long getId();

    final boolean isRoot() {
        return this.getLocalNameBytes().length == 0;
    }

    abstract PermissionStatus getPermissionStatus(int var1);

    abstract PermissionStatus getFsimagePermissionStatus(int var1);

    final PermissionStatus getPermissionStatus() {
        return this.getPermissionStatus(0x7FFFFFFE);
    }

    final PermissionStatus getFsimagePermissionStatus() {
        return this.getFsimagePermissionStatus(0x7FFFFFFE);
    }

    @Override
    public abstract String getUserName(int var1);

    @Override
    public abstract String getFsimageUserName(int var1);

    @Override
    public final String getUserName() {
        return this.getUserName(0x7FFFFFFE);
    }

    @Override
    public final String getFsimageUserName() {
        return this.getFsimageUserName(0x7FFFFFFE);
    }

    abstract void setUser(String var1);

    final INode setUser(String user, int latestSnapshotId) {
        this.recordModification(latestSnapshotId);
        this.setUser(user);
        return this;
    }

    @Override
    public abstract String getGroupName(int var1);

    @Override
    public abstract String getFsimageGroupName(int var1);

    @Override
    public final String getGroupName() {
        return this.getGroupName(0x7FFFFFFE);
    }

    @Override
    public final String getFsimageGroupName() {
        return this.getFsimageGroupName(0x7FFFFFFE);
    }

    abstract void setGroup(String var1);

    final INode setGroup(String group, int latestSnapshotId) {
        this.recordModification(latestSnapshotId);
        this.setGroup(group);
        return this;
    }

    @Override
    public abstract FsPermission getFsPermission(int var1);

    @Override
    public abstract FsPermission getFsimageFsPermission(int var1);

    @Override
    public final FsPermission getFsPermission() {
        return this.getFsPermission(0x7FFFFFFE);
    }

    @Override
    public final FsPermission getFsimageFsPermission() {
        return this.getFsimageFsPermission(0x7FFFFFFE);
    }

    abstract void setPermission(FsPermission var1);

    INode setPermission(FsPermission permission, int latestSnapshotId) {
        this.recordModification(latestSnapshotId);
        this.setPermission(permission);
        return this;
    }

    @Override
    public abstract AclFeature getAclFeature(int var1);

    @Override
    public abstract AclFeature getFsimageAclFeature(int var1);

    @Override
    public final AclFeature getAclFeature() {
        return this.getAclFeature(0x7FFFFFFE);
    }

    @Override
    public final AclFeature getFsimageAclFeature() {
        return this.getFsimageAclFeature(0x7FFFFFFE);
    }

    abstract void addAclFeature(AclFeature var1);

    final INode addAclFeature(AclFeature aclFeature, int latestSnapshotId) {
        this.recordModification(latestSnapshotId);
        this.addAclFeature(aclFeature);
        return this;
    }

    abstract void removeAclFeature();

    final INode removeAclFeature(int latestSnapshotId) {
        this.recordModification(latestSnapshotId);
        this.removeAclFeature();
        return this;
    }

    abstract XAttrFeature getXAttrFeature(int var1);

    @Override
    public final XAttrFeature getXAttrFeature() {
        return this.getXAttrFeature(0x7FFFFFFE);
    }

    abstract void addXAttrFeature(XAttrFeature var1);

    final INode addXAttrFeature(XAttrFeature xAttrFeature, int latestSnapshotId) {
        this.recordModification(latestSnapshotId);
        this.addXAttrFeature(xAttrFeature);
        return this;
    }

    abstract void removeXAttrFeature();

    final INode removeXAttrFeature(int lastestSnapshotId) {
        this.recordModification(lastestSnapshotId);
        this.removeXAttrFeature();
        return this;
    }

    public INodeAttributes getSnapshotINode(int snapshotId) {
        return this;
    }

    public final boolean isInLatestSnapshot(int latestSnapshotId) {
        if (latestSnapshotId == 0x7FFFFFFE) {
            return false;
        }
        if (this.parent != null && this.parent.isReference()) {
            return true;
        }
        INodeDirectory parentDir = this.getParent();
        if (parentDir == null) {
            return true;
        }
        if (!parentDir.isInLatestSnapshot(latestSnapshotId)) {
            return false;
        }
        INode child = parentDir.getChild(this.getLocalNameBytes(), latestSnapshotId);
        if (this == child) {
            return true;
        }
        return child != null && child.isReference() && this == child.asReference().getReferredINode();
    }

    public final boolean isAncestorDirectory(INodeDirectory dir) {
        for (INodeDirectory p = this.getParent(); p != null; p = p.getParent()) {
            if (p != dir) continue;
            return true;
        }
        return false;
    }

    public final boolean shouldRecordInSrcSnapshot(int latestInDst) {
        int dstSnapshotId;
        Preconditions.checkState((!this.isReference() ? 1 : 0) != 0);
        if (latestInDst == 0x7FFFFFFE) {
            return true;
        }
        INodeReference withCount = this.getParentReference();
        return withCount != null && (dstSnapshotId = withCount.getParentReference().getDstSnapshotId()) != 0x7FFFFFFE && dstSnapshotId >= latestInDst;
    }

    abstract void recordModification(int var1);

    public boolean isReference() {
        return false;
    }

    public INodeReference asReference() {
        throw new IllegalStateException("Current inode is not a reference: " + this.toDetailString());
    }

    public boolean isFile() {
        return false;
    }

    public INodeFile asFile() {
        throw new IllegalStateException("Current inode is not a file: " + this.toDetailString());
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    public INodeDirectory asDirectory() {
        throw new IllegalStateException("Current inode is not a directory: " + this.toDetailString());
    }

    public boolean isSymlink() {
        return false;
    }

    public INodeSymlink asSymlink() {
        throw new IllegalStateException("Current inode is not a symlink: " + this.toDetailString());
    }

    public abstract Quota.Counts cleanSubtree(int var1, int var2, BlocksMapUpdateInfo var3, List<INode> var4);

    public abstract void destroyAndCollectBlocks(BlocksMapUpdateInfo var1, List<INode> var2);

    public final ContentSummary computeContentSummary() {
        return this.computeAndConvertContentSummary(0x7FFFFFFE, new ContentSummaryComputationContext());
    }

    public final ContentSummary computeAndConvertContentSummary(int snapshotId, ContentSummaryComputationContext summary) {
        this.computeContentSummary(snapshotId, summary);
        summary.tallyDeletedSnapshottedINodes();
        Content.Counts counts = summary.getCounts();
        Content.Counts snapshotCounts = summary.getSnapshotCounts();
        Quota.Counts q = this.getQuotaCounts();
        return new ContentSummary(counts.get(Content.LENGTH), counts.get(Content.FILE) + counts.get(Content.SYMLINK), counts.get(Content.DIRECTORY), q.get(Quota.NAMESPACE), counts.get(Content.DISKSPACE), q.get(Quota.DISKSPACE), snapshotCounts.get(Content.LENGTH), snapshotCounts.get(Content.FILE), snapshotCounts.get(Content.DIRECTORY), snapshotCounts.get(Content.DISKSPACE));
    }

    public abstract ContentSummaryComputationContext computeContentSummary(int var1, ContentSummaryComputationContext var2);

    public void addSpaceConsumed(long nsDelta, long dsDelta, boolean verify) throws QuotaExceededException {
        this.addSpaceConsumed2Parent(nsDelta, dsDelta, verify);
    }

    void addSpaceConsumed2Parent(long nsDelta, long dsDelta, boolean verify) throws QuotaExceededException {
        if (this.parent != null) {
            this.parent.addSpaceConsumed(nsDelta, dsDelta, verify);
        }
    }

    public Quota.Counts getQuotaCounts() {
        return Quota.Counts.newInstance(-1L, -1L);
    }

    public final boolean isQuotaSet() {
        Quota.Counts q = this.getQuotaCounts();
        return q.get(Quota.NAMESPACE) >= 0L || q.get(Quota.DISKSPACE) >= 0L;
    }

    public final Quota.Counts computeQuotaUsage() {
        return this.computeQuotaUsage(new Quota.Counts(), true);
    }

    public abstract Quota.Counts computeQuotaUsage(Quota.Counts var1, boolean var2, int var3);

    public final Quota.Counts computeQuotaUsage(Quota.Counts counts, boolean useCache) {
        return this.computeQuotaUsage(counts, useCache, 0x7FFFFFFE);
    }

    @Override
    public final String getLocalName() {
        byte[] name = this.getLocalNameBytes();
        return name == null ? null : DFSUtil.bytes2String(name);
    }

    @Override
    public final byte[] getKey() {
        return this.getLocalNameBytes();
    }

    public abstract void setLocalName(byte[] var1);

    @Override
    public String getFullPathName() {
        if (this.isRoot()) {
            return "/";
        }
        int idx = 0;
        for (INode inode = this; inode != null; inode = inode.getParent()) {
            idx += inode.getLocalNameBytes().length + (inode != this ? 1 : 0);
        }
        byte[] path = new byte[idx];
        for (INode inode = this; inode != null; inode = inode.getParent()) {
            if (inode != this) {
                path[--idx] = 47;
            }
            byte[] name = inode.getLocalNameBytes();
            System.arraycopy(name, 0, path, idx -= name.length, name.length);
        }
        return DFSUtil.bytes2String(path);
    }

    public String toString() {
        return this.getLocalName();
    }

    @VisibleForTesting
    public final String getObjectString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(super.hashCode());
    }

    @VisibleForTesting
    public final String getParentString() {
        INodeReference parentRef = this.getParentReference();
        if (parentRef != null) {
            return "parentRef=" + parentRef.getLocalName() + "->";
        }
        INodeDirectory parentDir = this.getParent();
        if (parentDir != null) {
            return "parentDir=" + parentDir.getLocalName() + "/";
        }
        return "parent=null";
    }

    @VisibleForTesting
    public String toDetailString() {
        return this.toString() + "(" + this.getObjectString() + "), " + this.getParentString();
    }

    @Override
    public final INodeDirectory getParent() {
        return this.parent == null ? null : (this.parent.isReference() ? this.getParentReference().getParent() : this.parent.asDirectory());
    }

    public INodeReference getParentReference() {
        return this.parent == null || !this.parent.isReference() ? null : (INodeReference)this.parent;
    }

    public final void setParent(INodeDirectory parent) {
        this.parent = parent;
    }

    public final void setParentReference(INodeReference parent) {
        this.parent = parent;
    }

    public void clear() {
        this.setParent(null);
    }

    abstract long getModificationTime(int var1);

    @Override
    public final long getModificationTime() {
        return this.getModificationTime(0x7FFFFFFE);
    }

    public abstract INode updateModificationTime(long var1, int var3);

    public abstract void setModificationTime(long var1);

    public final INode setModificationTime(long modificationTime, int latestSnapshotId) {
        this.recordModification(latestSnapshotId);
        this.setModificationTime(modificationTime);
        return this;
    }

    abstract long getAccessTime(int var1);

    @Override
    public final long getAccessTime() {
        return this.getAccessTime(0x7FFFFFFE);
    }

    public abstract void setAccessTime(long var1);

    public final INode setAccessTime(long accessTime, int latestSnapshotId) {
        this.recordModification(latestSnapshotId);
        this.setAccessTime(accessTime);
        return this;
    }

    public abstract byte getStoragePolicyID();

    public abstract byte getLocalStoragePolicyID();

    @VisibleForTesting
    public static byte[][] getPathComponents(String path) {
        INode.checkAbsolutePath(path);
        return DFSUtil.getPathComponents(path);
    }

    public static String[] getPathNames(String path) {
        INode.checkAbsolutePath(path);
        return StringUtils.split((String)path, (char)'/');
    }

    private static void checkAbsolutePath(String path) {
        if (path == null || !path.startsWith("/")) {
            throw new AssertionError((Object)("Absolute path required, but got '" + path + "'"));
        }
    }

    @Override
    public final int compareTo(byte[] bytes) {
        return DFSUtil.compareBytes(this.getLocalNameBytes(), bytes);
    }

    public final boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !(that instanceof INode)) {
            return false;
        }
        return this.getId() == ((INode)that).getId();
    }

    public final int hashCode() {
        long id = this.getId();
        return (int)(id ^ id >>> 32);
    }

    @VisibleForTesting
    public final StringBuffer dumpTreeRecursively() {
        StringWriter out = new StringWriter();
        this.dumpTreeRecursively(new PrintWriter((Writer)out, true), new StringBuilder(), 0x7FFFFFFE);
        return out.getBuffer();
    }

    @VisibleForTesting
    public final void dumpTreeRecursively(PrintStream out) {
        this.dumpTreeRecursively(new PrintWriter(out, true), new StringBuilder(), 0x7FFFFFFE);
    }

    @VisibleForTesting
    public void dumpTreeRecursively(PrintWriter out, StringBuilder prefix, int snapshotId) {
        out.print(prefix);
        out.print(" ");
        String name = this.getLocalName();
        out.print(name.isEmpty() ? "/" : name);
        out.print("   (");
        out.print(this.getObjectString());
        out.print("), ");
        out.print(this.getParentString());
        out.print(", " + this.getPermissionStatus(snapshotId));
    }

    public static interface Feature {
    }

    public static class BlocksMapUpdateInfo {
        private final List<BlockInfo> toDeleteList = new ChunkedArrayList();

        public List<BlockInfo> getToDeleteList() {
            return this.toDeleteList;
        }

        public void addDeleteBlock(BlockInfo toDelete) {
            assert (toDelete != null) : "toDelete is null";
            this.toDeleteList.add(toDelete);
        }

        public void removeDeleteBlock(BlockInfo block) {
            assert (block != null) : "block is null";
            this.toDeleteList.remove(block);
        }

        public void clear() {
            this.toDeleteList.clear();
        }
    }
}

