/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.ael.adapters;

import java.util.Collections;
import java.util.List;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.LogicalModelElement;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Rows;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;

public class StepInterfaceEngineAdapter
extends BaseStep {
    private final Operation operation;
    private final ExecutionContext executionContext;

    public StepInterfaceEngineAdapter(Operation op, ExecutionContext executionContext, StepMeta stepMeta, TransMeta transMeta, StepDataInterface dataInterface, Trans trans) {
        super(stepMeta, dataInterface, 0, transMeta, trans);
        this.operation = op;
        this.executionContext = executionContext;
        this.setInputRowSets(Collections.emptyList());
        this.setOutputRowSets(Collections.emptyList());
        this.init();
    }

    @Override
    public void dispatch() {
    }

    private void init() {
        this.subscribeToMetrics();
        this.subscribeToStatus();
        this.subscribeToRows();
    }

    private void subscribeToRows() {
        this.executionContext.subscribe((LogicalModelElement)this.operation, Rows.class, data -> {
            if (data.getType().equals((Object)Rows.TYPE.OUT)) {
                data.stream().forEach(this::putRow);
            }
        });
    }

    private void subscribeToStatus() {
        this.executionContext.subscribe((LogicalModelElement)this.operation, Status.class, data -> {
            switch (data) {
                case RUNNING: {
                    this.setRunning(true);
                    break;
                }
                case PAUSED: {
                    this.setPaused(true);
                    break;
                }
                case STOPPED: {
                    this.setStopped(true);
                    break;
                }
                case FAILED: 
                case FINISHED: {
                    this.setRunning(false);
                }
            }
        });
    }

    private void subscribeToMetrics() {
        this.executionContext.subscribe((LogicalModelElement)this.operation, Metrics.class, data -> {
            this.setLinesRead(data.getIn());
            this.setLinesWritten(data.getOut());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putRow(Row row) {
        try {
            if (this.executionContext.getConversionManager() == null) {
                return;
            }
            List list = this.rowListeners;
            synchronized (list) {
                for (int i = 0; i < this.rowListeners.size(); ++i) {
                    RowListener rowListener = (RowListener)this.rowListeners.get(i);
                    rowListener.rowWrittenEvent((RowMetaInterface)this.executionContext.getConversionManager().convert(row, RowMetaInterface.class), row.getObjects());
                }
            }
        }
        catch (KettleStepException e) {
            this.logDebug(e.getMessage());
        }
    }
}

