/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.autodoc;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.AreaOwner;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.autodoc.AutoDocData;
import org.pentaho.di.trans.steps.autodoc.AutoDocMeta;
import org.pentaho.di.trans.steps.autodoc.JobInformation;
import org.pentaho.di.trans.steps.autodoc.KettleFileTableModel;
import org.pentaho.di.trans.steps.autodoc.KettleReportBuilder;
import org.pentaho.di.trans.steps.autodoc.ReportSubjectLocation;
import org.pentaho.di.trans.steps.autodoc.TransformationInformation;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.resourceloader.LibLoaderBoot;

public class AutoDoc
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = AutoDoc.class;
    private AutoDocMeta meta;
    private AutoDocData data;

    public AutoDoc(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        RepositoryObjectType objectType;
        this.meta = (AutoDocMeta)smi;
        this.data = (AutoDocData)sdi;
        Object[] row = this.getRow();
        if (row == null) {
            if (this.data.filenames.isEmpty()) {
                this.setOutputDone();
                return false;
            }
            FileObject targetFile = KettleVFS.getFileObject((String)this.environmentSubstitute(this.meta.getTargetFilename()));
            String targetFilename = KettleVFS.getFilename((FileObject)targetFile);
            KettleReportBuilder kettleReportBuilder = new KettleReportBuilder(this, this.data.filenames, KettleVFS.getFilename((FileObject)targetFile), this.meta);
            try {
                if (!ClassicEngineBoot.getInstance().isBootDone()) {
                    ObjectUtilities.setClassLoader((ClassLoader)this.getClass().getClassLoader());
                    ObjectUtilities.setClassLoaderSource((String)"ClassContext");
                    LibLoaderBoot.getInstance().start();
                    LibFontBoot.getInstance().start();
                    ClassicEngineBoot.getInstance().start();
                }
                kettleReportBuilder.createReport();
                kettleReportBuilder.render();
                Object[] outputRowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
                int outputIndex = 0;
                outputRowData[outputIndex++] = targetFilename;
                this.putRow(this.data.outputRowMeta, outputRowData);
                ResultFile resultFile = new ResultFile(0, targetFile, this.getTransMeta().getName(), this.toString());
                resultFile.setComment("This file was generated by the 'Auto Documentation Output' step");
                this.addResultFile(resultFile);
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AutoDoc.Exception.UnableToRenderReport", (String[])new String[0]), (Throwable)e);
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            String filenameField = this.environmentSubstitute(this.meta.getFilenameField());
            this.data.fileNameFieldIndex = this.getInputRowMeta().indexOfValue(filenameField);
            if (this.data.fileNameFieldIndex < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AutoDoc.Exception.FilenameFieldNotFound", (String[])new String[]{filenameField}));
            }
            String fileTypeField = this.environmentSubstitute(this.meta.getFileTypeField());
            this.data.fileTypeFieldIndex = this.getInputRowMeta().indexOfValue(fileTypeField);
            if (this.data.fileTypeFieldIndex < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AutoDoc.Exception.FileTypeFieldNotFound", (String[])new String[]{fileTypeField}));
            }
            this.data.repository = this.getTrans().getRepository();
            if (this.data.repository != null) {
                this.data.tree = this.data.repository.loadRepositoryDirectoryTree();
            }
            TransformationInformation.init(this.getTrans().getRepository());
            JobInformation.init(this.getTrans().getRepository());
        }
        String fileName = this.getInputRowMeta().getString(row, this.data.fileNameFieldIndex);
        String fileType = this.getInputRowMeta().getString(row, this.data.fileTypeFieldIndex);
        if ("Transformation".equalsIgnoreCase(fileType)) {
            objectType = RepositoryObjectType.TRANSFORMATION;
        } else if ("Job".equalsIgnoreCase(fileType)) {
            objectType = RepositoryObjectType.JOB;
        } else {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AutoDoc.Exception.UnknownFileTypeValue", (String[])new String[]{fileType}));
        }
        ReportSubjectLocation location = null;
        if (this.getTrans().getRepository() == null) {
            switch (objectType) {
                case TRANSFORMATION: {
                    location = new ReportSubjectLocation(fileName, null, null, objectType);
                    break;
                }
                case JOB: {
                    location = new ReportSubjectLocation(fileName, null, null, objectType);
                    break;
                }
            }
        } else {
            int lastSlashIndex = fileName.lastIndexOf("/");
            if (lastSlashIndex < 0) {
                fileName = "/" + fileName;
                lastSlashIndex = 0;
            }
            String directoryName = fileName.substring(0, lastSlashIndex + 1);
            String objectName = fileName.substring(lastSlashIndex + 1);
            RepositoryDirectoryInterface directory = this.data.tree.findDirectory(directoryName);
            if (directory == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AutoDoc.Exception.RepositoryDirectoryNotFound", (String[])new String[]{directoryName}));
            }
            location = new ReportSubjectLocation(null, directory, objectName, objectType);
        }
        if (location == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AutoDoc.Exception.UnableToDetermineLocation", (String[])new String[]{fileName, fileType}));
        }
        if (this.meta.getOutputType() != KettleReportBuilder.OutputType.METADATA) {
            this.data.filenames.add(location);
        } else {
            Object[] outputRow = RowDataUtil.resizeArray((Object[])row, (int)this.data.outputRowMeta.size());
            int outputIndex = this.getInputRowMeta().size();
            List<AreaOwner> imageAreaList = null;
            switch (location.getObjectType()) {
                case TRANSFORMATION: {
                    TransformationInformation ti = TransformationInformation.getInstance();
                    TransMeta transMeta = ti.getTransMeta(location);
                    imageAreaList = ti.getImageAreaList(location);
                    outputRow[outputIndex++] = transMeta;
                    break;
                }
                case JOB: {
                    JobInformation ji = JobInformation.getInstance();
                    JobMeta jobMeta = ji.getJobMeta(location);
                    imageAreaList = ji.getImageAreaList(location);
                    outputRow[outputIndex++] = jobMeta;
                    break;
                }
            }
            if (this.meta.isIncludingName()) {
                outputRow[outputIndex++] = KettleFileTableModel.getName(location);
            }
            if (this.meta.isIncludingDescription()) {
                outputRow[outputIndex++] = KettleFileTableModel.getDescription(location);
            }
            if (this.meta.isIncludingExtendedDescription()) {
                outputRow[outputIndex++] = KettleFileTableModel.getExtendedDescription(location);
            }
            if (this.meta.isIncludingCreated()) {
                outputRow[outputIndex++] = KettleFileTableModel.getCreation(location);
            }
            if (this.meta.isIncludingModified()) {
                outputRow[outputIndex++] = KettleFileTableModel.getModification(location);
            }
            if (this.meta.isIncludingImage()) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                try {
                    BufferedImage image = KettleFileTableModel.getImage(location);
                    ImageIO.write((RenderedImage)image, "png", outputStream);
                    outputRow[outputIndex++] = outputStream.toByteArray();
                }
                catch (Exception e) {
                    throw new KettleException("Unable to serialize image to PNG", (Throwable)e);
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        throw new KettleException("Unable to serialize image to PNG", (Throwable)e);
                    }
                }
            }
            if (this.meta.isIncludingLoggingConfiguration()) {
                outputRow[outputIndex++] = KettleFileTableModel.getLogging(location);
            }
            if (this.meta.isIncludingLastExecutionResult()) {
                outputRow[outputIndex++] = KettleFileTableModel.getLogging(location);
            }
            if (this.meta.isIncludingImageAreaList()) {
                outputRow[outputIndex++] = imageAreaList;
            }
            this.putRow(this.data.outputRowMeta, outputRow);
        }
        return true;
    }
}

