/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.systemdata;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaNone;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.systemdata.SystemData;
import org.pentaho.di.trans.steps.systemdata.SystemDataData;
import org.pentaho.di.trans.steps.systemdata.SystemDataTypes;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class SystemDataMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = SystemDataMeta.class;
    private String[] fieldName;
    private SystemDataTypes[] fieldType;

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public SystemDataTypes[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(SystemDataTypes[] fieldType) {
        this.fieldType = fieldType;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int count) {
        this.fieldName = new String[count];
        this.fieldType = new SystemDataTypes[count];
    }

    @Override
    public Object clone() {
        SystemDataMeta retval = (SystemDataMeta)super.clone();
        int count = this.fieldName.length;
        retval.allocate(count);
        System.arraycopy(this.fieldName, 0, retval.fieldName, 0, count);
        System.arraycopy(this.fieldType, 0, retval.fieldType, 0, count);
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int count = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                String type = XMLHandler.getTagValue((Node)fnode, (String)"type");
                this.fieldType[i] = SystemDataMeta.getType(type);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to read step information from XML", (Throwable)e);
        }
    }

    public static final SystemDataTypes getType(String type) {
        for (SystemDataTypes systemType : SystemDataTypes.values()) {
            if (systemType.getCode().equalsIgnoreCase(type)) {
                return systemType;
            }
            if (!systemType.getDescription().equalsIgnoreCase(type)) continue;
            return systemType;
        }
        return SystemDataTypes.TYPE_SYSTEM_INFO_NONE;
    }

    public static final String getTypeDesc(SystemDataTypes t) {
        return t.getDescription();
    }

    @Override
    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.fieldName[i] = "field" + i;
            this.fieldType[i] = SystemDataTypes.TYPE_SYSTEM_INFO_SYSTEM_DATE;
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        for (int i = 0; i < this.fieldName.length; ++i) {
            ValueMetaDate v;
            switch (this.fieldType[i]) {
                case TYPE_SYSTEM_INFO_SYSTEM_START: 
                case TYPE_SYSTEM_INFO_SYSTEM_DATE: 
                case TYPE_SYSTEM_INFO_TRANS_DATE_FROM: 
                case TYPE_SYSTEM_INFO_TRANS_DATE_TO: 
                case TYPE_SYSTEM_INFO_JOB_DATE_FROM: 
                case TYPE_SYSTEM_INFO_JOB_DATE_TO: 
                case TYPE_SYSTEM_INFO_PREV_DAY_START: 
                case TYPE_SYSTEM_INFO_PREV_DAY_END: 
                case TYPE_SYSTEM_INFO_THIS_DAY_START: 
                case TYPE_SYSTEM_INFO_THIS_DAY_END: 
                case TYPE_SYSTEM_INFO_NEXT_DAY_START: 
                case TYPE_SYSTEM_INFO_NEXT_DAY_END: 
                case TYPE_SYSTEM_INFO_PREV_MONTH_START: 
                case TYPE_SYSTEM_INFO_PREV_MONTH_END: 
                case TYPE_SYSTEM_INFO_THIS_MONTH_START: 
                case TYPE_SYSTEM_INFO_THIS_MONTH_END: 
                case TYPE_SYSTEM_INFO_NEXT_MONTH_START: 
                case TYPE_SYSTEM_INFO_NEXT_MONTH_END: 
                case TYPE_SYSTEM_INFO_MODIFIED_DATE: 
                case TYPE_SYSTEM_INFO_KETTLE_BUILD_DATE: 
                case TYPE_SYSTEM_INFO_PREV_WEEK_START: 
                case TYPE_SYSTEM_INFO_PREV_WEEK_END: 
                case TYPE_SYSTEM_INFO_PREV_WEEK_OPEN_END: 
                case TYPE_SYSTEM_INFO_PREV_WEEK_START_US: 
                case TYPE_SYSTEM_INFO_PREV_WEEK_END_US: 
                case TYPE_SYSTEM_INFO_THIS_WEEK_START: 
                case TYPE_SYSTEM_INFO_THIS_WEEK_END: 
                case TYPE_SYSTEM_INFO_THIS_WEEK_OPEN_END: 
                case TYPE_SYSTEM_INFO_THIS_WEEK_START_US: 
                case TYPE_SYSTEM_INFO_THIS_WEEK_END_US: 
                case TYPE_SYSTEM_INFO_NEXT_WEEK_START: 
                case TYPE_SYSTEM_INFO_NEXT_WEEK_END: 
                case TYPE_SYSTEM_INFO_NEXT_WEEK_OPEN_END: 
                case TYPE_SYSTEM_INFO_NEXT_WEEK_START_US: 
                case TYPE_SYSTEM_INFO_NEXT_WEEK_END_US: 
                case TYPE_SYSTEM_INFO_PREV_QUARTER_START: 
                case TYPE_SYSTEM_INFO_PREV_QUARTER_END: 
                case TYPE_SYSTEM_INFO_THIS_QUARTER_START: 
                case TYPE_SYSTEM_INFO_THIS_QUARTER_END: 
                case TYPE_SYSTEM_INFO_NEXT_QUARTER_START: 
                case TYPE_SYSTEM_INFO_NEXT_QUARTER_END: 
                case TYPE_SYSTEM_INFO_PREV_YEAR_START: 
                case TYPE_SYSTEM_INFO_PREV_YEAR_END: 
                case TYPE_SYSTEM_INFO_THIS_YEAR_START: 
                case TYPE_SYSTEM_INFO_THIS_YEAR_END: 
                case TYPE_SYSTEM_INFO_NEXT_YEAR_START: 
                case TYPE_SYSTEM_INFO_NEXT_YEAR_END: {
                    v = new ValueMetaDate(this.fieldName[i]);
                    break;
                }
                case TYPE_SYSTEM_INFO_TRANS_NAME: 
                case TYPE_SYSTEM_INFO_FILENAME: 
                case TYPE_SYSTEM_INFO_ARGUMENT_01: 
                case TYPE_SYSTEM_INFO_ARGUMENT_02: 
                case TYPE_SYSTEM_INFO_ARGUMENT_03: 
                case TYPE_SYSTEM_INFO_ARGUMENT_04: 
                case TYPE_SYSTEM_INFO_ARGUMENT_05: 
                case TYPE_SYSTEM_INFO_ARGUMENT_06: 
                case TYPE_SYSTEM_INFO_ARGUMENT_07: 
                case TYPE_SYSTEM_INFO_ARGUMENT_08: 
                case TYPE_SYSTEM_INFO_ARGUMENT_09: 
                case TYPE_SYSTEM_INFO_ARGUMENT_10: 
                case TYPE_SYSTEM_INFO_MODIFIED_USER: 
                case TYPE_SYSTEM_INFO_HOSTNAME: 
                case TYPE_SYSTEM_INFO_HOSTNAME_REAL: 
                case TYPE_SYSTEM_INFO_IP_ADDRESS: 
                case TYPE_SYSTEM_INFO_KETTLE_VERSION: 
                case TYPE_SYSTEM_INFO_KETTLE_BUILD_VERSION: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_LOG_TEXT: {
                    v = new ValueMetaString(this.fieldName[i]);
                    break;
                }
                case TYPE_SYSTEM_INFO_COPYNR: 
                case TYPE_SYSTEM_INFO_TRANS_BATCH_ID: 
                case TYPE_SYSTEM_INFO_JOB_BATCH_ID: 
                case TYPE_SYSTEM_INFO_CURRENT_PID: 
                case TYPE_SYSTEM_INFO_JVM_TOTAL_MEMORY: 
                case TYPE_SYSTEM_INFO_JVM_FREE_MEMORY: 
                case TYPE_SYSTEM_INFO_JVM_MAX_MEMORY: 
                case TYPE_SYSTEM_INFO_JVM_AVAILABLE_MEMORY: 
                case TYPE_SYSTEM_INFO_AVAILABLE_PROCESSORS: 
                case TYPE_SYSTEM_INFO_JVM_CPU_TIME: 
                case TYPE_SYSTEM_INFO_TOTAL_PHYSICAL_MEMORY_SIZE: 
                case TYPE_SYSTEM_INFO_TOTAL_SWAP_SPACE_SIZE: 
                case TYPE_SYSTEM_INFO_COMMITTED_VIRTUAL_MEMORY_SIZE: 
                case TYPE_SYSTEM_INFO_FREE_PHYSICAL_MEMORY_SIZE: 
                case TYPE_SYSTEM_INFO_FREE_SWAP_SPACE_SIZE: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_EXIT_STATUS: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_ENTRY_NR: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_ERRORS: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_FILES: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_FILES_RETRIEVED: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_DELETED: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_INPUT: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_OUTPUT: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_READ: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_REJETED: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_UPDATED: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_WRITTEN: {
                    v = new ValueMetaInteger(this.fieldName[i]);
                    v.setLength(10, 0);
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_RESULT: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_IS_STOPPED: {
                    v = new ValueMetaBoolean(this.fieldName[i]);
                    break;
                }
                default: {
                    v = new ValueMetaNone(this.fieldName[i]);
                }
            }
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    <fields>" + Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"type", (String)(this.fieldType[i] != null ? this.fieldType[i].getCode() : "")));
            retval.append("        </field>" + Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldType[i] = SystemDataMeta.getType(rep.getStepAttributeString(id_step, i, "field_type"));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", this.fieldType[i] != null ? this.fieldType[i].getCode() : "");
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        int nrRemarks = remarks.size();
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (this.fieldType[i].ordinal() > SystemDataTypes.TYPE_SYSTEM_INFO_NONE.ordinal()) continue;
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SystemDataMeta.CheckResult.FieldHasNoType", (String[])new String[]{this.fieldName[i]}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (remarks.size() == nrRemarks) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SystemDataMeta.CheckResult.AllTypesSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public Map<String, String> getUsedArguments() {
        HashMap<String, String> stepArgs = new HashMap<String, String>();
        DecimalFormat df = new DecimalFormat("00");
        for (int argNr = 0; argNr < 10; ++argNr) {
            boolean found = false;
            for (int i = 0; i < this.fieldName.length; ++i) {
                if (this.fieldType[i].ordinal() != SystemDataTypes.TYPE_SYSTEM_INFO_ARGUMENT_01.ordinal() + argNr) continue;
                found = true;
            }
            if (!found) continue;
            stepArgs.put(df.format(argNr + 1), "");
        }
        return stepArgs;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SystemData(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SystemDataData();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SystemDataMeta)) {
            return false;
        }
        SystemDataMeta that = (SystemDataMeta)o;
        if (!Arrays.equals(this.fieldName, that.fieldName)) {
            return false;
        }
        return Arrays.equals((Object[])this.fieldType, (Object[])that.fieldType);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.fieldName);
        result = 31 * result + Arrays.hashCode((Object[])this.fieldType);
        return result;
    }
}

