/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.query.index;

import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.query.QueryCache;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.indices.cache.query.IndicesQueryCache;

public class IndexQueryCache
extends AbstractIndexComponent
implements QueryCache {
    final IndicesQueryCache indicesQueryCache;

    @Inject
    public IndexQueryCache(Index index, IndexSettingsService indexSettingsService, IndicesQueryCache indicesQueryCache) {
        super(index, indexSettingsService.getSettings());
        this.indicesQueryCache = indicesQueryCache;
    }

    @Override
    public void close() throws ElasticsearchException {
        this.clear("close");
    }

    @Override
    public void clear(String reason) {
        this.logger.debug("full cache clear, reason [{}]", reason);
        this.indicesQueryCache.clearIndex(this.index.getName());
    }

    public Weight doCache(Weight weight, QueryCachingPolicy policy) {
        return this.indicesQueryCache.doCache(weight, policy);
    }
}

