/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.TypeParsers;

public class FieldNamesFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_field_names";
    public static final String CONTENT_TYPE = "_field_names";
    private final boolean pre13Index;

    private FieldNamesFieldMapper(Settings indexSettings, MappedFieldType existing) {
        this(existing == null ? Defaults.FIELD_TYPE.clone() : existing.clone(), indexSettings);
    }

    private FieldNamesFieldMapper(MappedFieldType fieldType, Settings indexSettings) {
        super("_field_names", fieldType, Defaults.FIELD_TYPE, indexSettings);
        this.pre13Index = Version.indexCreated(indexSettings).before(Version.V_1_3_0);
        if (this.pre13Index) {
            FieldNamesFieldType newFieldType = this.fieldType().clone();
            newFieldType.setEnabled(false);
            newFieldType.freeze();
            this.fieldTypeRef.set(newFieldType);
        }
    }

    @Override
    public FieldNamesFieldType fieldType() {
        return (FieldNamesFieldType)super.fieldType();
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        return null;
    }

    static Iterable<String> extractFieldNames(final String fullPath) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new UnmodifiableIterator<String>(){
                    int endIndex = this.nextEndIndex(0);

                    private int nextEndIndex(int index) {
                        while (index < fullPath.length() && fullPath.charAt(index) != '.') {
                            ++index;
                        }
                        return index;
                    }

                    public boolean hasNext() {
                        return this.endIndex <= fullPath.length();
                    }

                    public String next() {
                        String result = fullPath.substring(0, this.endIndex);
                        this.endIndex = this.nextEndIndex(this.endIndex + 1);
                        return result;
                    }
                };
            }
        };
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        if (!this.fieldType().isEnabled()) {
            return;
        }
        for (ParseContext.Document document : context.docs()) {
            ArrayList<String> paths = new ArrayList<String>();
            for (IndexableField field : document.getFields()) {
                paths.add(field.name());
            }
            for (String path : paths) {
                for (String fieldName : FieldNamesFieldMapper.extractFieldNames(path)) {
                    if (this.fieldType().indexOptions() == IndexOptions.NONE && !this.fieldType().stored()) continue;
                    document.add((IndexableField)new Field(this.fieldType().names().indexName(), fieldName, (FieldType)this.fieldType()));
                }
            }
        }
    }

    @Override
    protected String contentType() {
        return "_field_names";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.pre13Index) {
            return builder;
        }
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.fieldType().isEnabled()) {
            return builder;
        }
        builder.startObject("_field_names");
        if (includeDefaults || !this.fieldType().isEnabled()) {
            builder.field("enabled", this.fieldType().isEnabled());
        }
        if (this.indexCreatedBefore2x && (includeDefaults || !this.fieldType().equals((Object)Defaults.FIELD_TYPE))) {
            super.doXContentBody(builder, includeDefaults, params);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public boolean isGenerated() {
        return true;
    }

    public static final class FieldNamesFieldType
    extends MappedFieldType {
        private boolean enabled = true;

        public FieldNamesFieldType() {
            this.setFieldDataType(new FieldDataType("string"));
        }

        protected FieldNamesFieldType(FieldNamesFieldType ref) {
            super(ref);
            this.enabled = ref.enabled;
        }

        @Override
        public FieldNamesFieldType clone() {
            return new FieldNamesFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            FieldNamesFieldType that = (FieldNamesFieldType)((Object)o);
            return this.enabled == that.enabled;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.enabled);
        }

        @Override
        public String typeName() {
            return "_field_names";
        }

        @Override
        public void checkCompatibility(MappedFieldType fieldType, List<String> conflicts, boolean strict) {
            super.checkCompatibility(fieldType, conflicts, strict);
            if (strict) {
                FieldNamesFieldType other = (FieldNamesFieldType)fieldType;
                if (this.isEnabled() != other.isEnabled()) {
                    conflicts.add("mapper [" + this.names().fullName() + "] is used by multiple types. Set update_all_types to true to update [enabled] across all types.");
                }
            }
        }

        public void setEnabled(boolean enabled) {
            this.checkIfFrozen();
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public String value(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }

        @Override
        public boolean useTermQueryWithQueryString() {
            return true;
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        public MetadataFieldMapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            if (parserContext.indexVersionCreated().before(Version.V_1_3_0)) {
                throw new IllegalArgumentException("type=_field_names is not supported on indices created before version 1.3.0. Is your cluster running multiple datanode versions?");
            }
            Builder builder = new Builder(parserContext.mapperService().fullName("_field_names"));
            if (parserContext.indexVersionCreated().before(Version.V_2_0_0_beta1)) {
                TypeParsers.parseField(builder, builder.name, node, parserContext);
            }
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("enabled")) continue;
                builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
                iterator.remove();
            }
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(Settings indexSettings, MappedFieldType fieldType, String typeName) {
            return new FieldNamesFieldMapper(indexSettings, fieldType);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, FieldNamesFieldMapper> {
        private boolean enabled = true;

        public Builder(MappedFieldType existing) {
            super("_field_names", existing == null ? Defaults.FIELD_TYPE : existing, Defaults.FIELD_TYPE);
            this.indexName = "_field_names";
        }

        @Override
        @Deprecated
        public Builder index(boolean index) {
            this.enabled(index);
            return (Builder)super.index(index);
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public FieldNamesFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            this.fieldType.setHasDocValues(false);
            FieldNamesFieldType fieldNamesFieldType = (FieldNamesFieldType)this.fieldType;
            fieldNamesFieldType.setEnabled(this.enabled);
            return new FieldNamesFieldMapper(this.fieldType, context.indexSettings());
        }
    }

    public static class Defaults {
        public static final String NAME = "_field_names";
        public static final boolean ENABLED = true;
        public static final MappedFieldType FIELD_TYPE = new FieldNamesFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setNames(new MappedFieldType.Names("_field_names"));
            FIELD_TYPE.freeze();
        }
    }
}

