/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.json.JSONObject;

public class ATSHook
implements ExecuteWithHookContext {
    private static final Log LOG = LogFactory.getLog((String)ATSHook.class.getName());
    private static final Object LOCK = new Object();
    private static ExecutorService executor;
    private static TimelineClient timelineClient;
    private static final int WAIT_TIME = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ATSHook() {
        Object object = LOCK;
        synchronized (object) {
            if (executor == null) {
                executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ATS Logger %d").build());
                YarnConfiguration yarnConf = new YarnConfiguration();
                timelineClient = TimelineClient.createTimelineClient();
                timelineClient.init((Configuration)yarnConf);
                timelineClient.start();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            executor.shutdown();
                            executor.awaitTermination(3L, TimeUnit.SECONDS);
                            executor = null;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        timelineClient.stop();
                    }
                });
            }
        }
        LOG.info((Object)"Created ATS Hook");
    }

    @Override
    public void run(final HookContext hookContext) throws Exception {
        final long currentTime = System.currentTimeMillis();
        final HiveConf conf = new HiveConf(hookContext.getConf());
        executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    int numTezJobs;
                    int numMrJobs;
                    QueryPlan plan = hookContext.getQueryPlan();
                    if (plan == null) {
                        return;
                    }
                    String queryId = plan.getQueryId();
                    String opId = hookContext.getOperationId();
                    long queryStartTime = plan.getQueryStartTime();
                    String user = hookContext.getUgi().getUserName();
                    String requestuser = hookContext.getUserName();
                    if (hookContext.getUserName() == null) {
                        requestuser = hookContext.getUgi().getUserName();
                    }
                    if ((numMrJobs = Utilities.getMRTasks(plan.getRootTasks()).size()) + (numTezJobs = Utilities.getTezTasks(plan.getRootTasks()).size()) <= 0) {
                        return;
                    }
                    switch (hookContext.getHookType()) {
                        case PRE_EXEC_HOOK: {
                            ExplainTask explain = new ExplainTask();
                            explain.initialize(conf, plan, null);
                            String query = plan.getQueryStr();
                            ArrayList<Task<?>> rootTasks = plan.getRootTasks();
                            JSONObject explainPlan = explain.getJSONPlan(null, null, rootTasks, plan.getFetchTask(), true, false, false);
                            ATSHook.this.fireAndForget(conf, ATSHook.this.createPreHookEvent(queryId, query, explainPlan, queryStartTime, user, requestuser, numMrJobs, numTezJobs, opId));
                            break;
                        }
                        case POST_EXEC_HOOK: {
                            ATSHook.this.fireAndForget(conf, ATSHook.this.createPostHookEvent(queryId, currentTime, user, requestuser, true, opId));
                            break;
                        }
                        case ON_FAILURE_HOOK: {
                            ATSHook.this.fireAndForget(conf, ATSHook.this.createPostHookEvent(queryId, currentTime, user, requestuser, false, opId));
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    LOG.info((Object)("Failed to submit plan to ATS: " + StringUtils.stringifyException((Throwable)e)));
                }
            }
        });
    }

    TimelineEntity createPreHookEvent(String queryId, String query, JSONObject explainPlan, long startTime, String user, String requestuser, int numMrJobs, int numTezJobs, String opId) throws Exception {
        JSONObject queryObj = new JSONObject();
        queryObj.put("queryText", query);
        queryObj.put("queryPlan", explainPlan);
        LOG.info((Object)("Received pre-hook notification for :" + queryId));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Otherinfo: " + queryObj.toString()));
            LOG.debug((Object)("Operation id: <" + opId + ">"));
        }
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId(queryId);
        atsEntity.setEntityType(EntityTypes.HIVE_QUERY_ID.name());
        atsEntity.addPrimaryFilter(PrimaryFilterTypes.user.name(), (Object)user);
        atsEntity.addPrimaryFilter(PrimaryFilterTypes.requestuser.name(), (Object)requestuser);
        if (opId != null) {
            atsEntity.addPrimaryFilter(PrimaryFilterTypes.operationid.name(), (Object)opId);
        }
        TimelineEvent startEvt = new TimelineEvent();
        startEvt.setEventType(EventTypes.QUERY_SUBMITTED.name());
        startEvt.setTimestamp(startTime);
        atsEntity.addEvent(startEvt);
        atsEntity.addOtherInfo(OtherInfoTypes.QUERY.name(), (Object)queryObj.toString());
        atsEntity.addOtherInfo(OtherInfoTypes.TEZ.name(), (Object)(numTezJobs > 0 ? 1 : 0));
        atsEntity.addOtherInfo(OtherInfoTypes.MAPRED.name(), (Object)(numMrJobs > 0 ? 1 : 0));
        return atsEntity;
    }

    TimelineEntity createPostHookEvent(String queryId, long stopTime, String user, String requestuser, boolean success, String opId) {
        LOG.info((Object)("Received post-hook notification for :" + queryId));
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId(queryId);
        atsEntity.setEntityType(EntityTypes.HIVE_QUERY_ID.name());
        atsEntity.addPrimaryFilter(PrimaryFilterTypes.user.name(), (Object)user);
        atsEntity.addPrimaryFilter(PrimaryFilterTypes.requestuser.name(), (Object)requestuser);
        if (opId != null) {
            atsEntity.addPrimaryFilter(PrimaryFilterTypes.operationid.name(), (Object)opId);
        }
        TimelineEvent stopEvt = new TimelineEvent();
        stopEvt.setEventType(EventTypes.QUERY_COMPLETED.name());
        stopEvt.setTimestamp(stopTime);
        atsEntity.addEvent(stopEvt);
        atsEntity.addOtherInfo(OtherInfoTypes.STATUS.name(), (Object)success);
        return atsEntity;
    }

    synchronized void fireAndForget(Configuration conf, TimelineEntity entity) throws Exception {
        timelineClient.putEntities(new TimelineEntity[]{entity});
    }

    private static enum PrimaryFilterTypes {
        user,
        requestuser,
        operationid;

    }

    private static enum OtherInfoTypes {
        QUERY,
        STATUS,
        TEZ,
        MAPRED;

    }

    private static enum EventTypes {
        QUERY_SUBMITTED,
        QUERY_COMPLETED;

    }

    private static enum EntityTypes {
        HIVE_QUERY_ID;

    }
}

