/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.FileSplit;

public class OrcSplit
extends FileSplit {
    private ReaderImpl.FileMetaInfo fileMetaInfo;
    private boolean hasFooter;
    private boolean isOriginal;
    private boolean hasBase;
    private final List<Long> deltas = new ArrayList<Long>();
    private OrcFile.WriterVersion writerVersion;
    private long projColsUncompressedSize;
    static final int BASE_FLAG = 4;
    static final int ORIGINAL_FLAG = 2;
    static final int FOOTER_FLAG = 1;

    protected OrcSplit() {
        super(null, 0L, 0L, (String[])null);
    }

    public OrcSplit(Path path, long offset, long length, String[] hosts, ReaderImpl.FileMetaInfo fileMetaInfo, boolean isOriginal, boolean hasBase, List<Long> deltas, long projectedDataSize) {
        super(path, offset, length, hosts);
        this.fileMetaInfo = fileMetaInfo;
        this.hasFooter = this.fileMetaInfo != null;
        this.isOriginal = isOriginal;
        this.hasBase = hasBase;
        this.deltas.addAll(deltas);
        this.projColsUncompressedSize = projectedDataSize;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        int flags = (this.hasBase ? 4 : 0) | (this.isOriginal ? 2 : 0) | (this.hasFooter ? 1 : 0);
        out.writeByte(flags);
        out.writeInt(this.deltas.size());
        for (Long delta : this.deltas) {
            out.writeLong(delta);
        }
        if (this.hasFooter) {
            Text.writeString((DataOutput)out, (String)this.fileMetaInfo.compressionType);
            WritableUtils.writeVInt((DataOutput)out, (int)this.fileMetaInfo.bufferSize);
            WritableUtils.writeVInt((DataOutput)out, (int)this.fileMetaInfo.metadataSize);
            ByteBuffer footerBuff = this.fileMetaInfo.footerBuffer;
            footerBuff.reset();
            WritableUtils.writeVInt((DataOutput)out, (int)(footerBuff.limit() - footerBuff.position()));
            out.write(footerBuff.array(), footerBuff.position(), footerBuff.limit() - footerBuff.position());
            WritableUtils.writeVInt((DataOutput)out, (int)this.fileMetaInfo.writerVersion.getId());
        }
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        byte flags = in.readByte();
        this.hasFooter = (1 & flags) != 0;
        this.isOriginal = (2 & flags) != 0;
        this.hasBase = (4 & flags) != 0;
        this.deltas.clear();
        int numDeltas = in.readInt();
        for (int i = 0; i < numDeltas; ++i) {
            this.deltas.add(in.readLong());
        }
        if (this.hasFooter) {
            String compressionType = Text.readString((DataInput)in);
            int bufferSize = WritableUtils.readVInt((DataInput)in);
            int metadataSize = WritableUtils.readVInt((DataInput)in);
            int footerBuffSize = WritableUtils.readVInt((DataInput)in);
            ByteBuffer footerBuff = ByteBuffer.allocate(footerBuffSize);
            in.readFully(footerBuff.array(), 0, footerBuffSize);
            OrcFile.WriterVersion writerVersion = ReaderImpl.getWriterVersion(WritableUtils.readVInt((DataInput)in));
            this.fileMetaInfo = new ReaderImpl.FileMetaInfo(compressionType, bufferSize, metadataSize, footerBuff, writerVersion);
        }
    }

    ReaderImpl.FileMetaInfo getFileMetaInfo() {
        return this.fileMetaInfo;
    }

    public boolean hasFooter() {
        return this.hasFooter;
    }

    public boolean isOriginal() {
        return this.isOriginal;
    }

    public boolean hasBase() {
        return this.hasBase;
    }

    public List<Long> getDeltas() {
        return this.deltas;
    }

    public long getProjectedColumnsUncompressedSize() {
        return this.projColsUncompressedSize;
    }
}

