/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.core;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.aries.rsa.core.Activator;
import org.apache.aries.rsa.core.RemoteServiceAdminCore;
import org.apache.aries.rsa.core.RemoteServiceadminFactory;
import org.apache.aries.rsa.spi.DistributionProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributionProviderTracker
extends ServiceTracker<DistributionProvider, ServiceRegistration> {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);

    public DistributionProviderTracker(BundleContext context) {
        super(context, DistributionProvider.class, null);
    }

    public ServiceRegistration addingService(ServiceReference<DistributionProvider> reference) {
        LOG.debug("RemoteServiceAdmin Implementation is starting up");
        DistributionProvider provider = (DistributionProvider)this.context.getService(reference);
        BundleContext apiContext = this.getAPIContext();
        RemoteServiceAdminCore rsaCore = new RemoteServiceAdminCore(this.context, apiContext, provider);
        RemoteServiceadminFactory rsaf = new RemoteServiceadminFactory(rsaCore);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("remote.intents.supported", this.getPropertyNullSafe(reference, "remote.intents.supported"));
        ((Dictionary)props).put("remote.configs.supported", this.getPropertyNullSafe(reference, "remote.configs.supported"));
        LOG.info("Registering RemoteServiceAdmin for provider " + provider.getClass().getName());
        return this.context.registerService(RemoteServiceAdmin.class.getName(), (Object)rsaf, props);
    }

    private Object getPropertyNullSafe(ServiceReference<DistributionProvider> reference, String key) {
        Object value = reference.getProperty(key);
        return value == null ? "" : value;
    }

    protected BundleContext getAPIContext() {
        Bundle apiBundle = FrameworkUtil.getBundle(DistributionProvider.class);
        try {
            apiBundle.start();
        }
        catch (BundleException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        BundleContext apiContext = apiBundle.getBundleContext();
        return apiContext;
    }

    public void removedService(ServiceReference<DistributionProvider> reference, ServiceRegistration reg) {
        LOG.debug("RemoteServiceAdmin Implementation is shutting down now");
        reg.unregister();
        super.removedService(reference, (Object)reg);
    }
}

