/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import com.pentaho.di.services.PentahoDiPlugin;
import com.pentaho.pdi.ws.IRepositorySyncWebService;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.util.ExecutorUtil;
import org.pentaho.di.repository.pur.ServiceManager;
import org.pentaho.di.repository.pur.UnifiedRepositoryInvocationHandler;
import org.pentaho.di.repository.pur.WebServiceSpecification;
import org.pentaho.platform.repository2.unified.webservices.jaxws.IUnifiedRepositoryJaxwsWebService;
import org.pentaho.platform.security.policy.rolebased.ws.IAuthorizationPolicyWebService;
import org.pentaho.platform.security.policy.rolebased.ws.IRoleAuthorizationPolicyRoleBindingDaoWebService;
import org.pentaho.platform.security.userrole.ws.IUserRoleListWebService;
import org.pentaho.platform.security.userroledao.ws.IUserRoleWebService;

public class WebServiceManager
implements ServiceManager {
    private static final String TRUST_USER = "_trust_user_";
    private static final String NAMESPACE_URI = "http://www.pentaho.org/ws/1.0";
    private static final ExecutorService executor = ExecutorUtil.getExecutor();
    private final Map<String, Future<Object>> serviceCache = new HashMap<String, Future<Object>>();
    private final Map<Class<?>, WebServiceSpecification> serviceNameMap;
    private final String baseUrl;
    private final String lastUsername;
    private Map<Class<?>, WebServiceSpecification> tempServiceNameMap;

    public WebServiceManager(String baseUrl, String username) {
        this.baseUrl = baseUrl;
        this.lastUsername = username;
        this.tempServiceNameMap = new HashMap();
        this.registerWsSpecification(IUnifiedRepositoryJaxwsWebService.class, "unifiedRepository");
        this.registerWsSpecification(IRepositorySyncWebService.class, "repositorySync");
        this.registerWsSpecification(IUserRoleListWebService.class, "userRoleListService");
        this.registerWsSpecification(IUserRoleWebService.class, "userRoleService");
        this.registerWsSpecification(IRoleAuthorizationPolicyRoleBindingDaoWebService.class, "roleBindingDao");
        this.registerWsSpecification(IAuthorizationPolicyWebService.class, "authorizationPolicy");
        this.registerRestSpecification(PentahoDiPlugin.PurRepositoryPluginApiRevision.class, "purRepositoryPluginApiRevision");
        this.serviceNameMap = Collections.unmodifiableMap(this.tempServiceNameMap);
        this.tempServiceNameMap = null;
    }

    @Override
    public <T> T createService(final String username, final String password, final Class<T> clazz) throws MalformedURLException {
        Map<String, Future<Object>> map = this.serviceCache;
        synchronized (map) {
            Future<Object> resultFuture;
            if (this.lastUsername != null && !this.lastUsername.equals(username)) {
                throw new IllegalStateException();
            }
            final WebServiceSpecification webServiceSpecification = this.serviceNameMap.get(clazz);
            final String serviceName = webServiceSpecification.getServiceName();
            if (serviceName == null) {
                throw new IllegalStateException();
            }
            if (webServiceSpecification.getServiceType().equals((Object)WebServiceSpecification.ServiceType.JAX_WS)) {
                final URL url = new URL(this.baseUrl + (this.baseUrl.endsWith("/") ? "" : "/") + "webservices/" + serviceName + "?wsdl");
                String key = url.toString() + '_' + serviceName + '_' + clazz.getName();
                if (!this.serviceCache.containsKey(key)) {
                    resultFuture = executor.submit(new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            Service service = Service.create((URL)url, (QName)new QName(WebServiceManager.NAMESPACE_URI, serviceName));
                            Object port = service.getPort(clazz);
                            if (StringUtils.isNotBlank((String)System.getProperty("pentaho.repository.client.attemptTrust"))) {
                                ((BindingProvider)port).getRequestContext().put("javax.xml.ws.http.request.headers", Collections.singletonMap(WebServiceManager.TRUST_USER, Collections.singletonList(username)));
                            } else {
                                ((BindingProvider)port).getRequestContext().put("javax.xml.ws.security.auth.username", username);
                                ((BindingProvider)port).getRequestContext().put("javax.xml.ws.security.auth.password", password);
                            }
                            ((BindingProvider)port).getRequestContext().put("javax.xml.ws.session.maintain", true);
                            ((BindingProvider)port).getRequestContext().put("com.sun.xml.ws.transport.http.client.streaming.chunk.size", 8192);
                            SOAPBinding binding = (SOAPBinding)((BindingProvider)port).getBinding();
                            binding.setMTOMEnabled(true);
                            return port;
                        }
                    });
                    this.serviceCache.put(key, resultFuture);
                } else {
                    resultFuture = this.serviceCache.get(key);
                }
            } else if (webServiceSpecification.getServiceType().equals((Object)WebServiceSpecification.ServiceType.JAX_RS)) {
                String key = this.baseUrl.toString() + '_' + serviceName + '_' + clazz.getName();
                if (!this.serviceCache.containsKey(key)) {
                    resultFuture = executor.submit(new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            DefaultClientConfig clientConfig = new DefaultClientConfig();
                            Client client = Client.create((ClientConfig)clientConfig);
                            client.addFilter((ClientFilter)new HTTPBasicAuthFilter(username, password));
                            Class[] parameterTypes = new Class[]{Client.class, URI.class};
                            String factoryClassName = webServiceSpecification.getServiceClass().getName();
                            factoryClassName = factoryClassName.substring(0, factoryClassName.lastIndexOf("$"));
                            Class<?> factoryClass = Class.forName(factoryClassName);
                            Method method = factoryClass.getDeclaredMethod(webServiceSpecification.getServiceName(), parameterTypes);
                            Object port = method.invoke(null, client, new URI(WebServiceManager.this.baseUrl + "/plugin"));
                            return port;
                        }
                    });
                    this.serviceCache.put(key, resultFuture);
                } else {
                    resultFuture = this.serviceCache.get(key);
                }
            } else {
                resultFuture = null;
            }
            try {
                if (clazz.isInterface()) {
                    return (T)UnifiedRepositoryInvocationHandler.forObject(resultFuture.get(), clazz);
                }
                return (T)resultFuture.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof MalformedURLException) {
                        throw (MalformedURLException)cause;
                    }
                }
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public synchronized void close() {
        this.serviceCache.clear();
    }

    private void registerWsSpecification(Class<?> serviceClass, String serviceName) {
        this.registerSpecification(WebServiceSpecification.getWsServiceSpecification(serviceClass, serviceName));
    }

    private void registerRestSpecification(Class<?> serviceClass, String serviceName) {
        try {
            this.registerSpecification(WebServiceSpecification.getRestServiceSpecification(serviceClass, serviceName));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    private void registerSpecification(WebServiceSpecification webServiceSpecification) {
        this.tempServiceNameMap.put(webServiceSpecification.getServiceClass(), webServiceSpecification);
    }
}

