/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
public class WALInputFormat
extends InputFormat<WALKey, WALEdit> {
    private static final Log LOG = LogFactory.getLog(WALInputFormat.class);
    public static final String START_TIME_KEY = "wal.start.time";
    public static final String END_TIME_KEY = "wal.end.time";

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        return this.getSplits(context, START_TIME_KEY, END_TIME_KEY);
    }

    List<InputSplit> getSplits(JobContext context, String startKey, String endKey) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        Path[] inputPaths = this.getInputPaths(conf);
        long startTime = conf.getLong(startKey, Long.MIN_VALUE);
        long endTime = conf.getLong(endKey, Long.MAX_VALUE);
        ArrayList<FileStatus> allFiles = new ArrayList<FileStatus>();
        for (Path inputPath : inputPaths) {
            FileSystem fs = inputPath.getFileSystem(conf);
            List<FileStatus> files = this.getFiles(fs, inputPath, startTime, endTime);
            allFiles.addAll(files);
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(allFiles.size());
        for (FileStatus file : allFiles) {
            splits.add(new WALSplit(file.getPath().toString(), file.getLen(), startTime, endTime));
        }
        return splits;
    }

    private Path[] getInputPaths(Configuration conf) {
        String inpDirs = conf.get("mapreduce.input.fileinputformat.inputdir");
        return StringUtils.stringToPath((String[])inpDirs.split(","));
    }

    private List<FileStatus> getFiles(FileSystem fs, Path dir, long startTime, long endTime) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        LOG.debug((Object)("Scanning " + dir.toString() + " for WAL files"));
        FileStatus[] files = fs.listStatus(dir);
        if (files == null) {
            return Collections.emptyList();
        }
        for (FileStatus file : files) {
            if (file.isDirectory()) {
                result.addAll(this.getFiles(fs, file.getPath(), startTime, endTime));
                continue;
            }
            String name = file.getPath().toString();
            int idx = name.lastIndexOf(46);
            if (idx > 0) {
                try {
                    long fileStartTime = Long.parseLong(name.substring(idx + 1));
                    if (fileStartTime <= endTime) {
                        LOG.info((Object)("Found: " + name));
                        result.add(file);
                    }
                }
                catch (NumberFormatException x) {
                    idx = 0;
                }
            }
            if (idx != 0) continue;
            LOG.warn((Object)("File " + name + " does not appear to be an WAL file. Skipping..."));
        }
        return result;
    }

    public RecordReader<WALKey, WALEdit> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new WALKeyRecordReader();
    }

    static class WALKeyRecordReader
    extends WALRecordReader<WALKey> {
        WALKeyRecordReader() {
        }

        public WALKey getCurrentKey() throws IOException, InterruptedException {
            return this.currentEntry.getKey();
        }
    }

    static abstract class WALRecordReader<K extends WALKey>
    extends RecordReader<K, WALEdit> {
        private WAL.Reader reader = null;
        WAL.Entry currentEntry = new WAL.Entry();
        private long startTime;
        private long endTime;

        WALRecordReader() {
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            WALSplit hsplit = (WALSplit)split;
            Path logFile = new Path(hsplit.getLogFileName());
            Configuration conf = context.getConfiguration();
            LOG.info((Object)("Opening reader for " + split));
            try {
                this.reader = WALFactory.createReader(logFile.getFileSystem(conf), logFile, conf);
            }
            catch (EOFException x) {
                LOG.info((Object)("Ignoring corrupted WAL file: " + logFile + " (This is normal when a RegionServer crashed.)"));
                this.reader = null;
            }
            this.startTime = hsplit.getStartTime();
            this.endTime = hsplit.getEndTime();
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            boolean res;
            WAL.Entry temp;
            if (this.reader == null) {
                return false;
            }
            long i = -1L;
            do {
                try {
                    temp = this.reader.next(this.currentEntry);
                    ++i;
                }
                catch (EOFException x) {
                    LOG.info((Object)"Corrupted entry detected. Ignoring the rest of the file. (This is normal when a RegionServer crashed.)");
                    return false;
                }
            } while (temp != null && temp.getKey().getWriteTime() < this.startTime);
            if (temp == null) {
                if (i > 0L) {
                    LOG.info((Object)("Skipped " + i + " entries."));
                }
                LOG.info((Object)"Reached end of file.");
                return false;
            }
            if (i > 0L) {
                LOG.info((Object)("Skipped " + i + " entries, until ts: " + temp.getKey().getWriteTime() + "."));
            }
            boolean bl = res = temp.getKey().getWriteTime() <= this.endTime;
            if (!res) {
                LOG.info((Object)("Reached ts: " + temp.getKey().getWriteTime() + " ignoring the rest of the file."));
            }
            return res;
        }

        public WALEdit getCurrentValue() throws IOException, InterruptedException {
            return this.currentEntry.getEdit();
        }

        public float getProgress() throws IOException, InterruptedException {
            return 0.0f;
        }

        public void close() throws IOException {
            LOG.info((Object)"Closing reader");
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    static class WALSplit
    extends InputSplit
    implements Writable {
        private String logFileName;
        private long fileSize;
        private long startTime;
        private long endTime;

        public WALSplit() {
        }

        public WALSplit(String logFileName, long fileSize, long startTime, long endTime) {
            this.logFileName = logFileName;
            this.fileSize = fileSize;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public long getLength() throws IOException, InterruptedException {
            return this.fileSize;
        }

        public String[] getLocations() throws IOException, InterruptedException {
            return new String[0];
        }

        public String getLogFileName() {
            return this.logFileName;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void readFields(DataInput in) throws IOException {
            this.logFileName = in.readUTF();
            this.fileSize = in.readLong();
            this.startTime = in.readLong();
            this.endTime = in.readLong();
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.logFileName);
            out.writeLong(this.fileSize);
            out.writeLong(this.startTime);
            out.writeLong(this.endTime);
        }

        public String toString() {
            return this.logFileName + " (" + this.startTime + ":" + this.endTime + ") length:" + this.fileSize;
        }
    }
}

