/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.util.List;
import java.util.Map;
import org.apache.oozie.BundleJobInfo;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.executor.jpa.BundleJobInfoGetJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;

public class BundleJobsXCommand
extends XCommand<BundleJobInfo> {
    private Map<String, List<String>> filter;
    private int start = 1;
    private int len = 50;

    public BundleJobsXCommand(Map<String, List<String>> filter, int start, int length) {
        super("bundle.job.info", "bundle.job.info", 1);
        this.filter = filter;
        this.start = start;
        this.len = length;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected void loadState() throws CommandException {
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    protected BundleJobInfo execute() throws CommandException {
        try {
            JPAService jpaService = Services.get().get(JPAService.class);
            BundleJobInfo bundleInfo = null;
            if (jpaService != null) {
                bundleInfo = jpaService.execute(new BundleJobInfoGetJPAExecutor(this.filter, this.start, this.len));
            } else {
                this.LOG.error((Object)ErrorCode.E0610);
            }
            return bundleInfo;
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }
}

