/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.blob;

import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.blob.BlobDeserializationHelper;
import com.microsoft.windowsazure.storage.blob.PageRange;
import com.microsoft.windowsazure.storage.core.Utility;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class GetPageRangesResponse {
    private ArrayList<PageRange> pageRanges = new ArrayList();

    protected GetPageRangesResponse(InputStream stream) throws XMLStreamException, StorageException {
        this.parseResponse(stream);
    }

    protected ArrayList<PageRange> getPageRanges() {
        return this.pageRanges;
    }

    private void parseResponse(InputStream streamRef) throws XMLStreamException, StorageException {
        XMLStreamReader xmlr = Utility.createXMLStreamReaderFromStream((InputStream)streamRef);
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "PageList");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType != 1 && eventType != 2) continue;
            String name = xmlr.getName().toString();
            if (name.equals("PageRange")) {
                this.pageRanges = BlobDeserializationHelper.readPageRanges(xmlr);
                continue;
            }
            if (name.equals("PageList") && eventType == 2) break;
            throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
        }
    }
}

