/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.core;

import com.microsoft.windowsazure.storage.StorageExtendedErrorInformation;
import com.microsoft.windowsazure.storage.core.Utility;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class StorageErrorResponse {
    private final StorageExtendedErrorInformation errorInfo;
    private boolean isParsed;
    private XMLStreamReader xmlr = null;

    public StorageErrorResponse(InputStream stream) throws XMLStreamException {
        this.xmlr = Utility.createXMLStreamReaderFromStream((InputStream)stream);
        this.errorInfo = new StorageExtendedErrorInformation();
    }

    public StorageErrorResponse(Reader reader) throws XMLStreamException {
        this.xmlr = Utility.createXMLStreamReaderFromReader((Reader)reader);
        this.errorInfo = new StorageExtendedErrorInformation();
    }

    public StorageExtendedErrorInformation getExtendedErrorInformation() throws XMLStreamException {
        if (!this.isParsed) {
            this.parseResponse();
        }
        return this.errorInfo;
    }

    private void parseErrorException(XMLStreamReader xmlr) throws XMLStreamException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "ExceptionDetails");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 4) continue;
            String name = xmlr.getName().toString();
            if (eventType == 1 && name.equals("ExceptionMessage")) {
                String errorExceptionMessage = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"ExceptionMessage");
                this.errorInfo.getAdditionalDetails().put("ExceptionMessage", new String[]{errorExceptionMessage});
                continue;
            }
            if (eventType == 1 && name.equals("StackTrace")) {
                String errorExceptionStack = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"StackTrace");
                this.errorInfo.getAdditionalDetails().put("StackTrace", new String[]{errorExceptionStack});
                continue;
            }
            if (eventType != 2) continue;
            break;
        }
        xmlr.require(2, null, "ExceptionDetails");
    }

    private void parseResponse() throws XMLStreamException {
        int eventType = this.xmlr.getEventType();
        this.xmlr.require(7, null, null);
        eventType = this.xmlr.next();
        this.xmlr.require(1, null, "Error");
        while (this.xmlr.hasNext()) {
            eventType = this.xmlr.next();
            if (eventType == 4) continue;
            if (eventType == 2) break;
            String name = this.xmlr.getName().getLocalPart().toString();
            if (eventType != 1) continue;
            if (name.equals("Code")) {
                this.errorInfo.setErrorCode(Utility.readElementFromXMLReader((XMLStreamReader)this.xmlr, (String)"Code"));
                continue;
            }
            if (name.equals("Message")) {
                this.errorInfo.setErrorMessage(Utility.readElementFromXMLReader((XMLStreamReader)this.xmlr, (String)"Message"));
                continue;
            }
            if (name.equals("ExceptionDetails")) {
                this.parseErrorException(this.xmlr);
                this.xmlr.require(2, null, "ExceptionDetails");
                continue;
            }
            String tempParseString = Utility.readElementFromXMLReader((XMLStreamReader)this.xmlr, (String)name);
            this.errorInfo.getAdditionalDetails().put(name, new String[]{tempParseString});
            this.xmlr.require(2, null, null);
        }
    }
}

