/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.queue;

import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.core.BaseRequest;
import com.microsoft.windowsazure.storage.core.ListingContext;
import com.microsoft.windowsazure.storage.core.UriQueryBuilder;
import com.microsoft.windowsazure.storage.core.Utility;
import com.microsoft.windowsazure.storage.queue.QueueListingDetails;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;

final class QueueRequest {
    private static final String POP_RECEIPT = "popreceipt";
    private static final String PEEK_ONLY = "peekonly";
    private static final String NUMBER_OF_MESSAGES = "numofmessages";
    private static final String VISIBILITY_TIMEOUT = "visibilitytimeout";
    private static final String MESSAGE_TTL = "messagettl";

    public static void addMetadata(HttpURLConnection request, HashMap<String, String> metadata, OperationContext opContext) {
        BaseRequest.addMetadata(request, metadata, opContext);
    }

    public static HttpURLConnection clearMessages(URI uri, int timeout, OperationContext opContext) throws URISyntaxException, IOException, StorageException {
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, null, opContext);
        request.setRequestMethod("DELETE");
        return request;
    }

    public static HttpURLConnection create(URI uri, int timeout, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return BaseRequest.create(uri, timeout, null, opContext);
    }

    public static HttpURLConnection delete(URI uri, int timeout, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return BaseRequest.delete(uri, timeout, null, opContext);
    }

    public static HttpURLConnection deleteMessage(URI uri, int timeout, String popReceipt, OperationContext opContext) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add(POP_RECEIPT, popReceipt);
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("DELETE");
        return request;
    }

    public static HttpURLConnection downloadAttributes(URI uri, int timeout, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return BaseRequest.getMetadata(uri, timeout, null, opContext);
    }

    public static HttpURLConnection list(URI uri, int timeout, ListingContext listingContext, QueueListingDetails detailsIncluded, OperationContext opContext) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "list");
        if (listingContext != null) {
            if (!Utility.isNullOrEmpty(listingContext.getPrefix())) {
                builder.add("prefix", listingContext.getPrefix());
            }
            if (!Utility.isNullOrEmpty(listingContext.getMarker())) {
                builder.add("marker", listingContext.getMarker());
            }
            if (listingContext.getMaxResults() != null && listingContext.getMaxResults() > 0) {
                builder.add("maxresults", listingContext.getMaxResults().toString());
            }
        }
        if (detailsIncluded == QueueListingDetails.ALL || detailsIncluded == QueueListingDetails.METADATA) {
            builder.add("include", "metadata");
        }
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    public static HttpURLConnection peekMessages(URI uri, int timeout, int numberOfMessages, OperationContext opContext) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add(PEEK_ONLY, "true");
        if (numberOfMessages != 0) {
            builder.add(NUMBER_OF_MESSAGES, Integer.toString(numberOfMessages));
        }
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    public static HttpURLConnection putMessage(URI uri, int timeout, int visibilityTimeoutInSeconds, int timeToLiveInSeconds, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        if (visibilityTimeoutInSeconds != 0) {
            builder.add(VISIBILITY_TIMEOUT, Integer.toString(visibilityTimeoutInSeconds));
        }
        if (timeToLiveInSeconds != 0) {
            builder.add(MESSAGE_TTL, Integer.toString(timeToLiveInSeconds));
        }
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("POST");
        return request;
    }

    public static HttpURLConnection retrieveMessages(URI uri, int timeout, int numberOfMessages, int visibilityTimeoutInSeconds, OperationContext opContext) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        if (numberOfMessages != 0) {
            builder.add(NUMBER_OF_MESSAGES, Integer.toString(numberOfMessages));
        }
        builder.add(VISIBILITY_TIMEOUT, Integer.toString(visibilityTimeoutInSeconds));
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    public static HttpURLConnection setMetadata(URI uri, int timeout, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return BaseRequest.setMetadata(uri, timeout, null, opContext);
    }

    public static HttpURLConnection updateMessage(URI uri, int timeout, String popReceipt, int visibilityTimeoutInSeconds, OperationContext opContext) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add(POP_RECEIPT, popReceipt);
        builder.add(VISIBILITY_TIMEOUT, Integer.toString(visibilityTimeoutInSeconds));
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        return request;
    }

    public static HttpURLConnection setAcl(URI uri, int timeout, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "acl");
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        return request;
    }

    public static HttpURLConnection getAcl(URI uri, int timeout, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "acl");
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    private QueueRequest() {
    }
}

