/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.concurrent.locks.Condition;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.cassandra.utils.SimpleCondition;

class RepairRunner
implements NotificationListener {
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private final Condition condition = new SimpleCondition();
    private final PrintStream out;
    private final String keyspace;
    private final String[] columnFamilies;
    private int cmd;
    private volatile boolean success = true;
    private volatile Exception error = null;

    RepairRunner(PrintStream out, String keyspace, String ... columnFamilies) {
        this.out = out;
        this.keyspace = keyspace;
        this.columnFamilies = columnFamilies;
    }

    public boolean repairAndWait(StorageServiceMBean ssProxy, boolean isSequential, Collection<String> dataCenters, Collection<String> hosts, boolean primaryRangeOnly) throws Exception {
        this.cmd = ssProxy.forceRepairAsync(this.keyspace, isSequential, dataCenters, hosts, primaryRangeOnly, this.columnFamilies);
        this.waitForRepair();
        return this.success;
    }

    public boolean repairRangeAndWait(StorageServiceMBean ssProxy, boolean isSequential, Collection<String> dataCenters, Collection<String> hosts, String startToken, String endToken) throws Exception {
        this.cmd = ssProxy.forceRepairRangeAsync(startToken, endToken, this.keyspace, isSequential, dataCenters, hosts, this.columnFamilies);
        this.waitForRepair();
        return this.success;
    }

    private void waitForRepair() throws Exception {
        if (this.cmd > 0) {
            this.condition.await();
        } else {
            String message = String.format("[%s] Nothing to repair for keyspace '%s'", this.format.format(System.currentTimeMillis()), this.keyspace);
            this.out.println(message);
        }
        if (this.error != null) {
            throw this.error;
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if ("repair".equals(notification.getType())) {
            int[] status = (int[])notification.getUserData();
            assert (status.length == 2);
            if (this.cmd == status[0]) {
                String message = String.format("[%s] %s", this.format.format(notification.getTimeStamp()), notification.getMessage());
                this.out.println(message);
                if (status[1] == ActiveRepairService.Status.SESSION_FAILED.ordinal()) {
                    this.success = false;
                } else if (status[1] == ActiveRepairService.Status.FINISHED.ordinal()) {
                    this.condition.signalAll();
                }
            }
        } else if ("jmx.remote.connection.notifs.lost".equals(notification.getType())) {
            String message = String.format("[%s] Lost notification. You should check server log for repair status of keyspace %s", this.format.format(notification.getTimeStamp()), this.keyspace);
            this.out.println(message);
            this.success = false;
            this.condition.signalAll();
        } else if ("jmx.remote.connection.failed".equals(notification.getType()) || "jmx.remote.connection.closed".equals(notification.getType())) {
            String message = String.format("JMX connection closed. You should check server log for repair status of keyspace %s(Subsequent keyspaces are not going to be repaired).", this.keyspace);
            this.error = new IOException(message);
            this.condition.signalAll();
        }
    }
}

