/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.command.action;

import org.apache.felix.scr.Component;
import org.apache.felix.scr.ScrService;
import org.apache.karaf.scr.command.action.ScrActionSupport;
import org.apache.karaf.scr.command.completer.DeactivateCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="scr", name="deactivate", description="Deactivates a Component for the given name")
@Service
public class DeactivateAction
extends ScrActionSupport {
    @Argument(index=0, name="name", description="The name of the Component to deactivate ", required=true, multiValued=false)
    @Completion(value=DeactivateCompleter.class)
    String name;

    @Override
    protected Object doScrAction(ScrService scrService) throws Exception {
        this.logger.debug("Deactivate Action");
        this.logger.debug("  Deactivating the Component: " + this.name);
        Component[] components = scrService.getComponents(this.name);
        if (components != null && components.length > 0) {
            for (int i = 0; i < components.length; ++i) {
                components[i].disable();
            }
        }
        return null;
    }
}

