/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.command.action;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.ScrService;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.console.CommandLine;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScrActionSupport
implements Action {
    @Option(name="-s", aliases={"--show-hidden"}, description="Show all Components including the System Components (hidden by default)", required=false, multiValued=false)
    boolean showHidden = false;
    public static final String SHOW_ALL_OPTION = "-s";
    public static final String SHOW_ALL_ALIAS = "--show-hidden";
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    @Reference
    private ScrService scrService;
    @Reference
    BundleContext bundleContext;

    public Object execute() throws Exception {
        if (this.scrService == null) {
            String msg = "ScrService is unavailable";
            System.out.println(msg);
            this.logger.warn(msg);
        } else {
            this.doScrAction(this.scrService);
        }
        return null;
    }

    protected abstract Object doScrAction(ScrService var1) throws Exception;

    protected boolean isActionable(Component component) {
        boolean answer = true;
        return answer;
    }

    public static boolean showHiddenComponent(CommandLine commandLine, Component component) {
        List<String> arguments = Arrays.asList(commandLine.getArguments());
        return arguments.contains(SHOW_ALL_OPTION) || arguments.contains(SHOW_ALL_ALIAS);
    }

    public static boolean isHiddenComponent(Component component) {
        boolean answer = false;
        Dictionary properties = component.getProperties();
        if (properties != null) {
            String value = (String)properties.get("hidden.component");
            answer = Boolean.parseBoolean(value);
        }
        return answer;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public ScrService getScrService() {
        return this.scrService;
    }

    public void setScrService(ScrService scrService) {
        this.scrService = scrService;
    }
}

