/*
 * Decompiled with CFR 0.152.
 */
package com.linuxense.javadbf;

import com.linuxense.javadbf.DBFBase;
import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFHeader;
import com.linuxense.javadbf.Utils;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.GregorianCalendar;

public class DBFReader
extends DBFBase {
    DataInputStream dataInputStream;
    DBFHeader header;
    boolean isClosed = true;

    public DBFReader(InputStream in) throws DBFException {
        try {
            this.dataInputStream = new DataInputStream(in);
            this.isClosed = false;
            this.header = new DBFHeader();
            this.header.read(this.dataInputStream);
            int t_dataStartIndex = this.header.headerLength - (32 + 32 * this.header.fieldArray.length) - 1;
            if (t_dataStartIndex > 0) {
                this.dataInputStream.skipBytes(t_dataStartIndex);
            }
        }
        catch (IOException e) {
            throw new DBFException(e.getMessage());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(String.valueOf(this.header.year) + "/" + this.header.month + "/" + this.header.day + "\n" + "Total records: " + this.header.numberOfRecords + "\nHeader length: " + this.header.headerLength);
        int i = 0;
        while (i < this.header.fieldArray.length) {
            sb.append("\n");
            sb.append(this.header.fieldArray[i].getName());
            ++i;
        }
        return sb.toString();
    }

    public int getRecordCount() {
        return this.header.numberOfRecords;
    }

    public DBFField getField(int index) throws DBFException {
        if (this.isClosed) {
            throw new DBFException("Source is not open");
        }
        return this.header.fieldArray[index];
    }

    public int getFieldCount() throws DBFException {
        if (this.isClosed) {
            throw new DBFException("Source is not open");
        }
        if (this.header.fieldArray != null) {
            return this.header.fieldArray.length;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] nextRecord() throws DBFException {
        if (this.isClosed) {
            throw new DBFException("Source is not open");
        }
        Object[] recordObjects = new Object[this.header.fieldArray.length];
        try {
            byte t_byte;
            boolean isDeleted = false;
            do {
                if (isDeleted) {
                    this.dataInputStream.skipBytes(this.header.recordLength - 1);
                }
                if ((t_byte = this.dataInputStream.readByte()) != 26) continue;
                return null;
            } while (isDeleted = t_byte != 32);
            int i = 0;
            while (true) {
                if (i >= this.header.fieldArray.length) {
                    return recordObjects;
                }
                switch (this.header.fieldArray[i].getDataType()) {
                    case 67: {
                        byte[] b_array = new byte[this.header.fieldArray[i].getFieldLength()];
                        this.dataInputStream.read(b_array);
                        recordObjects[i] = new String(b_array, this.characterSetName);
                        break;
                    }
                    case 68: {
                        byte[] t_byte_year = new byte[4];
                        this.dataInputStream.read(t_byte_year);
                        byte[] t_byte_month = new byte[2];
                        this.dataInputStream.read(t_byte_month);
                        byte[] t_byte_day = new byte[2];
                        this.dataInputStream.read(t_byte_day);
                        try {
                            GregorianCalendar calendar = new GregorianCalendar(Integer.parseInt(new String(t_byte_year)), Integer.parseInt(new String(t_byte_month)) - 1, Integer.parseInt(new String(t_byte_day)));
                            recordObjects[i] = calendar.getTime();
                        }
                        catch (NumberFormatException e) {
                            recordObjects[i] = null;
                        }
                        break;
                    }
                    case 70: {
                        String string;
                        try {
                            byte[] t_float = new byte[this.header.fieldArray[i].getFieldLength()];
                            this.dataInputStream.read(t_float);
                            t_float = Utils.trimLeftSpaces(t_float);
                            if (t_float.length > 0 && !Utils.contains(t_float, (byte)63)) {
                                string = new String(t_float);
                                if (string.equals(".")) {
                                    recordObjects[i] = Float.valueOf(0.0f);
                                    break;
                                }
                                recordObjects[i] = new Float(string);
                                break;
                            }
                            recordObjects[i] = null;
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new DBFException("Failed to parse Float: " + e.getMessage());
                        }
                    }
                    case 78: {
                        String string;
                        try {
                            byte[] t_numeric = new byte[this.header.fieldArray[i].getFieldLength()];
                            this.dataInputStream.read(t_numeric);
                            t_numeric = Utils.trimLeftSpaces(t_numeric);
                            if (t_numeric.length > 0 && !Utils.contains(t_numeric, (byte)63)) {
                                string = new String(t_numeric);
                                recordObjects[i] = string.equals(".") ? Double.valueOf(0.0) : new Double(string);
                                recordObjects[i] = new Double(new String(t_numeric));
                                break;
                            }
                            recordObjects[i] = null;
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new DBFException("Failed to parse Number: " + e.getMessage());
                        }
                    }
                    case 76: {
                        byte t_logical = this.dataInputStream.readByte();
                        if (t_logical == 89 || t_logical == 116 || t_logical == 84 || t_logical == 116) {
                            recordObjects[i] = Boolean.TRUE;
                            break;
                        }
                        recordObjects[i] = Boolean.FALSE;
                        break;
                    }
                    case 77: {
                        byte[] b_array = new byte[this.header.fieldArray[i].getFieldLength()];
                        this.dataInputStream.read(b_array);
                        recordObjects[i] = new String(b_array, this.characterSetName);
                        break;
                    }
                    case 73: {
                        recordObjects[i] = Utils.readLittleEndianInt(this.dataInputStream);
                        break;
                    }
                    default: {
                        recordObjects[i] = null;
                    }
                }
                ++i;
            }
        }
        catch (EOFException e) {
            return null;
        }
        catch (IOException e) {
            throw new DBFException(e.getMessage());
        }
    }
}

