/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.engine.daemon.service;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.spark.launcher.SparkAppHandle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.pentaho.daemon.spark.executor.api.SparkExecutor;
import org.pentaho.di.engine.api.remote.Execution;
import org.pentaho.di.engine.api.remote.ExecutionManager;
import org.pentaho.di.engine.api.remote.ExecutionRequest;
import org.pentaho.pdi.engine.daemon.service.RemoteExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteExecutionManager
implements ExecutionManager {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteExecutionManager.class);
    private final BundleContext bundleContext;
    private SparkExecutor executor;
    private ScheduledFuture<?> timeoutSchedule;
    private int driverTimeoutMillis = 180000;

    public RemoteExecutionManager(BundleContext bundleContext, SparkExecutor executor) {
        this.bundleContext = bundleContext;
        this.executor = executor;
    }

    public String getEngineType() {
        return "spark";
    }

    public String getClusterName() {
        return "default";
    }

    public Map<String, Object> getEnvironment() {
        return ImmutableMap.of();
    }

    public CompletableFuture<String> submit(ExecutionRequest request) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        UUID uuid = UUID.randomUUID();
        LOG.info("Received request, assigned id {0}", (Object)uuid);
        final RemoteExecution remoteExecution = new RemoteExecution(request, uuid);
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
        serviceProperties.put("execution.uuid", uuid.toString());
        serviceProperties.put("service.exported.interfaces", "*");
        ServiceRegistration registration = this.bundleContext.registerService(Execution.class.getName(), (Object)remoteExecution, serviceProperties);
        SparkAppHandle sparkAppHandle = this.executor.execute(uuid.toString(), request.getActingPrincipal());
        final CompletableFuture<SparkAppHandle.State> executionFinished = new CompletableFuture<SparkAppHandle.State>();
        this.startTimeoutThread(remoteExecution, executionFinished, sparkAppHandle);
        sparkAppHandle.addListener(new SparkAppHandle.Listener(){

            public void stateChanged(SparkAppHandle sparkAppHandle) {
                SparkAppHandle.State state = sparkAppHandle.getState();
                if (state.isFinal()) {
                    executionFinished.complete(state);
                    remoteExecution.close();
                }
            }

            public void infoChanged(SparkAppHandle sparkAppHandle) {
                this.stateChanged(sparkAppHandle);
            }
        });
        CompletableFuture.allOf(executionFinished, remoteExecution.streaming).whenCompleteAsync((success, throwable) -> {
            if (throwable != null) {
                LOG.error("Execution failed", throwable);
            }
            Executors.newScheduledThreadPool(1).schedule(() -> registration.unregister(), 5L, TimeUnit.SECONDS);
        });
        future.complete(uuid.toString());
        return future;
    }

    void startTimeoutThread(RemoteExecution remoteExecution, CompletableFuture<SparkAppHandle.State> executionFinished, SparkAppHandle sparkAppHandle) {
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        this.timeoutSchedule = service.schedule(() -> {
            LOG.debug("Driver timeout thread running check. Driver has claimed Execution: " + remoteExecution.isClaimed());
            if (!remoteExecution.isClaimed() && !executionFinished.isDone()) {
                remoteExecution.update((Serializable)((Object)"Error: Driver has not claimed the Execution in the allotted amount of time"));
                sparkAppHandle.kill();
            }
        }, (long)this.driverTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    public void setDriverTimeout(int driverTimeout) {
        this.driverTimeoutMillis = driverTimeout;
    }
}

