/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.ui;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.engine.configuration.api.RunConfiguration;
import org.pentaho.di.engine.configuration.api.RunConfigurationService;
import org.pentaho.di.engine.configuration.api.RunOption;
import org.pentaho.di.engine.configuration.impl.pentaho.DefaultRunConfiguration;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.util.SwtSvgImageUtil;

public class RunConfigurationDialog
extends Dialog {
    private static Class<?> PKG = RunConfigurationDialog.class;
    public static final String CLUSTERED = "Clustered";
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    private Shell shell;
    private PropsUI props;
    private Label wlName;
    private Text wName;
    private Label wlDescription;
    private Text wDescription;
    private Label wlEngine;
    private CCombo wEngine;
    private Group gOptions;
    private Button wCancel;
    private Button wOK;
    private RunConfiguration runConfiguration;
    private RunConfiguration savedRunConfiguration;
    private Map<String, RunConfiguration> runConfigurationMap = new HashMap<String, RunConfiguration>();
    private RunConfigurationService executionConfigurationManager;

    public RunConfigurationDialog(Shell parent, RunConfigurationService executionConfigurationManager, RunConfiguration runConfiguration) {
        super(parent, 0);
        this.props = PropsUI.getInstance();
        this.executionConfigurationManager = executionConfigurationManager;
        this.runConfiguration = runConfiguration;
        if (runConfiguration != null) {
            this.runConfigurationMap.put(runConfiguration.getType(), runConfiguration);
        }
    }

    public RunConfiguration open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"RunConfigurationDialog.Title", (String[])new String[0]));
        this.shell.setImage(this.getImage());
        Composite wSettings = new Composite((Composite)this.shell, 32);
        this.props.setLook((Control)wSettings);
        FormLayout specLayout = new FormLayout();
        specLayout.marginWidth = 0;
        specLayout.marginHeight = 0;
        wSettings.setLayout((Layout)specLayout);
        this.wlName = new Label(wSettings, 131072);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"RunConfigurationDialog.Label.Name", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.top = new FormAttachment(0, 0);
        this.wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(wSettings, 18436);
        this.props.setLook((Control)this.wName);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(0, 0);
        fdName.top = new FormAttachment((Control)this.wlName, 5);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        this.wName.addModifyListener(modifyEvent -> {
            this.runConfiguration.setName(this.wName.getText());
            if (Utils.isEmpty((CharSequence)this.runConfiguration.getName())) {
                this.wOK.setEnabled(false);
            } else {
                this.wOK.setEnabled(true);
            }
        });
        this.wlDescription = new Label(wSettings, 131072);
        this.wlDescription.setText(BaseMessages.getString(PKG, (String)"RunConfigurationDialog.Label.Description", (String[])new String[0]));
        this.props.setLook((Control)this.wlDescription);
        FormData fdlDescription = new FormData();
        fdlDescription.left = new FormAttachment(0, 0);
        fdlDescription.top = new FormAttachment((Control)this.wName, 10);
        this.wlDescription.setLayoutData((Object)fdlDescription);
        this.wDescription = new Text(wSettings, 18434);
        this.props.setLook((Control)this.wDescription);
        FormData fdDescription = new FormData();
        fdDescription.height = 40;
        fdDescription.left = new FormAttachment(0, 0);
        fdDescription.top = new FormAttachment((Control)this.wlDescription, 5);
        fdDescription.right = new FormAttachment(100, 0);
        this.wDescription.setLayoutData((Object)fdDescription);
        this.wDescription.addModifyListener(modifyEvent -> this.runConfiguration.setDescription(this.wDescription.getText()));
        this.wlEngine = new Label(wSettings, 131072);
        this.wlEngine.setText(BaseMessages.getString(PKG, (String)"RunConfigurationDialog.Label.Engine", (String[])new String[0]));
        this.props.setLook((Control)this.wlEngine);
        FormData fdlEngine = new FormData();
        fdlEngine.left = new FormAttachment(0, 0);
        fdlEngine.top = new FormAttachment((Control)this.wDescription, 10);
        this.wlEngine.setLayoutData((Object)fdlEngine);
        this.wEngine = new CCombo(wSettings, 2060);
        this.wEngine.setItems(this.executionConfigurationManager.getTypes());
        this.wEngine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String engine = RunConfigurationDialog.this.wEngine.getText();
                if (!engine.equals(RunConfigurationDialog.this.runConfiguration.getType())) {
                    RunConfigurationDialog.this.updateOptions(engine);
                }
            }
        });
        this.wEngine.select(0);
        this.props.setLook((Control)this.wEngine);
        FormData fdEngine = new FormData();
        fdEngine.width = 150;
        fdEngine.left = new FormAttachment(0, 0);
        fdEngine.top = new FormAttachment((Control)this.wlEngine, 5);
        this.wEngine.setLayoutData((Object)fdEngine);
        this.gOptions = new Group(wSettings, 16);
        this.gOptions.setText(BaseMessages.getString(PKG, (String)"RunConfigurationDialog.Group.Settings", (String[])new String[0]));
        this.props.setLook((Control)this.gOptions);
        FormLayout gformLayout = new FormLayout();
        gformLayout.marginWidth = 10;
        gformLayout.marginHeight = 10;
        this.gOptions.setLayout((Layout)gformLayout);
        FormData fdOptions = new FormData();
        fdOptions.top = new FormAttachment((Control)this.wEngine, 15);
        fdOptions.right = new FormAttachment(100);
        fdOptions.left = new FormAttachment(0);
        fdOptions.height = 140;
        this.gOptions.setLayoutData((Object)fdOptions);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdCancel = new FormData();
        fdCancel.right = new FormAttachment(100, 0);
        fdCancel.bottom = new FormAttachment(100, 0);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fdOk = new FormData();
        fdOk.right = new FormAttachment((Control)this.wCancel, -5);
        fdOk.bottom = new FormAttachment(100, 0);
        this.wOK.setLayoutData((Object)fdOk);
        Label hSpacer = new Label((Composite)this.shell, 258);
        FormData fdhSpacer = new FormData();
        fdhSpacer.height = 1;
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        hSpacer.setLayoutData((Object)fdhSpacer);
        FormData fdSettings = new FormData();
        fdSettings.left = new FormAttachment(0);
        fdSettings.top = new FormAttachment(0);
        fdSettings.right = new FormAttachment(100);
        fdSettings.bottom = new FormAttachment((Control)hSpacer, -15);
        wSettings.setLayoutData((Object)fdSettings);
        this.setValues();
        Listener lsCancel = e -> this.cancel();
        Listener lsOK = e -> this.ok();
        this.wOK.addListener(13, lsOK);
        this.wCancel.addListener(13, lsCancel);
        BaseStepDialog.setSize((Shell)this.shell, (int)450, (int)300);
        this.shell.setMinimumSize(450, 300);
        this.wName.setSelection(0, this.wName.getText().length());
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                RunConfigurationDialog.this.cancel();
            }
        });
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.savedRunConfiguration;
    }

    private Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"images/run_tree.svg", (int)32, (int)32);
    }

    private void setValues() {
        if (this.runConfiguration == null) {
            this.runConfiguration = this.executionConfigurationManager.getRunConfigurationByType(DefaultRunConfiguration.TYPE);
            this.runConfigurationMap.put(DefaultRunConfiguration.TYPE, this.runConfiguration);
        }
        this.clearOptions();
        if (this.runConfiguration.getType().equals(DefaultRunConfiguration.TYPE)) {
            this.showDefault();
        } else {
            this.showDynamic();
        }
        this.gOptions.layout();
        this.shell.pack();
        this.wEngine.setText(StringUtils.capitalize((String)this.runConfiguration.getType()));
        this.wName.setText(Const.NVL((String)this.runConfiguration.getName(), (String)""));
        this.wDescription.setText(Const.NVL((String)this.runConfiguration.getDescription(), (String)""));
    }

    private void clearOptions() {
        for (Control control : this.gOptions.getChildren()) {
            control.dispose();
        }
    }

    private void showDefault() {
        final DefaultRunConfiguration defaultRunConfiguration = (DefaultRunConfiguration)this.runConfiguration;
        Composite wTarget = new Composite((Composite)this.gOptions, 0);
        wTarget.setLayout((Layout)new FormLayout());
        this.props.setLook((Control)wTarget);
        final Button wbLocal = new Button(wTarget, 16);
        this.props.setLook((Control)wbLocal);
        wbLocal.setText(BaseMessages.getString(PKG, (String)"RunConfigurationDialog.Label.Local", (String[])new String[0]));
        wbLocal.setSelection(defaultRunConfiguration.isLocal());
        FormData fdbLocal = new FormData();
        fdbLocal.top = new FormAttachment(0);
        fdbLocal.left = new FormAttachment(0);
        wbLocal.setLayoutData((Object)fdbLocal);
        final Button wbRemote = new Button(wTarget, 16);
        this.props.setLook((Control)wbRemote);
        wbRemote.setText(BaseMessages.getString(PKG, (String)"RunConfigurationDialog.Label.Remote", (String[])new String[0]));
        wbRemote.setSelection(defaultRunConfiguration.isRemote() || defaultRunConfiguration.isClustered());
        FormData fdbRemote = new FormData();
        fdbRemote.top = new FormAttachment((Control)wbLocal, 5);
        fdbRemote.left = new FormAttachment(0);
        wbRemote.setLayoutData((Object)fdbRemote);
        FormData fdTarget = new FormData();
        fdTarget.left = new FormAttachment(0);
        fdTarget.top = new FormAttachment(0);
        wTarget.setLayoutData((Object)fdTarget);
        Label vSpacer = new Label((Composite)this.gOptions, 514);
        FormData fdvSpacer = new FormData();
        fdvSpacer.width = 1;
        fdvSpacer.left = new FormAttachment((Control)wTarget, 30);
        fdvSpacer.top = new FormAttachment(0, 0);
        fdvSpacer.bottom = new FormAttachment(100, 0);
        vSpacer.setLayoutData((Object)fdvSpacer);
        final Composite wcLocal = new Composite((Composite)this.gOptions, 0);
        this.props.setLook((Control)wcLocal);
        wcLocal.setLayout((Layout)new GridLayout());
        Text wlLocal = new Text(wcLocal, 66);
        this.props.setLook((Control)wlLocal);
        wlLocal.setText(BaseMessages.getString(PKG, (String)"RunConfigurationDialog.Text.Local", (String[])new String[0]));
        GridData gdlLocal = new GridData(768);
        gdlLocal.widthHint = 200;
        wlLocal.setLayoutData((Object)gdlLocal);
        FormData fdcLocal = new FormData();
        fdcLocal.left = new FormAttachment((Control)vSpacer, 30);
        fdcLocal.top = new FormAttachment(0);
        fdcLocal.right = new FormAttachment(100);
        fdcLocal.bottom = new FormAttachment(100);
        wcLocal.setLayoutData((Object)fdcLocal);
        final Composite wcRemote = new Composite((Composite)this.gOptions, 0);
        this.props.setLook((Control)wcRemote);
        wcRemote.setLayout((Layout)new FormLayout());
        Label wlRemote = new Label(wcRemote, 16384);
        this.props.setLook((Control)wlRemote);
        wlRemote.setText(BaseMessages.getString(PKG, (String)"RunConfigurationDialog.Label.Location", (String[])new String[0]));
        FormData fdlRemote = new FormData();
        fdlRemote.left = new FormAttachment(0);
        fdlRemote.top = new FormAttachment(0);
        wlRemote.setLayoutData((Object)fdlRemote);
        final CCombo wcSlaveServer = new CCombo(wcRemote, 2060);
        this.props.setLook((Control)wcSlaveServer);
        FormData fdSlaveServer = new FormData();
        fdSlaveServer.width = 150;
        fdSlaveServer.top = new FormAttachment((Control)wlRemote, 5);
        fdSlaveServer.left = new FormAttachment(0);
        wcSlaveServer.setLayoutData((Object)fdSlaveServer);
        final Button wbSendResources = new Button(wcRemote, 32);
        wbSendResources.setSelection(defaultRunConfiguration.isSendResources());
        wbSendResources.setVisible(!Utils.isEmpty((CharSequence)defaultRunConfiguration.getServer()) && !defaultRunConfiguration.isClustered());
        this.props.setLook((Control)wbSendResources);
        wbSendResources.setText(BaseMessages.getString(PKG, (String)"RunConfigurationDialog.Button.SendResources", (String[])new String[0]));
        FormData fdbSendResources = new FormData();
        fdbSendResources.top = new FormAttachment((Control)wcSlaveServer, 10);
        fdbSendResources.left = new FormAttachment(0);
        wbSendResources.setLayoutData((Object)fdbSendResources);
        wbSendResources.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                defaultRunConfiguration.setSendResources(wbSendResources.getSelection());
            }
        });
        final Button wbLogRemoteExecutionLocally = new Button(wcRemote, 32);
        wbLogRemoteExecutionLocally.setSelection(defaultRunConfiguration.isLogRemoteExecutionLocally());
        wbLogRemoteExecutionLocally.setVisible(defaultRunConfiguration.isClustered());
        this.props.setLook((Control)wbLogRemoteExecutionLocally);
        wbLogRemoteExecutionLocally.setText(BaseMessages.getString(PKG, (String)"RunConfigurationDialog.Checkbox.LogRemoteExecutionLocally", (String[])new String[0]));
        FormData fdbLogRemoteExecutionLocally = new FormData();
        fdbLogRemoteExecutionLocally.top = new FormAttachment((Control)wcSlaveServer, 10);
        fdbLogRemoteExecutionLocally.left = new FormAttachment(0);
        wbLogRemoteExecutionLocally.setLayoutData((Object)fdbLogRemoteExecutionLocally);
        wbLogRemoteExecutionLocally.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                defaultRunConfiguration.setLogRemoteExecutionLocally(wbLogRemoteExecutionLocally.getSelection());
            }
        });
        final Button wbShowTransformations = new Button(wcRemote, 32);
        wbShowTransformations.setSelection(defaultRunConfiguration.isShowTransformations());
        wbShowTransformations.setVisible(defaultRunConfiguration.isClustered());
        this.props.setLook((Control)wbShowTransformations);
        wbShowTransformations.setText(BaseMessages.getString(PKG, (String)"RunConfigurationDialog.Checkbox.ShowTransformation", (String[])new String[0]));
        FormData fdbShowTransformations = new FormData();
        fdbShowTransformations.top = new FormAttachment((Control)wbLogRemoteExecutionLocally, 10);
        fdbShowTransformations.left = new FormAttachment(0);
        wbShowTransformations.setLayoutData((Object)fdbShowTransformations);
        wbShowTransformations.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                defaultRunConfiguration.setShowTransformations(wbShowTransformations.getSelection());
            }
        });
        FormData fdcRemote = new FormData();
        fdcRemote.left = new FormAttachment((Control)vSpacer, 30);
        fdcRemote.top = new FormAttachment(0);
        fdcRemote.right = new FormAttachment(100);
        fdcRemote.bottom = new FormAttachment(100);
        wcRemote.setLayoutData((Object)fdcRemote);
        final AbstractMeta meta = (AbstractMeta)this.spoonSupplier.get().getActiveMeta();
        if (meta instanceof TransMeta && !Utils.isEmpty((List)((TransMeta)meta).getClusterSchemas())) {
            wcSlaveServer.add(CLUSTERED);
        }
        for (int i = 0; i < meta.getSlaveServers().size(); ++i) {
            SlaveServer slaveServer = (SlaveServer)meta.getSlaveServers().get(i);
            wcSlaveServer.add(slaveServer.toString());
        }
        if (!Utils.isEmpty((CharSequence)defaultRunConfiguration.getServer())) {
            wcSlaveServer.setText(defaultRunConfiguration.getServer());
        }
        wcLocal.setVisible(defaultRunConfiguration.isLocal());
        wcRemote.setVisible(defaultRunConfiguration.isRemote() || defaultRunConfiguration.isClustered());
        wcSlaveServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (wcSlaveServer.getText().equals(RunConfigurationDialog.CLUSTERED)) {
                    defaultRunConfiguration.setClustered(true);
                    defaultRunConfiguration.setLocal(false);
                    defaultRunConfiguration.setRemote(false);
                    wbLogRemoteExecutionLocally.setVisible(true);
                    wbShowTransformations.setVisible(true);
                    wbSendResources.setVisible(false);
                } else {
                    defaultRunConfiguration.setRemote(true);
                    defaultRunConfiguration.setLocal(false);
                    defaultRunConfiguration.setClustered(false);
                    defaultRunConfiguration.setServer(wcSlaveServer.getText());
                    wbLogRemoteExecutionLocally.setVisible(false);
                    wbShowTransformations.setVisible(false);
                    wbSendResources.setVisible(true);
                }
                RunConfigurationDialog.this.checkOKEnabled(defaultRunConfiguration, wcSlaveServer);
            }
        });
        wbLocal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                wcLocal.setVisible(wbLocal.getSelection());
                wcRemote.setVisible(wbRemote.getSelection());
                defaultRunConfiguration.setLocal(wbLocal.getSelection());
                defaultRunConfiguration.setRemote(false);
                defaultRunConfiguration.setClustered(false);
                RunConfigurationDialog.this.checkOKEnabled(defaultRunConfiguration, wcSlaveServer);
            }
        });
        wbRemote.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                wcLocal.setVisible(wbLocal.getSelection());
                wcRemote.setVisible(wbRemote.getSelection());
                defaultRunConfiguration.setLocal(false);
                if (Utils.isEmpty((CharSequence)wcSlaveServer.getText())) {
                    if (meta instanceof TransMeta && !Utils.isEmpty((List)((TransMeta)meta).getClusterSchemas())) {
                        wcSlaveServer.setText(RunConfigurationDialog.CLUSTERED);
                    } else if (meta.getSlaveServers().size() > 0) {
                        wcSlaveServer.setText(((SlaveServer)meta.getSlaveServers().get(0)).getName());
                    }
                }
                if (!wcSlaveServer.getText().equals(RunConfigurationDialog.CLUSTERED)) {
                    defaultRunConfiguration.setRemote(true);
                    defaultRunConfiguration.setClustered(false);
                    wbSendResources.setVisible(true);
                    wbShowTransformations.setVisible(false);
                    wbLogRemoteExecutionLocally.setVisible(false);
                } else {
                    defaultRunConfiguration.setClustered(true);
                    defaultRunConfiguration.setRemote(false);
                    wbSendResources.setVisible(false);
                    wbShowTransformations.setVisible(true);
                    wbLogRemoteExecutionLocally.setVisible(true);
                }
                RunConfigurationDialog.this.checkOKEnabled(defaultRunConfiguration, wcSlaveServer);
                if (!Utils.isEmpty((CharSequence)wcSlaveServer.getText())) {
                    defaultRunConfiguration.setServer(wcSlaveServer.getText());
                }
            }
        });
        if (defaultRunConfiguration.isClustered()) {
            wcSlaveServer.setText(CLUSTERED);
            wbSendResources.setVisible(false);
            wbShowTransformations.setVisible(true);
            wbLogRemoteExecutionLocally.setVisible(true);
        }
    }

    private void checkOKEnabled(DefaultRunConfiguration defaultRunConfiguration, CCombo wcSlaveServer) {
        if (defaultRunConfiguration.isRemote() && Utils.isEmpty((CharSequence)wcSlaveServer.getText()) || Utils.isEmpty((CharSequence)this.wName.getText())) {
            this.wOK.setEnabled(false);
        } else {
            this.wOK.setEnabled(true);
        }
    }

    private void showDynamic() {
        Text lastControl = null;
        for (Field field : this.runConfiguration.getClass().getDeclaredFields()) {
            RunOption runOption = field.getAnnotation(RunOption.class);
            if (runOption == null) continue;
            Label optionLabel = new Label((Composite)this.gOptions, 16384);
            this.props.setLook((Control)optionLabel);
            optionLabel.setText(runOption.label());
            FormData fdlOption = new FormData();
            fdlOption.left = new FormAttachment(0);
            fdlOption.top = lastControl != null ? new FormAttachment(lastControl, 10) : new FormAttachment(0);
            optionLabel.setLayoutData((Object)fdlOption);
            String value = this.invokeGetter(this.runConfiguration, field.getName(), runOption.value());
            Text optionText = new Text((Composite)this.gOptions, 18436);
            this.props.setLook((Control)optionText);
            optionText.setText(value);
            FormData fdOption = new FormData();
            fdOption.left = new FormAttachment(0);
            fdOption.top = new FormAttachment((Control)optionLabel, 5);
            fdOption.right = new FormAttachment(100);
            optionText.setLayoutData((Object)fdOption);
            this.invokeSetter(this.runConfiguration, field.getName(), optionText.getText());
            optionText.addModifyListener(modifyEvent -> {
                if (Utils.isEmpty((CharSequence)optionText.getText())) {
                    this.wOK.setEnabled(false);
                } else {
                    this.wOK.setEnabled(true);
                }
                this.invokeSetter(this.runConfiguration, field.getName(), optionText.getText());
            });
            lastControl = optionText;
        }
    }

    private void invokeSetter(Object object, String fieldName, String value) {
        try {
            Method method = object.getClass().getMethod("set" + StringUtils.capitalize((String)fieldName), String.class);
            if (method != null) {
                method.invoke(object, value);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private String invokeGetter(Object object, String fieldName, String defaultValue) {
        try {
            Method method = object.getClass().getMethod("get" + StringUtils.capitalize((String)fieldName), new Class[0]);
            if (method != null) {
                String value;
                String fieldValue = (String)method.invoke((Object)this.runConfiguration, new Object[0]);
                String string = value = fieldValue != null ? fieldValue : "";
                if (Utils.isEmpty((CharSequence)value) && !Utils.isEmpty((CharSequence)defaultValue)) {
                    return defaultValue;
                }
                return value;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return "";
    }

    private void updateOptions(String type) {
        RunConfiguration newRunConfiguration = this.runConfigurationMap.get(type);
        if (newRunConfiguration == null) {
            newRunConfiguration = this.executionConfigurationManager.getRunConfigurationByType(type);
            newRunConfiguration.setName(this.runConfiguration.getName());
            newRunConfiguration.setDescription(this.runConfiguration.getDescription());
            this.runConfigurationMap.put(type, newRunConfiguration);
        }
        this.runConfiguration = newRunConfiguration;
        this.setValues();
    }

    private void cancel() {
        this.shell.dispose();
    }

    private void ok() {
        if (this.validated()) {
            this.save();
            this.shell.dispose();
        }
    }

    private void save() {
        this.savedRunConfiguration = this.runConfiguration;
    }

    private boolean validated() {
        if (StringUtils.containsAny((String)this.wName.getText(), (String)"%\"\\/:[]*|\t\r\n")) {
            MessageBox messageBox = new MessageBox(this.shell, 1);
            messageBox.setMessage(BaseMessages.getString(PKG, (String)"RunConfiguration.InvalidChars.Message", (String[])new String[0]));
            messageBox.setText(BaseMessages.getString(PKG, (String)"RunConfiguration.InvalidChars.Title", (String[])new String[0]));
            messageBox.open();
            return false;
        }
        return true;
    }
}

