/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils.inspector;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Node;
import org.pentaho.di.baserver.utils.inspector.Endpoint;
import org.pentaho.di.baserver.utils.inspector.HttpMethod;
import org.pentaho.di.baserver.utils.inspector.QueryParam;

public class WadlParser {
    public Collection<Endpoint> getEndpoints(Document doc) {
        Node resources = doc.selectSingleNode("/application/child::*[local-name() = 'resources' ]");
        if (resources != null) {
            return this.parseResources(resources, this.sanitizePath(resources.valueOf("@base")));
        }
        return Collections.emptySet();
    }

    protected Collection<Endpoint> parseResources(Node resourceNode, String parentPath) {
        String path = resourceNode.valueOf("@path");
        path = path.isEmpty() ? parentPath : parentPath + "/" + this.sanitizePath(path);
        TreeSet<Endpoint> endpoints = new TreeSet<Endpoint>();
        for (Object methodNode : resourceNode.selectNodes("*[local-name() = 'method']")) {
            endpoints.add(this.parseMethod((Node)methodNode, path));
        }
        for (Object innerResourceNode : resourceNode.selectNodes("*[local-name() = 'resource']")) {
            endpoints.addAll(this.parseResources((Node)innerResourceNode, path));
        }
        return endpoints;
    }

    protected Endpoint parseMethod(Node methodNode, String path) {
        Node nodeDoc;
        Endpoint endpoint = new Endpoint();
        endpoint.setId(methodNode.valueOf("@id"));
        endpoint.setHttpMethod(HttpMethod.valueOf(methodNode.valueOf("@name")));
        endpoint.setPath(this.shortPath(path));
        Node requestNode = methodNode.selectSingleNode("*[local-name() = 'request']");
        if (requestNode != null) {
            for (Object queryParamNode : requestNode.selectNodes("*[local-name() = 'param']")) {
                endpoint.getQueryParams().add(this.parseQueryParam((Node)queryParamNode));
            }
        }
        if ((nodeDoc = methodNode.selectSingleNode("*[local-name() = 'doc']")) != null) {
            endpoint.setDeprecated(this.isDeprecated(nodeDoc.getText()));
            endpoint.setDocumentation(this.extractComment(nodeDoc.getText()));
            endpoint.setSupported(this.isSupported(nodeDoc.getText()));
        }
        return endpoint;
    }

    protected QueryParam parseQueryParam(Node queryParamNode) {
        QueryParam queryParam = new QueryParam();
        queryParam.setName(queryParamNode.valueOf("@name"));
        queryParam.setType(queryParamNode.valueOf("@type"));
        return queryParam;
    }

    protected String sanitizePath(String path) {
        path = path.startsWith("/") ? path.substring(1) : path;
        path = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        return path;
    }

    protected String shortPath(String path) {
        return path.contains("/api/") ? path.substring(path.indexOf("/api/") + 4) : path;
    }

    protected boolean isSupported(String in) {
        Pattern patern = Pattern.compile("<supported>(true||TRUE||True)<\\/supported>.*", 32);
        Matcher matcher = patern.matcher(in);
        return matcher.matches();
    }

    protected boolean isDeprecated(String in) {
        Pattern patern = Pattern.compile(".*<deprecated>(true||TRUE||True)<\\/deprecated>.*", 32);
        Matcher matcher = patern.matcher(in);
        return matcher.matches();
    }

    protected String extractComment(String in) {
        Pattern patern = Pattern.compile(".*<documentation>(.*)<\\/documentation>.*", 32);
        Matcher matcher = patern.matcher(in);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }
}

