/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.api.initializer.ClusterInitializationException;
import org.pentaho.big.data.kettle.plugins.hbase.ServiceStatus;
import org.pentaho.big.data.kettle.plugins.hbase.input.HBaseInput;
import org.pentaho.big.data.kettle.plugins.hbase.input.HBaseInputMeta;
import org.pentaho.big.data.kettle.plugins.hbase.input.Messages;
import org.pentaho.big.data.kettle.plugins.hbase.mapping.ConfigurationProducer;
import org.pentaho.big.data.kettle.plugins.hbase.mapping.MappingAdmin;
import org.pentaho.big.data.kettle.plugins.hbase.mapping.MappingEditor;
import org.pentaho.big.data.plugins.common.ui.NamedClusterWidgetImpl;
import org.pentaho.bigdata.api.hbase.ByteConversionUtil;
import org.pentaho.bigdata.api.hbase.HBaseConnection;
import org.pentaho.bigdata.api.hbase.HBaseService;
import org.pentaho.bigdata.api.hbase.mapping.ColumnFilter;
import org.pentaho.bigdata.api.hbase.mapping.ColumnFilterFactory;
import org.pentaho.bigdata.api.hbase.mapping.Mapping;
import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterfaceFactory;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboValuesSelectionListener;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;

public class HBaseInputDialog
extends BaseStepDialog
implements StepDialogInterface,
ConfigurationProducer {
    private Label m_stepnameLabel;
    private Text m_stepnameText;
    private CTabFolder m_wTabFolder;
    private CTabItem m_wConfigTab;
    private CTabItem m_wFilterTab;
    private CTabItem m_editorTab;
    NamedClusterWidgetImpl namedClusterWidget;
    private Button m_coreConfigBut;
    private TextVar m_coreConfigText;
    private Button m_defaultConfigBut;
    private TextVar m_defaultConfigText;
    private final HBaseInputMeta m_currentMeta;
    private final HBaseInputMeta m_originalMeta;
    private final HBaseInputMeta m_configurationMeta;
    private Button m_mappedTableNamesBut;
    private CCombo m_mappedTableNamesCombo;
    private Button m_mappingNamesBut;
    private CCombo m_mappingNamesCombo;
    private Button m_storeMappingInStepMetaData;
    private TextVar m_keyStartText;
    private TextVar m_keyStopText;
    private TextVar m_scanCacheText;
    private String m_keyName;
    private Mapping.KeyType m_keyType;
    private Label m_keyInfo;
    private Button m_getKeyInfoBut;
    private TableView m_fieldsView;
    private TableView m_filtersView;
    private ColumnInfo m_filterAliasCI;
    private Button m_matchAllBut;
    private Button m_matchAnyBut;
    private MappingEditor m_mappingEditor;
    private Map<String, HBaseValueMetaInterface> m_mappedColumns;
    private Map<String, String> m_indexedLookup = new HashMap<String, String>();
    private final NamedClusterService namedClusterService;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;
    private final NamedClusterServiceLocator namedClusterServiceLocator;

    public HBaseInputDialog(Shell parent, Object in, TransMeta tr, String name) {
        super(parent, (BaseStepMeta)in, tr, name);
        this.m_currentMeta = (HBaseInputMeta)((Object)in);
        this.m_originalMeta = (HBaseInputMeta)((Object)this.m_currentMeta.clone());
        this.m_configurationMeta = (HBaseInputMeta)((Object)this.m_currentMeta.clone());
        this.namedClusterService = this.m_currentMeta.getNamedClusterService();
        this.runtimeTestActionService = this.m_currentMeta.getRuntimeTestActionService();
        this.runtimeTester = this.m_currentMeta.getRuntimeTester();
        this.namedClusterServiceLocator = this.m_currentMeta.getNamedClusterServiceLocator();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.m_currentMeta);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HBaseInputDialog.this.m_currentMeta.setChanged();
            }
        };
        this.changed = this.m_currentMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(Messages.getString("HBaseInputDialog.Shell.Title"));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.m_stepnameLabel = new Label((Composite)this.shell, 131072);
        this.m_stepnameLabel.setText(Messages.getString("HBaseInputDialog.StepName.Label"));
        this.props.setLook((Control)this.m_stepnameLabel);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment(0, margin);
        this.m_stepnameLabel.setLayoutData((Object)fd);
        this.m_stepnameText = new Text((Composite)this.shell, 18436);
        this.m_stepnameText.setText(this.stepname);
        this.props.setLook((Control)this.m_stepnameText);
        this.m_stepnameText.addModifyListener(lsMod);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment(0, margin);
        fd.right = new FormAttachment(100, 0);
        this.m_stepnameText.setLayoutData((Object)fd);
        this.m_wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.m_wTabFolder, 5);
        this.m_wTabFolder.setSimple(false);
        this.m_wConfigTab = new CTabItem(this.m_wTabFolder, 0);
        this.m_wConfigTab.setText(Messages.getString("HBaseInputDialog.ConfigTab.TabTitle"));
        Composite wConfigComp = new Composite((Composite)this.m_wTabFolder, 0);
        this.props.setLook((Control)wConfigComp);
        FormLayout configLayout = new FormLayout();
        configLayout.marginWidth = 3;
        configLayout.marginHeight = 3;
        wConfigComp.setLayout((Layout)configLayout);
        Label namedClusterLab = new Label(wConfigComp, 131072);
        namedClusterLab.setText(Messages.getString("HBaseInputDialog.NamedCluster.Label"));
        namedClusterLab.setToolTipText(Messages.getString("HBaseInputDialog.NamedCluster.TipText"));
        this.props.setLook((Control)namedClusterLab);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 10);
        fd.right = new FormAttachment(middle, -margin);
        namedClusterLab.setLayoutData((Object)fd);
        this.namedClusterWidget = new NamedClusterWidgetImpl(wConfigComp, false, this.namedClusterService, this.runtimeTestActionService, this.runtimeTester);
        this.namedClusterWidget.initiate();
        this.props.setLook((Control)this.namedClusterWidget);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(middle, 0);
        this.namedClusterWidget.setLayoutData((Object)fd);
        Label coreConfigLab = new Label(wConfigComp, 131072);
        coreConfigLab.setText(Messages.getString("HBaseInputDialog.CoreConfig.Label"));
        coreConfigLab.setToolTipText(Messages.getString("HBaseInputDialog.CoreConfig.TipText"));
        this.props.setLook((Control)coreConfigLab);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.namedClusterWidget, margin);
        fd.right = new FormAttachment(middle, -margin);
        coreConfigLab.setLayoutData((Object)fd);
        this.m_coreConfigBut = new Button(wConfigComp, 0x1000008);
        this.props.setLook((Control)this.m_coreConfigBut);
        this.m_coreConfigBut.setText(Messages.getString("System.Button.Browse"));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.namedClusterWidget, 0);
        this.m_coreConfigBut.setLayoutData((Object)fd);
        this.m_coreConfigBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(HBaseInputDialog.this.shell, 4096);
                String[] extensions = null;
                String[] filterNames = null;
                extensions = new String[2];
                filterNames = new String[2];
                extensions[0] = "*.xml";
                filterNames[0] = Messages.getString("HBaseInputDialog.FileType.XML");
                extensions[1] = "*";
                filterNames[1] = Messages.getString("System.FileType.AllFiles");
                dialog.setFilterExtensions(extensions);
                if (dialog.open() != null) {
                    HBaseInputDialog.this.m_coreConfigText.setText(dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName());
                }
            }
        });
        this.m_coreConfigText = new TextVar((VariableSpace)this.transMeta, wConfigComp, 18436);
        this.props.setLook((Control)this.m_coreConfigText);
        this.m_coreConfigText.addModifyListener(lsMod);
        this.m_coreConfigText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HBaseInputDialog.this.m_coreConfigText.setToolTipText(HBaseInputDialog.this.transMeta.environmentSubstitute(HBaseInputDialog.this.m_coreConfigText.getText()));
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.namedClusterWidget, margin);
        fd.right = new FormAttachment((Control)this.m_coreConfigBut, -margin);
        this.m_coreConfigText.setLayoutData((Object)fd);
        Label defaultConfigLab = new Label(wConfigComp, 131072);
        defaultConfigLab.setText(Messages.getString("HBaseInputDialog.DefaultConfig.Label"));
        defaultConfigLab.setToolTipText(Messages.getString("HBaseInputDialog.DefaultConfig.TipText"));
        this.props.setLook((Control)defaultConfigLab);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_coreConfigText, margin);
        fd.right = new FormAttachment(middle, -margin);
        defaultConfigLab.setLayoutData((Object)fd);
        this.m_defaultConfigBut = new Button(wConfigComp, 0x1000008);
        this.props.setLook((Control)this.m_defaultConfigBut);
        this.m_defaultConfigBut.setText(Messages.getString("System.Button.Browse"));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_coreConfigText, 0);
        this.m_defaultConfigBut.setLayoutData((Object)fd);
        this.m_defaultConfigBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(HBaseInputDialog.this.shell, 4096);
                String[] extensions = null;
                String[] filterNames = null;
                extensions = new String[2];
                filterNames = new String[2];
                extensions[0] = "*.xml";
                filterNames[0] = Messages.getString("HBaseInputDialog.FileType.XML");
                extensions[1] = "*";
                filterNames[1] = Messages.getString("System.FileType.AllFiles");
                dialog.setFilterExtensions(extensions);
                if (dialog.open() != null) {
                    HBaseInputDialog.this.m_defaultConfigText.setText(dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName());
                }
            }
        });
        this.m_defaultConfigText = new TextVar((VariableSpace)this.transMeta, wConfigComp, 18436);
        this.props.setLook((Control)this.m_defaultConfigText);
        this.m_defaultConfigText.addModifyListener(lsMod);
        this.m_defaultConfigText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HBaseInputDialog.this.m_defaultConfigText.setToolTipText(HBaseInputDialog.this.transMeta.environmentSubstitute(HBaseInputDialog.this.m_defaultConfigText.getText()));
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_coreConfigText, margin);
        fd.right = new FormAttachment((Control)this.m_defaultConfigBut, -margin);
        this.m_defaultConfigText.setLayoutData((Object)fd);
        Label tableNameLab = new Label(wConfigComp, 131072);
        tableNameLab.setText(Messages.getString("HBaseInputDialog.TableName.Label"));
        tableNameLab.setToolTipText(Messages.getString("HBaseInputDialog.TableName.TipText"));
        this.props.setLook((Control)tableNameLab);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_defaultConfigText, margin);
        fd.right = new FormAttachment(middle, -margin);
        tableNameLab.setLayoutData((Object)fd);
        this.m_mappedTableNamesBut = new Button(wConfigComp, 0x1000008);
        this.props.setLook((Control)this.m_mappedTableNamesBut);
        this.m_mappedTableNamesBut.setText(Messages.getString("HBaseInputDialog.TableName.Button"));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_defaultConfigText, 0);
        this.m_mappedTableNamesBut.setLayoutData((Object)fd);
        this.m_mappedTableNamesCombo = new CCombo(wConfigComp, 2048);
        this.props.setLook((Control)this.m_mappedTableNamesCombo);
        this.m_mappedTableNamesCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HBaseInputDialog.this.m_currentMeta.setChanged();
                HBaseInputDialog.this.m_mappedTableNamesCombo.setToolTipText(HBaseInputDialog.this.transMeta.environmentSubstitute(HBaseInputDialog.this.m_mappedTableNamesCombo.getText()));
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_defaultConfigText, margin);
        fd.right = new FormAttachment((Control)this.m_mappedTableNamesBut, -margin);
        this.m_mappedTableNamesCombo.setLayoutData((Object)fd);
        this.m_mappedTableNamesBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HBaseInputDialog.this.setupMappedTableNames();
            }
        });
        Label mappingNameLab = new Label(wConfigComp, 131072);
        mappingNameLab.setText(Messages.getString("HBaseInputDialog.MappingName.Label"));
        mappingNameLab.setToolTipText(Messages.getString("HBaseInputDialog.MappingName.TipText"));
        this.props.setLook((Control)mappingNameLab);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_mappedTableNamesCombo, margin);
        fd.right = new FormAttachment(middle, -margin);
        mappingNameLab.setLayoutData((Object)fd);
        this.m_mappingNamesBut = new Button(wConfigComp, 0x1000008);
        this.props.setLook((Control)this.m_mappingNamesBut);
        this.m_mappingNamesBut.setText(Messages.getString("HBaseInputDialog.MappingName.Button"));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_mappedTableNamesCombo, 0);
        this.m_mappingNamesBut.setLayoutData((Object)fd);
        this.m_mappingNamesBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HBaseInputDialog.this.setupMappingNamesForTable(false);
            }
        });
        this.m_mappingNamesCombo = new CCombo(wConfigComp, 2048);
        this.props.setLook((Control)this.m_mappingNamesCombo);
        this.m_mappingNamesCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HBaseInputDialog.this.m_currentMeta.setChanged();
                HBaseInputDialog.this.m_mappingNamesCombo.setToolTipText(HBaseInputDialog.this.transMeta.environmentSubstitute(HBaseInputDialog.this.m_mappingNamesCombo.getText()));
                HBaseInputDialog.this.m_storeMappingInStepMetaData.setSelection(false);
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_mappedTableNamesCombo, margin);
        fd.right = new FormAttachment((Control)this.m_mappingNamesBut, -margin);
        this.m_mappingNamesCombo.setLayoutData((Object)fd);
        Label storeMapping = new Label(wConfigComp, 131072);
        storeMapping.setText(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInputDialog.StoreMapping.Label", (String[])new String[0]));
        storeMapping.setToolTipText(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInputDialog.StoreMapping.TipText", (String[])new String[0]));
        this.props.setLook((Control)storeMapping);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_mappingNamesCombo, margin);
        fd.right = new FormAttachment(middle, -margin);
        storeMapping.setLayoutData((Object)fd);
        this.m_storeMappingInStepMetaData = new Button(wConfigComp, 32);
        this.props.setLook((Control)this.m_storeMappingInStepMetaData);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_mappingNamesCombo, margin);
        this.m_storeMappingInStepMetaData.setLayoutData((Object)fd);
        Label keyStartLab = new Label(wConfigComp, 131072);
        keyStartLab.setText(Messages.getString("HBaseInputDialog.KeyStart.Label"));
        keyStartLab.setToolTipText(Messages.getString("HBaseInputDialog.KeyStart.TipText"));
        this.props.setLook((Control)keyStartLab);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_storeMappingInStepMetaData, margin);
        fd.right = new FormAttachment(middle, -margin);
        keyStartLab.setLayoutData((Object)fd);
        this.m_keyStartText = new TextVar((VariableSpace)this.transMeta, wConfigComp, 18436);
        this.m_keyStartText.setToolTipText(Messages.getString("HBaseInputDialog.KeyStart.TipText"));
        this.m_keyStartText.addModifyListener(lsMod);
        this.props.setLook((Control)this.m_keyStartText);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_storeMappingInStepMetaData, margin);
        this.m_keyStartText.setLayoutData((Object)fd);
        Label keyStopLab = new Label(wConfigComp, 131072);
        keyStopLab.setText(Messages.getString("HBaseInputDialog.KeyStop.Label"));
        keyStopLab.setToolTipText(Messages.getString("HBaseInputDialog.KeyStop.TipText"));
        this.props.setLook((Control)keyStopLab);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_keyStartText, margin);
        fd.right = new FormAttachment(middle, -margin);
        keyStopLab.setLayoutData((Object)fd);
        this.m_keyStopText = new TextVar((VariableSpace)this.transMeta, wConfigComp, 18436);
        this.m_keyStopText.setToolTipText(Messages.getString("HBaseInputDialog.KeyStop.TipText"));
        this.m_keyStopText.addModifyListener(lsMod);
        this.props.setLook((Control)this.m_keyStopText);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_keyStartText, margin);
        this.m_keyStopText.setLayoutData((Object)fd);
        Label scannerCacheLab = new Label(wConfigComp, 131072);
        scannerCacheLab.setText(Messages.getString("HBaseInputDialog.ScannerCache.Label"));
        scannerCacheLab.setToolTipText(Messages.getString("HBaseInputDialog.ScannerCache.TipText"));
        this.props.setLook((Control)scannerCacheLab);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_keyStopText, margin);
        fd.right = new FormAttachment(middle, -margin);
        scannerCacheLab.setLayoutData((Object)fd);
        this.m_scanCacheText = new TextVar((VariableSpace)this.transMeta, wConfigComp, 18436);
        this.m_scanCacheText.setToolTipText(Messages.getString("HBaseInputDialog.ScannerCache.TipText"));
        this.props.setLook((Control)this.m_scanCacheText);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_keyStopText, margin);
        this.m_scanCacheText.setLayoutData((Object)fd);
        this.m_getKeyInfoBut = new Button(wConfigComp, 8);
        this.m_getKeyInfoBut.setText("Get Key/Fields Info");
        this.props.setLook((Control)this.m_getKeyInfoBut);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, -margin * 2);
        this.m_getKeyInfoBut.setLayoutData((Object)fd);
        this.m_getKeyInfoBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HBaseInputDialog.this.checkKeyInformation(false, true);
            }
        });
        Group keyGroup = new Group(wConfigComp, 16);
        FormLayout keyLayout = new FormLayout();
        keyGroup.setLayout((Layout)keyLayout);
        this.props.setLook((Control)keyGroup);
        this.m_keyInfo = new Label((Composite)keyGroup, 131072);
        this.m_keyInfo.setText("-- Key details --");
        this.props.setLook((Control)this.m_keyInfo);
        fd = new FormData();
        fd.top = new FormAttachment(0, margin);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, -margin);
        this.m_keyInfo.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment((Control)this.m_getKeyInfoBut, -margin);
        fd.left = new FormAttachment(middle, 0);
        fd.bottom = new FormAttachment(100, -margin * 2);
        keyGroup.setLayoutData((Object)fd);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(Messages.getString("HBaseInputDialog.Fields.FIELD_ALIAS"), 1, false), new ColumnInfo(Messages.getString("HBaseInputDialog.Fields.FIELD_KEY"), 1, false), new ColumnInfo(Messages.getString("HBaseInputDialog.Fields.FIELD_FAMILY"), 1, false), new ColumnInfo(Messages.getString("HBaseInputDialog.Fields.FIELD_NAME"), 1, false), new ColumnInfo(Messages.getString("HBaseInputDialog.Fields.FIELD_TYPE"), 1, false), new ColumnInfo(Messages.getString("HBaseInputDialog.Fields.FIELD_FORMAT"), 5, 3), new ColumnInfo(Messages.getString("HBaseInputDialog.Fields.FIELD_INDEXED"), 1, false)};
        colinf[0].setReadOnly(true);
        colinf[1].setReadOnly(true);
        colinf[2].setReadOnly(true);
        colinf[3].setReadOnly(true);
        colinf[4].setReadOnly(true);
        colinf[5].setReadOnly(true);
        colinf[5].setComboValuesSelectionListener(new ComboValuesSelectionListener(){

            public String[] getComboValues(TableItem tableItem, int rowNr, int colNr) {
                String[] comboValues = new String[]{};
                int type = ValueMeta.getType((String)tableItem.getText(colNr - 1));
                switch (type) {
                    case 3: {
                        comboValues = Const.getDateFormats();
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 6: {
                        comboValues = Const.getNumberFormats();
                        break;
                    }
                }
                return comboValues;
            }
        });
        this.m_fieldsView = new TableView((VariableSpace)this.transMeta, wConfigComp, 65538, colinf, 1, lsMod, this.props);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.m_scanCacheText, margin * 2);
        fd.bottom = new FormAttachment((Control)this.m_getKeyInfoBut, -margin * 2);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.m_fieldsView.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        wConfigComp.setLayoutData((Object)fd);
        wConfigComp.layout();
        this.m_wConfigTab.setControl((Control)wConfigComp);
        this.m_editorTab = new CTabItem(this.m_wTabFolder, 0);
        this.m_editorTab.setText(Messages.getString("HBaseInputDialog.MappingEditorTab.TabTitle"));
        this.m_mappingEditor = new MappingEditor(this.shell, (Composite)this.m_wTabFolder, this, null, 65538, false, this.props, this.transMeta, this.namedClusterService, this.runtimeTestActionService, this.runtimeTester, this.namedClusterServiceLocator);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        this.m_mappingEditor.setLayoutData(fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, -margin * 2);
        fd.right = new FormAttachment(100, 0);
        this.m_mappingEditor.setLayoutData(fd);
        this.m_mappingEditor.layout();
        this.m_editorTab.setControl((Control)this.m_mappingEditor);
        this.m_wFilterTab = new CTabItem(this.m_wTabFolder, 0);
        this.m_wFilterTab.setText(Messages.getString("HBaseInputDialog.FilterTab.TabTitle"));
        Composite wFilterComp = new Composite((Composite)this.m_wTabFolder, 0);
        this.props.setLook((Control)wFilterComp);
        FormLayout filterLayout = new FormLayout();
        filterLayout.marginWidth = 3;
        filterLayout.marginHeight = 3;
        wFilterComp.setLayout((Layout)filterLayout);
        this.m_matchAllBut = new Button(wFilterComp, 16);
        this.m_matchAllBut.setText(Messages.getString("HBaseInputDialog.Filters.RADIO_ALL"));
        this.props.setLook((Control)this.m_matchAllBut);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        this.m_matchAllBut.setLayoutData((Object)fd);
        this.m_matchAllBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HBaseInputDialog.this.m_currentMeta.setChanged();
            }
        });
        this.m_matchAnyBut = new Button(wFilterComp, 16);
        this.m_matchAnyBut.setText(Messages.getString("HBaseInputDialog.Filters.RADIO_ANY"));
        this.props.setLook((Control)this.m_matchAnyBut);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment((Control)this.m_matchAllBut, 0);
        fd.right = new FormAttachment(100, -margin);
        this.m_matchAnyBut.setLayoutData((Object)fd);
        this.m_matchAnyBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HBaseInputDialog.this.m_currentMeta.setChanged();
            }
        });
        this.m_matchAllBut.setSelection(true);
        final ColumnInfo[] colinf2 = new ColumnInfo[]{new ColumnInfo(Messages.getString("HBaseInputDialog.Filters.FIELD_ALIAS") + "     ", 2, false), new ColumnInfo(Messages.getString("HBaseInputDialog.Filters.FIELD_TYPE"), 1, false), new ColumnInfo(Messages.getString("HBaseInputDialog.Filters.FIELD_OPERATOR"), 2, false), new ColumnInfo(Messages.getString("HBaseInputDialog.Filters.FIELD_COMPARISON"), 1, false), new ColumnInfo(Messages.getString("HBaseInputDialog.Filters.FIELD_FORMAT"), 2, false), new ColumnInfo(Messages.getString("HBaseInputDialog.Filters.FIELD_SIGNED"), 2, false)};
        colinf2[0].setReadOnly(false);
        colinf2[1].setReadOnly(false);
        colinf2[2].setReadOnly(true);
        colinf2[3].setReadOnly(false);
        colinf2[4].setReadOnly(false);
        colinf2[5].setReadOnly(true);
        this.m_filterAliasCI = colinf2[0];
        this.m_filterAliasCI.setComboValues(new String[]{""});
        colinf2[2].setComboValues(ColumnFilter.ComparisonType.getAllOperators());
        colinf2[5].setComboValues(new String[]{"Y", "N"});
        colinf2[2].setComboValuesSelectionListener(new ComboValuesSelectionListener(){

            public String[] getComboValues(TableItem tableItem, int rowNr, int colNr) {
                String[] comboValues = colinf2[2].getComboValues();
                String alias = tableItem.getText(1);
                HBaseValueMetaInterface vm = null;
                if (!Const.isEmpty((String)alias)) {
                    vm = HBaseInputDialog.this.setFilterTableTypeColumn(tableItem);
                }
                comboValues = vm != null ? (vm.isNumeric() || vm.isDate() || vm.isBoolean() ? ColumnFilter.ComparisonType.getNumericOperators() : (vm.isString() ? ColumnFilter.ComparisonType.getStringOperators() : new String[]{""})) : ColumnFilter.ComparisonType.getAllOperators();
                return comboValues;
            }
        });
        colinf2[4].setComboValuesSelectionListener(new ComboValuesSelectionListener(){

            public String[] getComboValues(TableItem tableItem, int rowNr, int colNr) {
                String[] comboValues = new String[]{};
                String alias = tableItem.getText(1);
                if (!Const.isEmpty((String)alias)) {
                    HBaseInputDialog.this.setFilterTableTypeColumn(tableItem);
                }
                int type = ValueMeta.getType((String)tableItem.getText(2));
                switch (type) {
                    case 3: {
                        comboValues = Const.getDateFormats();
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 6: {
                        comboValues = Const.getNumberFormats();
                        break;
                    }
                }
                return comboValues;
            }
        });
        this.m_filtersView = new TableView((VariableSpace)this.transMeta, wFilterComp, 65538, colinf2, 1, lsMod, this.props);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.m_matchAllBut, margin * 2);
        fd.bottom = new FormAttachment(100, -margin * 2);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.m_filtersView.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        wFilterComp.setLayoutData((Object)fd);
        wFilterComp.layout();
        this.m_wFilterTab.setControl((Control)wFilterComp);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_stepnameText, margin);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, -50);
        this.m_wTabFolder.setLayoutData((Object)fd);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(Messages.getString("System.Button.OK"));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(Messages.getString("System.Button.Cancel"));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, (Control)this.m_wTabFolder);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                HBaseInputDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                HBaseInputDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                HBaseInputDialog.this.ok();
            }
        };
        this.m_stepnameText.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                HBaseInputDialog.this.cancel();
            }
        });
        this.m_wTabFolder.setSelection(0);
        this.setSize();
        this.getData();
        ServiceStatus serviceStatus = this.m_currentMeta.getServiceStatus();
        if (!serviceStatus.isOk()) {
            new ErrorDialog(this.shell, Messages.getString("Dialog.Error"), Messages.getString("HBaseInput.Error.ServiceStatus"), serviceStatus.getException());
        }
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected HBaseValueMetaInterface setFilterTableTypeColumn(TableItem tableItem) {
        String alias = tableItem.getText(1).trim();
        if (!Const.isEmpty((String)alias)) {
            if (this.transMeta.environmentSubstitute(alias).equals(this.m_keyName)) {
                tableItem.setText(2, this.m_keyType.toString());
                HBaseValueMetaInterface vm = this.m_mappedColumns.get(this.transMeta.environmentSubstitute(alias));
                if (vm != null) {
                    vm.setType(HBaseInput.getKettleTypeByKeyType(this.m_keyType));
                    String type = ValueMetaBase.getTypeDesc((int)vm.getType());
                    tableItem.setText(2, type);
                    return vm;
                }
            } else if (this.m_mappedColumns != null) {
                HBaseValueMetaInterface vm = this.m_mappedColumns.get(this.transMeta.environmentSubstitute(alias));
                if (vm != null) {
                    String type = ValueMetaBase.getTypeDesc((int)vm.getType());
                    if (vm.getType() == 5) {
                        type = vm.getIsLongOrDouble() ? "Long" : "Integer";
                    }
                    if (vm.getType() == 1) {
                        type = vm.getIsLongOrDouble() ? "Double" : "Float";
                    }
                    tableItem.setText(2, type);
                    return vm;
                }
            } else if (this.m_currentMeta.getOutputFields() != null && this.m_currentMeta.getOutputFields().size() > 0) {
                for (HBaseValueMetaInterface vm : this.m_currentMeta.getOutputFields()) {
                    String aliasF = vm.getAlias();
                    if (!alias.equals(aliasF)) continue;
                    String type = ValueMetaBase.getTypeDesc((int)vm.getType());
                    tableItem.setText(2, type);
                    return vm;
                }
            }
        }
        return null;
    }

    protected void updateMetaConnectionDetails(HBaseInputMeta meta) {
        NamedCluster nc = this.namedClusterWidget.getSelectedNamedCluster();
        if (nc != null) {
            meta.setNamedCluster(nc);
        }
        meta.setCoreConfigURL(this.m_coreConfigText.getText());
        meta.setDefaulConfigURL(this.m_defaultConfigText.getText());
        meta.setSourceTableName(this.m_mappedTableNamesCombo.getText());
        meta.setSourceMappingName(this.m_mappingNamesCombo.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ok() {
        String format;
        String alias;
        Object item;
        int i;
        if (Const.isEmpty((String)this.m_stepnameText.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(Messages.getString("System.StepJobEntryNameMissing.Title"));
            mb.setMessage(Messages.getString("System.JobEntryNameMissing.Msg"));
            mb.open();
            return;
        }
        NamedCluster selectedNamedCluster = this.namedClusterWidget.getSelectedNamedCluster();
        if (selectedNamedCluster == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(Messages.getString("Dialog.Error"));
            mb.setMessage(Messages.getString("HBaseInputDialog.NamedClusterNotSelected.Msg"));
            mb.open();
            return;
        }
        if (StringUtils.isEmpty((String)selectedNamedCluster.getZooKeeperHost())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(Messages.getString("Dialog.Error"));
            mb.setMessage(Messages.getString("HBaseInputDialog.NamedClusterMissingValues.Msg"));
            mb.open();
            return;
        }
        HBaseService hBaseService = null;
        try {
            hBaseService = this.getHBaseService();
        }
        catch (ClusterInitializationException e) {
            throw new RuntimeException(e);
        }
        HBaseValueMetaInterfaceFactory hBaseValueMetaInterfaceFactory = hBaseService.getHBaseValueMetaInterfaceFactory();
        this.stepname = this.m_stepnameText.getText();
        this.updateMetaConnectionDetails(this.m_currentMeta);
        this.m_currentMeta.setKeyStartValue(this.m_keyStartText.getText());
        this.m_currentMeta.setKeyStopValue(this.m_keyStopText.getText());
        this.m_currentMeta.setScannerCacheSize(this.m_scanCacheText.getText());
        this.m_currentMeta.setMatchAnyFilter(this.m_matchAnyBut.getSelection());
        int numNonEmpty = this.m_fieldsView.nrNonEmpty();
        if (numNonEmpty > 0) {
            ByteConversionUtil byteConversionUtil = hBaseService.getByteConversionUtil();
            ArrayList<HBaseValueMetaInterface> outputFields = new ArrayList<HBaseValueMetaInterface>();
            for (i = 0; i < numNonEmpty; ++i) {
                item = this.m_fieldsView.getNonEmpty(i);
                alias = item.getText(1).trim();
                String isKey = item.getText(2).trim();
                String family = item.getText(3).trim();
                String column = item.getText(4).trim();
                String type = item.getText(5).trim();
                format = item.getText(6).trim();
                HBaseValueMetaInterface vm = hBaseValueMetaInterfaceFactory.createHBaseValueMetaInterface(family, column, alias, ValueMeta.getType((String)type), -1, -1);
                vm.setTableName(this.m_mappedTableNamesCombo.getText());
                vm.setMappingName(this.m_mappingNamesCombo.getText());
                vm.setKey(isKey.equalsIgnoreCase("Y"));
                String indexItems = this.m_indexedLookup.get(alias);
                if (indexItems != null) {
                    Object[] values = byteConversionUtil.stringIndexListToObjects(indexItems);
                    vm.setIndex(values);
                    vm.setStorageType(2);
                }
                vm.setConversionMask(format);
                outputFields.add(vm);
            }
            this.m_currentMeta.setOutputFields(outputFields);
        } else {
            this.m_currentMeta.setOutputFields(null);
        }
        numNonEmpty = this.m_filtersView.nrNonEmpty();
        if (numNonEmpty > 0) {
            ColumnFilterFactory columnFilterFactory = hBaseService.getColumnFilterFactory();
            ArrayList<ColumnFilter> filters = new ArrayList<ColumnFilter>();
            for (i = 0; i < this.m_filtersView.nrNonEmpty(); ++i) {
                item = this.m_filtersView.getNonEmpty(i);
                alias = item.getText(1).trim();
                String type = item.getText(2).trim();
                String operator = item.getText(3).trim();
                String comparison = item.getText(4).trim();
                String signed = item.getText(6).trim();
                format = item.getText(5).trim();
                ColumnFilter f = columnFilterFactory.createFilter(alias);
                f.setFieldType(type);
                f.setComparisonOperator(ColumnFilter.ComparisonType.stringToOpp((String)operator));
                f.setConstant(comparison);
                f.setSignedComparison(signed.equalsIgnoreCase("Y"));
                f.setFormat(format);
                filters.add(f);
            }
            this.m_currentMeta.setColumnFilters(filters);
        } else {
            this.m_currentMeta.setColumnFilters(null);
        }
        if (this.m_storeMappingInStepMetaData.getSelection()) {
            if (Const.isEmpty((String)this.m_mappingNamesCombo.getText())) {
                ArrayList<String> problems = new ArrayList<String>();
                Mapping toSet = this.m_mappingEditor.getMapping(false, problems, false);
                if (problems.size() > 0) {
                    StringBuffer p = new StringBuffer();
                    for (String s : problems) {
                        p.append(s).append("\n");
                    }
                    MessageDialog md = new MessageDialog(this.shell, BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInputDialog.Error.IssuesWithMapping.Title", (String[])new String[0]), null, BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInputDialog.Error.IssuesWithMapping", (String[])new String[0]) + ":\n\n" + p.toString(), 4, new String[]{BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInputDialog.Error.IssuesWithMapping.ButtonOK", (String[])new String[0]), BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInputDialog.Error.IssuesWithMapping.ButtonCancel", (String[])new String[0])}, 0);
                    MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
                    int idx = md.open() & 0xFF;
                    if (idx == 1 || idx == 255) {
                        return;
                    }
                }
                this.m_currentMeta.setMapping(toSet);
            } else {
                HBaseConnection connection = null;
                try {
                    connection = this.getHBaseConnection();
                    MappingAdmin admin = new MappingAdmin(connection);
                    Mapping current = admin.getMapping(this.transMeta.environmentSubstitute(this.m_mappedTableNamesCombo.getText()), this.transMeta.environmentSubstitute(this.m_mappingNamesCombo.getText()));
                    this.m_currentMeta.setMapping(current);
                    this.m_currentMeta.setSourceMappingName("");
                }
                catch (Exception e) {
                    this.logError(Messages.getString("HBaseInputDialog.ErrorMessage.UnableToGetMapping") + " \"" + this.transMeta.environmentSubstitute(this.m_mappedTableNamesCombo.getText() + "," + this.transMeta.environmentSubstitute(this.m_mappingNamesCombo.getText()) + "\""), e);
                    new ErrorDialog(this.shell, Messages.getString("HBaseInputDialog.ErrorMessage.UnableToGetMapping"), Messages.getString("HBaseInputDialog.ErrorMessage.UnableToGetMapping") + " \"" + this.transMeta.environmentSubstitute(this.m_mappedTableNamesCombo.getText() + "," + this.transMeta.environmentSubstitute(this.m_mappingNamesCombo.getText()) + "\""), e);
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception e) {
                            String msg = Messages.getString("HBaseInputDialog.ErrorMessage.FailedClosingHBaseConnection");
                            this.logError(msg, e);
                            new ErrorDialog(this.shell, msg, msg, e);
                        }
                    }
                }
            }
        } else {
            this.m_currentMeta.setMapping(null);
        }
        if (!((Object)((Object)this.m_originalMeta)).equals((Object)this.m_currentMeta)) {
            this.m_currentMeta.setChanged();
            this.changed = this.m_currentMeta.hasChanged();
        }
        this.dispose();
    }

    protected void cancel() {
        this.stepname = null;
        this.m_currentMeta.setChanged(this.changed);
        this.dispose();
    }

    private void getData() {
        this.namedClusterWidget.setSelectedNamedCluster(this.m_currentMeta.getNamedCluster().getName());
        if (!Const.isEmpty((String)this.m_currentMeta.getCoreConfigURL())) {
            this.m_coreConfigText.setText(this.m_currentMeta.getCoreConfigURL());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getDefaultConfigURL())) {
            this.m_defaultConfigText.setText(this.m_currentMeta.getDefaultConfigURL());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getSourceTableName())) {
            this.m_mappedTableNamesCombo.setText(this.m_currentMeta.getSourceTableName());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getSourceMappingName())) {
            this.m_mappingNamesCombo.setText(this.m_currentMeta.getSourceMappingName());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getKeyStartValue())) {
            this.m_keyStartText.setText(this.m_currentMeta.getKeyStartValue());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getKeyStopValue())) {
            this.m_keyStopText.setText(this.m_currentMeta.getKeyStopValue());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getScannerCacheSize())) {
            this.m_scanCacheText.setText(this.m_currentMeta.getScannerCacheSize());
        }
        this.m_matchAnyBut.setSelection(this.m_currentMeta.getMatchAnyFilter());
        this.m_matchAllBut.setSelection(!this.m_currentMeta.getMatchAnyFilter());
        if (this.m_currentMeta.getColumnFilters() != null && this.m_currentMeta.getColumnFilters().size() > 0) {
            for (ColumnFilter f : this.m_currentMeta.getColumnFilters()) {
                TableItem item = new TableItem(this.m_filtersView.table, 0);
                if (!Const.isEmpty((String)f.getFieldAlias())) {
                    item.setText(1, f.getFieldAlias());
                }
                if (!Const.isEmpty((String)f.getFieldType())) {
                    item.setText(2, f.getFieldType());
                }
                if (f.getComparisonOperator() != null) {
                    item.setText(3, f.getComparisonOperator().toString());
                }
                if (!Const.isEmpty((String)f.getConstant())) {
                    item.setText(4, f.getConstant());
                }
                item.setText(6, f.getSignedComparison() ? "Y" : "N");
                if (Const.isEmpty((String)f.getFormat())) continue;
                item.setText(5, f.getFormat());
            }
            this.m_filtersView.removeEmptyRows();
            this.m_filtersView.setRowNums();
            this.m_filtersView.optWidth(true);
        }
        if (Const.isEmpty((String)this.m_currentMeta.getSourceMappingName()) && this.m_currentMeta.getMapping() != null) {
            this.m_mappingEditor.setMapping(this.m_currentMeta.getMapping());
            this.m_storeMappingInStepMetaData.setSelection(true);
        }
        this.checkKeyInformation(true, false);
    }

    @Override
    public HBaseService getHBaseService() throws ClusterInitializationException {
        NamedCluster nc = this.namedClusterWidget.getSelectedNamedCluster();
        return (HBaseService)this.namedClusterServiceLocator.getService(nc, HBaseService.class);
    }

    @Override
    public HBaseConnection getHBaseConnection() throws IOException, ClusterInitializationException {
        Object conf = null;
        String coreConf = "";
        String defaultConf = "";
        String zookeeperHosts = "";
        NamedCluster nc = this.namedClusterWidget.getSelectedNamedCluster();
        HBaseService hBaseService = this.getHBaseService();
        if (nc != null) {
            zookeeperHosts = this.transMeta.environmentSubstitute(nc.getZooKeeperHost());
        }
        if (!Const.isEmpty((String)this.m_coreConfigText.getText())) {
            coreConf = this.transMeta.environmentSubstitute(this.m_coreConfigText.getText());
        }
        if (!Const.isEmpty((String)this.m_defaultConfigText.getText())) {
            defaultConf = this.transMeta.environmentSubstitute(this.m_defaultConfigText.getText());
        }
        if (Const.isEmpty((String)zookeeperHosts) && Const.isEmpty((String)coreConf) && Const.isEmpty((String)defaultConf)) {
            throw new IOException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"MappingDialog.Error.Message.CantConnectNoConnectionDetailsProvided", (String[])new String[0]));
        }
        return hBaseService.getHBaseConnection((VariableSpace)this.transMeta, coreConf, defaultConf, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkKeyInformation(boolean quiet, boolean readFieldsFromMapping) {
        boolean displayFieldsMappingFromHBase;
        String zookeeperQuorumText = null;
        NamedCluster nc = this.namedClusterWidget.getSelectedNamedCluster();
        if (nc != null) {
            zookeeperQuorumText = nc.getZooKeeperHost();
        }
        boolean displayFieldsEmbeddedMapping = this.m_mappingEditor.getMapping(false, null, false) != null && Const.isEmpty((String)this.m_mappingNamesCombo.getText());
        boolean bl = displayFieldsMappingFromHBase = (!Const.isEmpty((String)this.m_coreConfigText.getText()) || !Const.isEmpty((String)zookeeperQuorumText)) && !Const.isEmpty((String)this.m_mappedTableNamesCombo.getText()) && !Const.isEmpty((String)this.m_mappingNamesCombo.getText());
        if (displayFieldsEmbeddedMapping || displayFieldsMappingFromHBase) {
            try {
                String valuesString;
                String format;
                String aliasS;
                this.m_indexedLookup = new HashMap<String, String>();
                MappingAdmin admin = null;
                Mapping current = null;
                Map mappedColumns = null;
                boolean filterAliasesDone = false;
                try (HBaseConnection connection = null;){
                    if (displayFieldsMappingFromHBase && readFieldsFromMapping) {
                        connection = this.getHBaseConnection();
                        if (displayFieldsMappingFromHBase) {
                            admin = new MappingAdmin(connection);
                        }
                        current = admin.getMapping(this.transMeta.environmentSubstitute(this.m_mappedTableNamesCombo.getText()), this.transMeta.environmentSubstitute(this.m_mappingNamesCombo.getText()));
                    } else {
                        current = this.m_mappingEditor.getMapping(false, null, true);
                    }
                    if (current != null) {
                        this.m_keyName = current.getKeyName();
                        this.m_keyType = current.getKeyType();
                        this.m_keyInfo.setText("HBase Key: " + this.m_keyName + " (" + this.m_keyType.toString() + ")");
                        this.m_mappedColumns = mappedColumns = current.getMappedColumns();
                        ArrayList<String> filterAliasNames = new ArrayList<String>();
                        filterAliasNames.add(this.m_keyName);
                        for (Object alias : mappedColumns.keySet()) {
                            HBaseValueMetaInterface column = (HBaseValueMetaInterface)mappedColumns.get(alias);
                            String aliasS2 = column.getAlias();
                            if (!column.isNumeric() && !column.isDate() && !column.isString() && !column.isBoolean()) continue;
                            filterAliasNames.add(aliasS2);
                        }
                        String[] filterAliasNamesA = filterAliasNames.toArray(new String[1]);
                        this.m_filterAliasCI.setComboValues(filterAliasNamesA);
                        filterAliasesDone = true;
                    } else {
                        this.m_keyInfo.setText("");
                    }
                }
                this.m_fieldsView.clearAll(false);
                ByteConversionUtil byteConversionUtil = this.getHBaseService().getByteConversionUtil();
                if (current != null && readFieldsFromMapping) {
                    TableItem item = new TableItem(this.m_fieldsView.table, 0);
                    item.setText(1, this.m_keyName);
                    item.setText(2, "Y");
                    item.setText(7, "N");
                    if (current.getKeyType() == Mapping.KeyType.DATE || current.getKeyType() == Mapping.KeyType.UNSIGNED_DATE) {
                        item.setText(5, ValueMeta.getTypeDesc((int)3));
                    } else if (current.getKeyType() == Mapping.KeyType.STRING) {
                        item.setText(5, ValueMeta.getTypeDesc((int)2));
                    } else if (current.getKeyType() == Mapping.KeyType.INTEGER || current.getKeyType() == Mapping.KeyType.UNSIGNED_INTEGER || current.getKeyType() == Mapping.KeyType.UNSIGNED_LONG || current.getKeyType() == Mapping.KeyType.LONG) {
                        item.setText(5, ValueMeta.getTypeDesc((int)5));
                    } else {
                        item.setText(5, ValueMeta.getTypeDesc((int)8));
                    }
                    for (String alias : mappedColumns.keySet()) {
                        HBaseValueMetaInterface column = (HBaseValueMetaInterface)mappedColumns.get(alias);
                        aliasS = column.getAlias();
                        String family = column.getColumnFamily();
                        String name = column.getColumnName();
                        String type = column.getTypeDesc();
                        format = column.getConversionMask();
                        item = new TableItem(this.m_fieldsView.table, 0);
                        if (column.getStorageType() == 2) {
                            valuesString = byteConversionUtil.objectIndexValuesToString(column.getIndex());
                            this.m_indexedLookup.put(aliasS, valuesString);
                            item.setText(7, "Y");
                        } else {
                            item.setText(7, "N");
                        }
                        item.setText(1, aliasS);
                        item.setText(2, "N");
                        item.setText(3, family);
                        item.setText(4, name);
                        item.setText(5, type);
                        if (Const.isEmpty((String)format)) continue;
                        item.setText(6, format);
                    }
                }
                if (!readFieldsFromMapping && this.m_currentMeta.getOutputFields() != null && this.m_currentMeta.getOutputFields().size() > 0) {
                    ArrayList<String> filterAliasNames = new ArrayList<String>();
                    for (HBaseValueMetaInterface column : this.m_currentMeta.getOutputFields()) {
                        TableItem item = new TableItem(this.m_fieldsView.table, 0);
                        aliasS = column.getAlias();
                        String type = column.getTypeDesc();
                        item.setText(1, aliasS);
                        item.setText(5, type);
                        if (column.isKey()) {
                            item.setText(2, "Y");
                            item.setText(7, "N");
                            if (!Const.isEmpty((String)column.getConversionMask())) {
                                item.setText(6, column.getConversionMask());
                            }
                            if (filterAliasesDone) continue;
                            filterAliasNames.add(aliasS);
                            continue;
                        }
                        item.setText(2, "N");
                        if ((column.isNumeric() || column.isDate() || column.isString()) && !filterAliasesDone) {
                            filterAliasNames.add(aliasS);
                        }
                        String family = column.getColumnFamily();
                        String name = column.getColumnName();
                        format = column.getConversionMask();
                        if (column.getStorageType() == 2) {
                            valuesString = byteConversionUtil.objectIndexValuesToString(column.getIndex());
                            this.m_indexedLookup.put(aliasS, valuesString);
                            item.setText(7, "Y");
                        } else {
                            item.setText(7, "N");
                        }
                        item.setText(3, family);
                        item.setText(4, name);
                        if (Const.isEmpty((String)format)) continue;
                        item.setText(6, format);
                    }
                    if (!filterAliasesDone) {
                        String[] filterAliasNamesA = filterAliasNames.toArray(new String[1]);
                        this.m_filterAliasCI.setComboValues(filterAliasNamesA);
                        filterAliasesDone = true;
                    }
                }
                this.m_fieldsView.removeEmptyRows();
                this.m_fieldsView.setRowNums();
                this.m_fieldsView.optWidth(true);
            }
            catch (Exception ex) {
                if (!quiet) {
                    this.logError(Messages.getString("HBaseInputDialog.ErrorMessage.UnableToGetMapping") + " \"" + this.transMeta.environmentSubstitute(this.m_mappedTableNamesCombo.getText() + "," + this.transMeta.environmentSubstitute(this.m_mappingNamesCombo.getText()) + "\""), ex);
                    new ErrorDialog(this.shell, Messages.getString("HBaseInputDialog.ErrorMessage.UnableToGetMapping"), Messages.getString("HBaseInputDialog.ErrorMessage.UnableToGetMapping") + " \"" + this.transMeta.environmentSubstitute(this.m_mappedTableNamesCombo.getText() + "," + this.transMeta.environmentSubstitute(this.m_mappingNamesCombo.getText()) + "\""), ex);
                }
                this.m_keyInfo.setText(Messages.getString("HBaseInputDialog.ErrorMessage.UnableToGetMapping"));
            }
        } else {
            this.m_keyInfo.setText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupMappedTableNames() {
        this.m_mappedTableNamesCombo.removeAll();
        HBaseConnection connection = null;
        try {
            connection = this.getHBaseConnection();
            MappingAdmin admin = new MappingAdmin(connection);
            Set<String> tableNames = admin.getMappedTables();
            for (String s : tableNames) {
                this.m_mappedTableNamesCombo.add(s);
            }
        }
        catch (Exception e) {
            this.logError(Messages.getString("HBaseInputDialog.ErrorMessage.UnableToConnect"), e);
            new ErrorDialog(this.shell, Messages.getString("HBaseInputDialog.ErrorMessage.UnableToConnect"), Messages.getString("HBaseInputDialog.ErrorMessage.UnableToConnect"), e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    String msg = Messages.getString("HBaseInputDialog.ErrorMessage.FailedClosingHBaseConnection");
                    this.logError(msg, e);
                    new ErrorDialog(this.shell, msg, msg, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupMappingNamesForTable(boolean quiet) {
        this.m_mappingNamesCombo.removeAll();
        if (!Const.isEmpty((String)this.m_mappedTableNamesCombo.getText())) {
            HBaseConnection connection = null;
            try {
                connection = this.getHBaseConnection();
                MappingAdmin admin = new MappingAdmin(connection);
                List<String> mappingNames = admin.getMappingNames(this.m_mappedTableNamesCombo.getText().trim());
                for (String n : mappingNames) {
                    this.m_mappingNamesCombo.add(n);
                }
            }
            catch (Exception ex) {
                if (!quiet) {
                    this.logError(Messages.getString("HBaseInputDialog.ErrorMessage.UnableToConnect"), ex);
                    new ErrorDialog(this.shell, Messages.getString("HBaseInputDialog.ErrorMessage.UnableToConnect"), Messages.getString("HBaseInputDialog.ErrorMessage.UnableToConnect"), ex);
                }
            }
            finally {
                block16: {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception e) {
                            if (quiet) break block16;
                            String msg = Messages.getString("HBaseInputDialog.ErrorMessage.FailedClosingHBaseConnection");
                            this.logError(msg, e);
                            new ErrorDialog(this.shell, msg, msg, e);
                        }
                    }
                }
            }
        }
    }

    @Override
    public String getCurrentConfiguration() {
        this.updateMetaConnectionDetails(this.m_configurationMeta);
        return this.m_configurationMeta.getXML();
    }
}

