/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.database.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.database.IDatabaseDialect;
import org.pentaho.database.IDatabaseDialectProvider;
import org.pentaho.database.IDriverLocator;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.database.service.DatabaseDialectService;
import org.pentaho.database.util.ClassUtil;

public class ServiceLoaderDatabaseDialectProvider
implements IDatabaseDialectProvider {
    private static final Log LOG = LogFactory.getLog(DatabaseDialectService.class);
    private final List<IDatabaseDialect> usableDialects;
    private final Map<IDatabaseType, IDatabaseDialect> usableDialectTypeMap;
    private List<IDatabaseDialect> allDialects;
    private Map<IDatabaseType, IDatabaseDialect> allDialectsTypeMap;

    public ServiceLoaderDatabaseDialectProvider() {
        this(databaseDialectClass -> ServiceLoader.load(databaseDialectClass, ServiceLoaderDatabaseDialectProvider.class.getClassLoader()));
    }

    public ServiceLoaderDatabaseDialectProvider(Function<Class<IDatabaseDialect>, Iterable<IDatabaseDialect>> loaderFunction) {
        Stream<IDatabaseDialect> databaseDialectStream = StreamSupport.stream(loaderFunction.apply(IDatabaseDialect.class).spliterator(), false);
        this.allDialects = Collections.unmodifiableList(databaseDialectStream.collect(Collectors.toList()));
        this.allDialectsTypeMap = Collections.unmodifiableMap(this.allDialects.stream().collect(Collectors.toMap(IDatabaseDialect::getDatabaseType, Function.identity())));
        this.usableDialects = Collections.unmodifiableList(this.allDialects.stream().filter(this.usableFilter(LOG)).collect(Collectors.toList()));
        this.usableDialectTypeMap = Collections.unmodifiableMap(this.usableDialects.stream().collect(Collectors.toMap(IDatabaseDialect::getDatabaseType, Function.identity())));
    }

    @Override
    public Collection<IDatabaseDialect> getDialects(boolean usableOnly) {
        return usableOnly ? this.usableDialects : this.allDialects;
    }

    @Override
    public IDatabaseDialect getDialect(boolean usableOnly, IDatabaseType databaseType) {
        return usableOnly ? this.usableDialectTypeMap.get(databaseType) : this.allDialectsTypeMap.get(databaseType);
    }

    Predicate<IDatabaseDialect> usableFilter(Log logger) {
        if (logger.isDebugEnabled()) {
            return dialect -> {
                logger.debug((Object)String.format("Checking for presence of %s ( %s )", dialect.getDatabaseType().getName(), dialect.getNativeDriver()));
                boolean result = false;
                if (dialect instanceof IDriverLocator) {
                    result = ((IDriverLocator)((Object)dialect)).isUsable();
                } else if (ClassUtil.canLoadClass(dialect.getNativeDriver())) {
                    result = true;
                }
                if (!result) {
                    logger.debug((Object)String.format("%s not detected.", dialect.getDatabaseType().getName()));
                }
                return result;
            };
        }
        return dialect -> {
            if (dialect instanceof IDriverLocator) {
                return ((IDriverLocator)((Object)dialect)).isUsable();
            }
            return ClassUtil.canLoadClass(dialect.getNativeDriver());
        };
    }
}

