/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.googledrive.lifecycle;

import java.io.File;
import java.util.Arrays;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.pentaho.capabilities.impl.DefaultCapabilityManager;
import org.pentaho.di.core.annotations.KettleLifecyclePlugin;
import org.pentaho.di.core.lifecycle.KettleLifecycleListener;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.googledrive.vfs.GoogleDriveFileObject;
import org.pentaho.googledrive.vfs.GoogleDriveFileProvider;

@KettleLifecyclePlugin(id="GoogleDrivePluginLifecycleListener", name="GoogleDrivePluginLifecycleListener")
public class GoogleDrivePluginLifecycleListener
implements KettleLifecycleListener {
    private ResourceBundle resourceBundle = PropertyResourceBundle.getBundle("plugin");
    private static Log log = LogFactory.getLog(GoogleDrivePluginLifecycleListener.class);

    public void onEnvironmentInit() throws LifecycleException {
        try {
            FileSystemManager fsm;
            DefaultCapabilityManager capabilityManager;
            boolean proceed = true;
            if (!new File(GoogleDriveFileObject.resolveCredentialsPath() + "/" + this.resourceBundle.getString("client.secrets")).exists()) {
                proceed = false;
                log.warn((Object)("The Google Authorization secrets security token file (" + this.resourceBundle.getString("client.secrets") + ") is not present in the credentials folder. This file is necessary to activate the Google Drive VFS plugin."));
            }
            if (!new File(GoogleDriveFileObject.resolveCredentialsPath() + "/" + this.resourceBundle.getString("stored.credential")).exists() && (capabilityManager = DefaultCapabilityManager.getInstance()).capabilityExist("pentaho-server")) {
                proceed = false;
                log.warn((Object)("The Google Authorization Code Flow security token file (" + this.resourceBundle.getString("stored.credential") + ") is not present in the credentials folder.  This file is necessary to activate the Google Drive VFS plugin."));
            }
            if (proceed && (fsm = KettleVFS.getInstance().getFileSystemManager()) instanceof DefaultFileSystemManager && !Arrays.asList(fsm.getSchemes()).contains("googledrive")) {
                ((DefaultFileSystemManager)fsm).addProvider("googledrive", (FileProvider)new GoogleDriveFileProvider());
            }
        }
        catch (FileSystemException e) {
            throw new LifecycleException(e.getMessage(), false);
        }
    }

    public void onEnvironmentShutdown() {
    }
}

