/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsoninput;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.poi.util.IOUtils;
import org.pentaho.di.core.QueueRowSet;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.file.BaseFileInputStep;
import org.pentaho.di.trans.steps.file.BaseFileInputStepData;
import org.pentaho.di.trans.steps.file.IBaseFileInputReader;
import org.pentaho.di.trans.steps.jsoninput.JsonInputData;
import org.pentaho.di.trans.steps.jsoninput.JsonInputField;
import org.pentaho.di.trans.steps.jsoninput.JsonInputMeta;
import org.pentaho.di.trans.steps.jsoninput.exception.JsonInputException;
import org.pentaho.di.trans.steps.jsoninput.reader.FastJsonReader;
import org.pentaho.di.trans.steps.jsoninput.reader.InputsReader;
import org.pentaho.di.trans.steps.jsoninput.reader.RowOutputConverter;

public class JsonInput
extends BaseFileInputStep<JsonInputMeta, JsonInputData>
implements StepInterface {
    private static Class<?> PKG = JsonInputMeta.class;
    private RowOutputConverter rowOutputConverter;
    private static final byte[] EMPTY_JSON = "{}".getBytes();

    public JsonInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    protected boolean init() {
        ((JsonInputData)this.data).rownr = 1L;
        ((JsonInputData)this.data).nrInputFields = ((JsonInputMeta)this.meta).getInputFields().length;
        ((JsonInputData)this.data).repeatedFields = new BitSet(((JsonInputData)this.data).nrInputFields);
        for (int i = 0; i < ((JsonInputData)this.data).nrInputFields; ++i) {
            JsonInputField field = ((JsonInputMeta)this.meta).getInputFields()[i];
            if (!field.isRepeated()) continue;
            ((JsonInputData)this.data).repeatedFields.set(i);
        }
        try {
            this.createReader();
        }
        catch (KettleException e) {
            this.logError(e.getMessage());
            return false;
        }
        return true;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.first) {
            this.first = false;
            this.prepareToRowProcessing();
        }
        Object[] outRow = null;
        try {
            outRow = this.getOneOutputRow();
            if (outRow == null) {
                this.setOutputDone();
                return false;
            }
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"JsonInput.Log.ReadRow", (String[])new String[]{((JsonInputData)this.data).outputRowMeta.getString(outRow)}));
            }
            this.incrementLinesInput();
            ++((JsonInputData)this.data).rownr;
            this.putRow(((JsonInputData)this.data).outputRowMeta, outRow);
            if (((JsonInputMeta)this.meta).getRowLimit() > 0L && ((JsonInputData)this.data).rownr > ((JsonInputMeta)this.meta).getRowLimit()) {
                this.setOutputDone();
                return false;
            }
        }
        catch (JsonInputException e) {
            if (!this.getStepMeta().isDoingErrorHandling()) {
                this.stopErrorExecution((Exception)((Object)e));
                return false;
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JsonInput.ErrorInStepRunning", (String[])new String[]{e.getMessage()}));
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.sendErrorRow(e.toString());
            }
            this.incrementErrors();
            this.stopErrorExecution(e);
            return false;
        }
        return true;
    }

    private void stopErrorExecution(Exception e) {
        this.stopAll();
        this.setOutputDone();
    }

    protected void prepareToRowProcessing() throws KettleException, KettleStepException, KettleValueException {
        if (!((JsonInputMeta)this.meta).isInFields()) {
            ((JsonInputData)this.data).outputRowMeta = new RowMeta();
            if (!((JsonInputMeta)this.meta).isDoNotFailIfNoFile() && ((JsonInputData)this.data).files.nrOfFiles() == 0) {
                String errMsg = BaseMessages.getString(PKG, (String)"JsonInput.Log.NoFiles", (String[])new String[0]);
                this.logError(errMsg);
                this.inputError(errMsg);
            }
        } else {
            ((JsonInputData)this.data).readrow = this.getRow();
            ((JsonInputData)this.data).inputRowMeta = this.getInputRowMeta();
            if (((JsonInputData)this.data).inputRowMeta == null) {
                ((JsonInputData)this.data).hasFirstRow = false;
                return;
            }
            ((JsonInputData)this.data).hasFirstRow = true;
            ((JsonInputData)this.data).outputRowMeta = ((JsonInputData)this.data).inputRowMeta.clone();
            if (Utils.isEmpty((CharSequence)((JsonInputMeta)this.meta).getFieldValue())) {
                this.logError(BaseMessages.getString(PKG, (String)"JsonInput.Log.NoField", (String[])new String[0]));
                throw new KettleException(BaseMessages.getString(PKG, (String)"JsonInput.Log.NoField", (String[])new String[0]));
            }
            if (((JsonInputData)this.data).indexSourceField < 0) {
                ((JsonInputData)this.data).indexSourceField = this.getInputRowMeta().indexOfValue(((JsonInputMeta)this.meta).getFieldValue());
                if (((JsonInputData)this.data).indexSourceField < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"JsonInput.Log.ErrorFindingField", (String[])new String[]{((JsonInputMeta)this.meta).getFieldValue()}));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"JsonInput.Exception.CouldnotFindField", (String[])new String[]{((JsonInputMeta)this.meta).getFieldValue()}));
                }
            }
            if (((JsonInputMeta)this.meta).isRemoveSourceField()) {
                ((JsonInputData)this.data).outputRowMeta.removeValueMeta(((JsonInputData)this.data).indexSourceField);
                ((JsonInputData)this.data).totalpreviousfields = ((JsonInputData)this.data).inputRowMeta.size() - 1;
            } else {
                ((JsonInputData)this.data).totalpreviousfields = ((JsonInputData)this.data).inputRowMeta.size();
            }
        }
        ((JsonInputMeta)this.meta).getFields(((JsonInputData)this.data).outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
        ((JsonInputData)this.data).convertRowMeta = ((JsonInputData)this.data).outputRowMeta.cloneToType(2);
        ((JsonInputData)this.data).inputs = new InputsReader(this, (JsonInputMeta)this.meta, (JsonInputData)this.data, new InputErrorHandler()).iterator();
        ((JsonInputData)this.data).readerRowSet = new QueueRowSet();
        ((JsonInputData)this.data).readerRowSet.setDone();
        this.rowOutputConverter = new RowOutputConverter(this.getLogChannel());
    }

    private void addFileToResultFilesname(FileObject file) {
        if (((JsonInputMeta)this.meta).addResultFile()) {
            ResultFile resultFile = new ResultFile(0, file, this.getTransMeta().getName(), this.getStepname());
            resultFile.setComment(BaseMessages.getString(PKG, (String)"JsonInput.Log.FileAddedResult", (String[])new String[0]));
            this.addResultFile(resultFile);
        }
    }

    public boolean onNewFile(FileObject file) throws FileSystemException {
        if (file == null) {
            String errMsg = BaseMessages.getString(PKG, (String)"JsonInput.Log.IsNotAFile", (String[])new String[]{"null"});
            this.logError(errMsg);
            this.inputError(errMsg);
            return false;
        }
        if (!file.exists()) {
            String errMsg = BaseMessages.getString(PKG, (String)"JsonInput.Log.IsNotAFile", (String[])new String[]{file.getName().getFriendlyURI()});
            this.logError(errMsg);
            this.inputError(errMsg);
            return false;
        }
        if (this.hasAdditionalFileFields()) {
            this.fillFileAdditionalFields((JsonInputData)this.data, file);
        }
        if (file.getContent().getSize() == 0L) {
            if (((JsonInputMeta)this.meta).isIgnoreEmptyFile()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"JsonInput.Error.FileSizeZero", (String[])new String[]{"" + file.getName()}));
            } else {
                this.logError(BaseMessages.getString(PKG, (String)"JsonInput.Error.FileSizeZero", (String[])new String[]{"" + file.getName()}));
                this.incrementErrors();
                return false;
            }
        }
        return true;
    }

    protected void fillFileAdditionalFields(JsonInputData data, FileObject file) throws FileSystemException {
        super.fillFileAdditionalFields((BaseFileInputStepData)data, file);
        data.filename = KettleVFS.getFilename((FileObject)file);
        ++data.filenr;
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JsonInput.Log.OpeningFile", (String[])new String[]{file.toString()}));
        }
        this.addFileToResultFilesname(file);
    }

    private void parseNextInputToRowSet(InputStream input) throws KettleException {
        try {
            ((JsonInputData)this.data).readerRowSet = ((JsonInputData)this.data).reader.parse(input);
            input.close();
        }
        catch (KettleException ke) {
            this.logInputError(ke);
            throw new JsonInputException(ke);
        }
        catch (Exception e) {
            this.logInputError(e);
            throw new JsonInputException(e);
        }
    }

    private void logInputError(KettleException e) {
        this.logError(e.getLocalizedMessage(), e);
        this.inputError(e.getLocalizedMessage());
    }

    private void logInputError(Exception e) {
        String errMsg = !((JsonInputMeta)this.meta).isInFields() || ((JsonInputMeta)this.meta).getIsAFile() ? BaseMessages.getString(PKG, (String)"JsonReader.Error.ParsingFile", (String[])new String[]{((JsonInputData)this.data).filename}) : BaseMessages.getString(PKG, (String)"JsonReader.Error.ParsingString", (Object[])new Object[]{((JsonInputData)this.data).readrow[((JsonInputData)this.data).indexSourceField]});
        this.logError(errMsg, e);
        this.inputError(errMsg);
    }

    private void incrementErrors() {
        this.setErrors(this.getErrors() + 1L);
    }

    private void inputError(String errorMsg) {
        if (this.getStepMeta().isDoingErrorHandling()) {
            this.sendErrorRow(errorMsg);
        } else {
            this.incrementErrors();
        }
    }

    private Object[] getOneOutputRow() throws KettleException {
        if (((JsonInputMeta)this.meta).isInFields() && !((JsonInputData)this.data).hasFirstRow) {
            return null;
        }
        Object[] rawReaderRow = null;
        while ((rawReaderRow = ((JsonInputData)this.data).readerRowSet.getRow()) == null) {
            if (((JsonInputData)this.data).inputs.hasNext() && ((JsonInputData)this.data).readerRowSet.isDone()) {
                try {
                    InputStream nextIn = ((JsonInputData)this.data).inputs.next();
                    Throwable throwable = null;
                    try {
                        if (nextIn != null) {
                            this.parseNextInputToRowSet(nextIn);
                            continue;
                        }
                        this.parseNextInputToRowSet(new ByteArrayInputStream(EMPTY_JSON));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (nextIn == null) continue;
                        if (throwable != null) {
                            try {
                                nextIn.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        nextIn.close();
                    }
                }
                catch (IOException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"JsonInput.Log.UnexpectedError", (String[])new String[]{e.toString()}), e);
                    this.incrementErrors();
                }
                continue;
            }
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JsonInput.Log.FinishedProcessing", (String[])new String[0]));
            }
            return null;
        }
        Object[] outputRow = this.rowOutputConverter.getRow(this.buildBaseOutputRow(), rawReaderRow, (JsonInputData)this.data);
        this.addExtraFields(outputRow, (JsonInputData)this.data);
        return outputRow;
    }

    private void sendErrorRow(String errorMsg) {
        try {
            String defaultErrCode = "JsonInput001";
            if (((JsonInputData)this.data).readrow != null) {
                this.putError(this.getInputRowMeta(), ((JsonInputData)this.data).readrow, 1L, errorMsg, ((JsonInputMeta)this.meta).getFieldValue(), defaultErrCode);
            } else {
                this.putError((RowMetaInterface)new RowMeta(), new Object[0], 1L, errorMsg, null, defaultErrCode);
            }
        }
        catch (KettleStepException e) {
            this.logError(e.getLocalizedMessage(), e);
        }
    }

    private boolean hasAdditionalFileFields() {
        return ((JsonInputData)this.data).file != null;
    }

    private Object[] buildBaseOutputRow() {
        Object[] outputRowData;
        if (((JsonInputData)this.data).readrow != null) {
            if (((JsonInputMeta)this.meta).isRemoveSourceField() && ((JsonInputData)this.data).indexSourceField > -1) {
                int sz = ((JsonInputData)this.data).readrow.length;
                outputRowData = RowDataUtil.allocateRowData((int)((JsonInputData)this.data).outputRowMeta.size());
                int ii = 0;
                for (int i = 0; i < sz; ++i) {
                    if (i == ((JsonInputData)this.data).indexSourceField) continue;
                    outputRowData[ii++] = ((JsonInputData)this.data).readrow[i];
                }
            } else {
                outputRowData = RowDataUtil.createResizedCopy((Object[])((JsonInputData)this.data).readrow, (int)((JsonInputData)this.data).outputRowMeta.size());
            }
        } else {
            outputRowData = RowDataUtil.allocateRowData((int)((JsonInputData)this.data).outputRowMeta.size());
        }
        return outputRowData;
    }

    private void addExtraFields(Object[] outputRowData, JsonInputData data) {
        int rowIndex = data.totalpreviousfields + data.nrInputFields;
        if (((JsonInputMeta)this.meta).includeFilename() && !Utils.isEmpty((CharSequence)((JsonInputMeta)this.meta).getFilenameField())) {
            outputRowData[rowIndex++] = data.filename;
        }
        if (((JsonInputMeta)this.meta).includeRowNumber() && !Utils.isEmpty((CharSequence)((JsonInputMeta)this.meta).getRowNumberField())) {
            outputRowData[rowIndex++] = new Long(data.rownr);
        }
        if (((JsonInputMeta)this.meta).getShortFileNameField() != null && ((JsonInputMeta)this.meta).getShortFileNameField().length() > 0) {
            outputRowData[rowIndex++] = data.shortFilename;
        }
        if (((JsonInputMeta)this.meta).getExtensionField() != null && ((JsonInputMeta)this.meta).getExtensionField().length() > 0) {
            outputRowData[rowIndex++] = data.extension;
        }
        if (((JsonInputMeta)this.meta).getPathField() != null && ((JsonInputMeta)this.meta).getPathField().length() > 0) {
            outputRowData[rowIndex++] = data.path;
        }
        if (((JsonInputMeta)this.meta).getSizeField() != null && ((JsonInputMeta)this.meta).getSizeField().length() > 0) {
            outputRowData[rowIndex++] = new Long(data.size);
        }
        if (((JsonInputMeta)this.meta).isHiddenField() != null && ((JsonInputMeta)this.meta).isHiddenField().length() > 0) {
            outputRowData[rowIndex++] = new Boolean(data.path);
        }
        if (((JsonInputMeta)this.meta).getLastModificationDateField() != null && ((JsonInputMeta)this.meta).getLastModificationDateField().length() > 0) {
            outputRowData[rowIndex++] = data.lastModificationDateTime;
        }
        if (((JsonInputMeta)this.meta).getUriField() != null && ((JsonInputMeta)this.meta).getUriField().length() > 0) {
            outputRowData[rowIndex++] = data.uriName;
        }
        if (((JsonInputMeta)this.meta).getRootUriField() != null && ((JsonInputMeta)this.meta).getRootUriField().length() > 0) {
            outputRowData[rowIndex++] = data.rootUriName;
        }
    }

    private void createReader() throws KettleException {
        JsonInputField[] inputFields = new JsonInputField[((JsonInputData)this.data).nrInputFields];
        for (int i = 0; i < ((JsonInputData)this.data).nrInputFields; ++i) {
            JsonInputField field = ((JsonInputMeta)this.meta).getInputFields()[i].clone();
            field.setPath(this.environmentSubstitute(field.getPath()));
            inputFields[i] = field;
        }
        ((JsonInputData)this.data).reader = new FastJsonReader(inputFields, ((JsonInputMeta)this.meta).isDefaultPathLeafToNull(), this.log);
        ((JsonInputData)this.data).reader.setIgnoreMissingPath(((JsonInputMeta)this.meta).isIgnoreMissingPath());
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (JsonInputMeta)smi;
        this.data = (JsonInputData)sdi;
        if (((JsonInputData)this.data).file != null) {
            IOUtils.closeQuietly((Closeable)((JsonInputData)this.data).file);
        }
        ((JsonInputData)this.data).inputs = null;
        ((JsonInputData)this.data).reader = null;
        ((JsonInputData)this.data).readerRowSet = null;
        ((JsonInputData)this.data).repeatedFields = null;
        super.dispose(smi, sdi);
    }

    protected IBaseFileInputReader createReader(JsonInputMeta meta, JsonInputData data, FileObject file) throws Exception {
        throw new NotImplementedException();
    }

    private class InputErrorHandler
    implements InputsReader.ErrorHandler {
        private InputErrorHandler() {
        }

        @Override
        public void error(Exception e) {
            JsonInput.this.logError(BaseMessages.getString((Class)PKG, (String)"JsonInput.Log.UnexpectedError", (String[])new String[]{e.toString()}));
            JsonInput.this.setErrors(JsonInput.this.getErrors() + 1L);
        }

        @Override
        public void fileOpenError(FileObject file, FileSystemException e) {
            String msg = BaseMessages.getString((Class)PKG, (String)"JsonInput.Log.UnableToOpenFile", (String[])new String[]{"" + ((JsonInputData)((JsonInput)JsonInput.this).data).filenr, file.toString(), e.toString()});
            JsonInput.this.logError(msg);
            JsonInput.this.inputError(msg);
        }

        @Override
        public void fileCloseError(FileObject file, FileSystemException e) {
            this.error((Exception)e);
        }
    }
}

