/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.connections.ui.dialog;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.ui.core.dialog.ThinDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.platform.settings.ServerPort;
import org.pentaho.platform.settings.ServerPortRegistry;

public class ConnectionDialog
extends ThinDialog {
    private static final Image LOGO = GUIResource.getInstance().getImageLogoSmall();
    private static final String OSGI_SERVICE_PORT = "OSGI_SERVICE_PORT";
    private static final int OPTIONS = 68720;
    private static final String THIN_CLIENT_HOST = "THIN_CLIENT_HOST";
    private static final String THIN_CLIENT_PORT = "THIN_CLIENT_PORT";
    private static final String LOCALHOST = "127.0.0.1";

    public ConnectionDialog(Shell shell, int width, int height) {
        super(shell, width, height);
    }

    public void open(String title) {
        this.open(title, null);
    }

    public void open(String title, String connectionName) {
        StringBuilder clientPath = new StringBuilder();
        clientPath.append(ConnectionDialog.getClientPath());
        if (connectionName != null) {
            clientPath.append("#/summary");
            clientPath.append("?connection=").append(connectionName);
        } else {
            clientPath.append("#/intro");
        }
        super.createDialog(title, ConnectionDialog.getRepoURL(clientPath.toString()), 68720, LOGO);
        this.dialog.setMinimumSize(630, 630);
        new BrowserFunction(this.browser, "close"){

            public Object function(Object[] arguments) {
                ConnectionDialog.this.browser.dispose();
                ConnectionDialog.this.dialog.close();
                ConnectionDialog.this.dialog.dispose();
                return true;
            }
        };
        new BrowserFunction(this.browser, "setTitle"){

            public Object function(Object[] arguments) {
                ConnectionDialog.this.dialog.setText((String)arguments[0]);
                return true;
            }
        };
        new BrowserFunction(this.browser, "browse"){

            public Object function(Object[] arguments) {
                FileDialog dialog = new FileDialog(ConnectionDialog.this.getParent().getShell(), 4096);
                return dialog.open();
            }
        };
        while (!this.dialog.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    private static String getClientPath() {
        Properties properties = new Properties();
        try {
            InputStream inputStream = ConnectionDialog.class.getClassLoader().getResourceAsStream("project.properties");
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties.getProperty("CLIENT_PATH");
    }

    private static Integer getOsgiServicePort() {
        ServerPort osgiServicePort = ServerPortRegistry.getPort((String)OSGI_SERVICE_PORT);
        if (osgiServicePort != null) {
            return osgiServicePort.getAssignedPort();
        }
        return null;
    }

    private static String getRepoURL(String path) {
        Integer port;
        String host;
        try {
            host = ConnectionDialog.getKettleProperty(THIN_CLIENT_HOST);
            port = Integer.valueOf(ConnectionDialog.getKettleProperty(THIN_CLIENT_PORT));
        }
        catch (Exception e) {
            host = LOCALHOST;
            port = ConnectionDialog.getOsgiServicePort();
        }
        return "http://" + host + ":" + port + path;
    }

    private static String getKettleProperty(String propertyName) {
        return System.getProperty(propertyName);
    }
}

