/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags.treeutil;

import java.util.Vector;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulTreeCell;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulTreeItem;
import org.pentaho.ui.xul.containers.XulTreeRow;
import org.pentaho.ui.xul.swt.tags.SwtTreeItem;
import org.pentaho.ui.xul.util.ColumnType;
import org.pentaho.ui.xul.util.SwtXulUtil;

public class XulTableColumnLabelProvider
implements ITableLabelProvider {
    private static final String UNCHECKED = "UNCHECKED";
    private static final String CHECKED = "CHECKED";
    private XulTree tree;
    private XulDomContainer domContainer;

    public XulTableColumnLabelProvider(XulTree tree, XulDomContainer aDomContainer) {
        this.tree = tree;
        this.domContainer = aDomContainer;
        if (JFaceResources.getImageRegistry().getDescriptor(CHECKED) == null) {
            JFaceResources.getImageRegistry().put(UNCHECKED, this.makeImage(((TableViewer)tree.getManagedObject()).getControl().getShell(), false));
            JFaceResources.getImageRegistry().put(CHECKED, this.makeImage(((TableViewer)tree.getManagedObject()).getControl().getShell(), true));
        }
    }

    public String getColumnText(Object obj, int i) {
        XulTreeCell cell = ((XulTreeItem)obj).getRow().getCell(i);
        if (cell == null) {
            return "";
        }
        switch (this.tree.getColumns().getColumn(i).getColumnType()) {
            case CHECKBOX: {
                return cell.getLabel() != null ? cell.getLabel() : cell.getLabel();
            }
            case COMBOBOX: 
            case EDITABLECOMBOBOX: {
                Vector vec = (Vector)cell.getValue();
                if (vec != null && vec.size() > cell.getSelectedIndex()) {
                    return "" + vec.get(cell.getSelectedIndex());
                }
                return "";
            }
            case TEXT: {
                return cell.getLabel() != null ? cell.getLabel() : "";
            }
            case PASSWORD: {
                return this.getPasswordString(cell.getLabel().length());
            }
        }
        return cell.getLabel() != null ? cell.getLabel() : "";
    }

    private String getPasswordString(int len) {
        StringBuilder b = new StringBuilder();
        while (len-- > 0) {
            b.append('*');
        }
        return b.toString();
    }

    public void addListener(ILabelProviderListener ilabelproviderlistener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object obj, String s) {
        return false;
    }

    public void removeListener(ILabelProviderListener ilabelproviderlistener) {
    }

    public Image getColumnImage(Object row, int col) {
        if (this.tree.getColumns().getColumn(col).getColumnType() == ColumnType.CHECKBOX) {
            if (this.isSelected(row, col)) {
                return JFaceResources.getImageRegistry().get(CHECKED);
            }
            return JFaceResources.getImageRegistry().get(UNCHECKED);
        }
        if (this.tree.getColumns().getColumn(col).getImagebinding() != null) {
            String src = ((SwtTreeItem)((Object)row)).getImage();
            Display display = ((TableViewer)this.tree.getManagedObject()).getTable().getDisplay();
            return SwtXulUtil.getCachedImage(src, this.domContainer, display);
        }
        return null;
    }

    private Image makeImage(Shell shell, boolean type) {
        Shell placeholder = new Shell(8);
        Button btn = new Button((Composite)placeholder, 32);
        btn.setSelection(type);
        btn.pack();
        Point bsize = btn.computeSize(-1, -1);
        btn.setLocation(0, 0);
        placeholder.setLocation(-bsize.x * 2, -bsize.y * 2);
        placeholder.setSize(bsize);
        placeholder.open();
        GC gc = new GC((Drawable)btn);
        Image image = new Image((Device)shell.getDisplay(), bsize.x, bsize.y);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        placeholder.close();
        return image;
    }

    private boolean isSelected(Object row, int col) {
        XulTreeRow r = ((XulTreeItem)row).getRow();
        if (r == null || r.getChildNodes().size() < col) {
            return false;
        }
        XulTreeCell c = r.getCell(col);
        if (c == null) {
            return false;
        }
        Object val = c.getValue();
        if (val == null || !(val instanceof Boolean)) {
            return false;
        }
        return (Boolean)c.getValue();
    }
}

