/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.i18n.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.pentaho.osgi.i18n.LocalizationService;
import org.pentaho.osgi.i18n.resource.OSGIResourceBundle;
import org.pentaho.osgi.i18n.resource.OSGIResourceBundleCacheCallable;
import org.pentaho.osgi.i18n.resource.OSGIResourceBundleFactory;
import org.pentaho.osgi.i18n.settings.OSGIResourceNamingConvention;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizationManager
implements LocalizationService {
    private static Logger log = LoggerFactory.getLogger(LocalizationManager.class);
    private final Map<Long, Map<String, OSGIResourceBundleFactory>> configMap = new HashMap<Long, Map<String, OSGIResourceBundleFactory>>();
    private ExecutorService executorService;
    private volatile Future<Map<String, OSGIResourceBundle>> cache;

    static Logger getLog() {
        return log;
    }

    static void setLog(Logger log) {
        LocalizationManager.log = log;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(Bundle bundle) throws IOException {
        boolean rebuildCache;
        Map<Long, Map<String, OSGIResourceBundleFactory>> map = this.configMap;
        synchronized (map) {
            rebuildCache = this.configMap.remove(bundle.getBundleId()) != null;
        }
        if (bundle.getState() == 32) {
            HashMap<String, OSGIResourceBundleFactory> configEntry = new HashMap<String, OSGIResourceBundleFactory>();
            Enumeration urlEnumeration = bundle.findEntries("i18n", "*.properties*", true);
            if (urlEnumeration != null) {
                while (urlEnumeration.hasMoreElements()) {
                    String fileName;
                    URL url = (URL)urlEnumeration.nextElement();
                    if (url == null) continue;
                    String relativeName = fileName = url.getFile();
                    String name = this.getPropertyName(fileName);
                    int priority = OSGIResourceNamingConvention.getPropertyPriority(fileName);
                    OSGIResourceBundleFactory bundleFactory = new OSGIResourceBundleFactory(name, relativeName, url, priority);
                    configEntry.put(relativeName, bundleFactory);
                    rebuildCache = true;
                }
            }
            if (!configEntry.isEmpty()) {
                Map<Long, Map<String, OSGIResourceBundleFactory>> map2 = this.configMap;
                synchronized (map2) {
                    this.configMap.put(bundle.getBundleId(), configEntry);
                }
                rebuildCache = true;
            }
        }
        if (rebuildCache) {
            map = this.configMap;
            synchronized (map) {
                if (this.executorService == null) {
                    this.executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

                        @Override
                        public Thread newThread(Runnable r) {
                            Thread thread = Executors.defaultThreadFactory().newThread(r);
                            thread.setDaemon(true);
                            thread.setName("Localization pool");
                            return thread;
                        }
                    });
                }
                this.cache = this.executorService.submit(new OSGIResourceBundleCacheCallable(new HashMap<Long, Map<String, OSGIResourceBundleFactory>>(this.configMap)));
            }
        }
    }

    private String getPropertyName(String fileName) {
        int index = fileName.lastIndexOf("i18n") + "i18n".length();
        return fileName.substring(index + 1, fileName.lastIndexOf(".properties"));
    }

    @Override
    public ResourceBundle getResourceBundle(String name, Locale locale) {
        OSGIResourceBundle result = null;
        Map<String, OSGIResourceBundle> localCache = this.getCache();
        if (localCache != null && name != null) {
            name = name.replaceAll("\\.", "/");
            for (String candidate : OSGIResourceNamingConvention.getCandidateNames(name, locale)) {
                OSGIResourceBundle bundle = localCache.get(candidate);
                if (bundle == null) continue;
                result = bundle;
                break;
            }
        }
        return result;
    }

    @Override
    public List<ResourceBundle> getResourceBundles(Pattern keyRegex, Locale locale) {
        ArrayList<ResourceBundle> result = new ArrayList<ResourceBundle>();
        Map<String, OSGIResourceBundle> localCache = this.getCache();
        if (localCache != null) {
            HashSet<String> defaultNames = new HashSet<String>();
            HashMap<String, OSGIResourceBundle> matchingMap = new HashMap<String, OSGIResourceBundle>();
            for (Map.Entry<String, OSGIResourceBundle> factoryEntry : localCache.entrySet()) {
                OSGIResourceBundle factoryEntryValue = factoryEntry.getValue();
                String defaultName = factoryEntryValue.getDefaultName();
                if (!keyRegex.matcher(defaultName).matches()) continue;
                defaultNames.add(defaultName);
                matchingMap.put(factoryEntry.getKey(), factoryEntryValue);
            }
            for (String defaultName : defaultNames) {
                for (String candidate : OSGIResourceNamingConvention.getCandidateNames(defaultName, locale)) {
                    OSGIResourceBundle bundle = localCache.get(candidate);
                    if (bundle == null) continue;
                    result.add(bundle);
                }
            }
        } else {
            result = null;
        }
        return result;
    }

    private Map<String, OSGIResourceBundle> getCache() {
        Map<String, OSGIResourceBundle> result = null;
        if (this.cache != null) {
            try {
                result = this.cache.get();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }
}

