/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.karaf.kar.KarService;
import org.osgi.framework.BundleContext;
import org.pentaho.di.core.Const;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverManager {
    private static DriverManager driverManagerInstance;
    private BundleContext bundleContext;
    private static Logger logger;
    public static final String CONFIG_FILE_NAME = "org.pentaho.features";
    public static final String INSTALL_DRIVERS_PROPERTY = "installDrivers";
    private static final String DRIVER_FILE_EXTENSION = ".kar";

    private DriverManager() {
    }

    public static DriverManager getInstance(BundleContext bundleContext) {
        if (driverManagerInstance == null) {
            driverManagerInstance = new DriverManager();
        }
        driverManagerInstance.setBundleContext(bundleContext);
        return driverManagerInstance;
    }

    private void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installDrivers() {
        logger.info("Installing driver kars.");
        try (Stream<Path> karFileList = null;){
            String karSourceDirName = Const.getShimDriverDeploymentLocation();
            File karSourceDir = new File(karSourceDirName);
            if (!karSourceDir.exists()) {
                String logMessage = String.format("Drivers installation directory not found: %s", karSourceDirName);
                logger.info(logMessage);
                return;
            }
            KarService karService = (KarService)this.bundleContext.getService(this.bundleContext.getServiceReference("org.apache.karaf.kar.KarService"));
            karFileList = Files.list(karSourceDir.toPath());
            List karsInDir = karFileList.filter(path -> path.toString().endsWith(DRIVER_FILE_EXTENSION)).map(path -> path.getFileName().toString().substring(0, path.getFileName().toString().length() - 4)).collect(Collectors.toList());
            ArrayList karsToInstall = new ArrayList(karsInDir);
            karsToInstall.removeAll(karService.list());
            String driverInstallCountMsg = String.format("%d drivers will be installed.", karsToInstall.size());
            logger.info(driverInstallCountMsg);
            karsToInstall.stream().forEach(karname -> {
                try {
                    logger.info(String.format("Installing %s", karname));
                    Path karPath = Paths.get(karSourceDir.getAbsolutePath(), karname + DRIVER_FILE_EXTENSION);
                    karService.install(karPath.toUri());
                    logger.info(String.format("%s Kar installed.", karname));
                }
                catch (Exception e) {
                    logger.error("Failed installing driver: " + karname + DRIVER_FILE_EXTENSION, (Throwable)e);
                }
            });
        }
        logger.info("Finished installing drivers kars.");
    }

    static {
        logger = LoggerFactory.getLogger(DriverManager.class);
    }
}

