/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.karaf.bundle.core.BundleService;
import org.apache.karaf.bundle.core.BundleState;
import org.apache.karaf.bundle.core.BundleStateService;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Dependency;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.pentaho.capabilities.api.ICapability;
import org.pentaho.capabilities.impl.DefaultCapabilityManager;
import org.pentaho.hadoop.shim.DriverManager;
import org.pentaho.osgi.api.IKarafFeatureWatcher;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.servicecoordination.api.IServiceBarrier;
import org.pentaho.platform.servicecoordination.api.IServiceBarrierManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafFeatureWatcherImpl
implements IKarafFeatureWatcher {
    private BundleContext bundleContext;
    private long timeout;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String KARAF_TIMEOUT_PROPERTY = "karafWaitForBoot";
    private FeaturesService featuresService;
    private ConfigurationAdmin configurationAdmin;

    public KarafFeatureWatcherImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.timeout = PentahoSystem.getApplicationContext().getProperty(KARAF_TIMEOUT_PROPERTY) == null ? 120000L : Long.valueOf(PentahoSystem.getApplicationContext().getProperty(KARAF_TIMEOUT_PROPERTY));
    }

    public void waitForFeatures() throws IKarafFeatureWatcher.FeatureWatcherException {
        try {
            List<String> bootFeatures = this.getFeatures("org.apache.karaf.features", "featuresBoot");
            this.waitForFeatures(bootFeatures);
            List<String> runtimeFeatures = this.getFeatures("org.pentaho.features", "runtimeFeatures");
            DefaultCapabilityManager manager = DefaultCapabilityManager.getInstance();
            if (manager != null) {
                for (String runtimeFeature : runtimeFeatures) {
                    ICapability capability = manager.getCapabilityById(runtimeFeature);
                    if (capability == null || capability.isInstalled()) continue;
                    capability.install();
                }
            }
            this.waitForFeatures(runtimeFeatures);
            if (this.getBooleanProperty("org.pentaho.features", "installDrivers")) {
                DriverManager.getInstance(this.bundleContext).installDrivers();
            }
        }
        catch (IOException e) {
            throw new IKarafFeatureWatcher.FeatureWatcherException("Error accessing ConfigurationAdmin", (Throwable)e);
        }
        catch (Exception e) {
            throw new IKarafFeatureWatcher.FeatureWatcherException("Unknown error in KarafWatcher", (Throwable)e);
        }
    }

    private void waitForFeatures(List<String> requiredFeatures) throws Exception {
        FeaturesService featuresService = this.getFeatureService();
        if (featuresService == null) {
            this.logger.warn("Unable to get FeatureService to start waiting for features.");
            return;
        }
        long entryTime = System.currentTimeMillis();
        while (true) {
            ArrayList<String> uninstalledFeatures = new ArrayList<String>();
            for (String requiredFeature : requiredFeatures) {
                Feature feature = featuresService.getFeature(requiredFeature = requiredFeature.trim());
                if (feature == null || featuresService.isInstalled(feature)) continue;
                uninstalledFeatures.add(requiredFeature);
            }
            if (uninstalledFeatures.size() <= 0) break;
            if (System.currentTimeMillis() - this.timeout > entryTime) {
                IServiceBarrier serviceBarrier = IServiceBarrierManager.LOCATOR.getManager().getServiceBarrier("KarafFeatureWatcherBarrier");
                if (serviceBarrier == null || serviceBarrier.isAvailable()) {
                    this.logger.debug(this.getFeaturesReport(featuresService, uninstalledFeatures));
                    throw new IKarafFeatureWatcher.FeatureWatcherException("Timed out waiting for Karaf features to install: " + StringUtils.join(uninstalledFeatures, (String)","));
                }
                entryTime = System.currentTimeMillis();
            }
            this.logger.debug("KarafFeatureWatcher is waiting for the following features to install: " + StringUtils.join(uninstalledFeatures, (String)","));
            Thread.sleep(100L);
        }
    }

    private FeaturesService getFeatureService() {
        if (this.featuresService == null) {
            serviceTracker.open();
            try (ServiceTracker serviceTracker = new ServiceTracker(this.bundleContext, FeaturesService.class.getName(), null);){
                serviceTracker.waitForService(this.timeout);
            }
            ServiceReference featureServiceReference = this.bundleContext.getServiceReference(FeaturesService.class);
            if (featureServiceReference != null) {
                this.featuresService = (FeaturesService)this.bundleContext.getService(featureServiceReference);
            }
        }
        return this.featuresService;
    }

    private ConfigurationAdmin getConfigurationAdmin() {
        if (this.configurationAdmin == null) {
            ServiceReference configurationAdminServiceReference = this.bundleContext.getServiceReference(ConfigurationAdmin.class);
            this.configurationAdmin = (ConfigurationAdmin)this.bundleContext.getService(configurationAdminServiceReference);
        }
        return this.configurationAdmin;
    }

    private boolean getBooleanProperty(String configPersistentId, String featuresPropertyKey) throws IOException {
        Configuration configuration = this.getConfigurationAdmin().getConfiguration(configPersistentId);
        Dictionary properties = configuration.getProperties();
        if (properties == null) {
            return false;
        }
        String featuresPropertyValue = (String)properties.get(featuresPropertyKey);
        if (featuresPropertyValue == null) {
            return false;
        }
        return Boolean.parseBoolean(featuresPropertyValue);
    }

    protected List<String> getFeatures(String configPersistentId, String featuresPropertyKey) throws IOException {
        Configuration configuration = this.getConfigurationAdmin().getConfiguration(configPersistentId);
        Dictionary properties = configuration.getProperties();
        if (properties == null) {
            return Collections.emptyList();
        }
        String featuresPropertyValue = (String)properties.get(featuresPropertyKey);
        if (featuresPropertyValue == null) {
            return Collections.emptyList();
        }
        if ((featuresPropertyValue = featuresPropertyValue.replaceAll("[()]", "")).length() == 0) {
            return Collections.emptyList();
        }
        String[] featuresArray = featuresPropertyValue.split(",");
        return Arrays.asList(featuresArray);
    }

    private String getFeaturesReport(FeaturesService featuresService, List<String> uninstalledFeatures) throws Exception {
        ServiceReference serviceReferenceBundleService = this.bundleContext.getServiceReference(BundleService.class);
        BundleService bundleService = (BundleService)this.bundleContext.getService(serviceReferenceBundleService);
        List<BundleStateService> bundleStateServices = this.getBundleStateServices();
        String featuresReport = System.lineSeparator() + "--------- Karaf Feature Watcher Report Begin ---------";
        for (String uninstalledFeature : uninstalledFeatures) {
            Feature feature = featuresService.getFeature(uninstalledFeature);
            featuresReport = featuresReport + System.lineSeparator() + this.getFeatureReport(featuresService, bundleService, bundleStateServices, feature);
        }
        return featuresReport + System.lineSeparator() + "--------- Karaf Feature Watcher Report End ---------";
    }

    private String getFeatureReport(FeaturesService featuresService, BundleService bundleService, List<BundleStateService> bundleStateServices, Feature feature) throws Exception {
        boolean first;
        String featureReport = "";
        featureReport = feature.hasVersion() ? featureReport + "Feature '" + feature.getName() + "' with version " + feature.getVersion() + " did not install." : featureReport + "Feature '" + feature.getName() + "' did not install.";
        if (feature.getBundles() != null) {
            first = true;
            for (BundleInfo bundleInfo : feature.getBundles()) {
                Bundle bundle = this.bundleContext.getBundle(bundleInfo.getLocation());
                if (bundleService.getInfo(bundle).getState() == BundleState.Active) continue;
                if (first) {
                    featureReport = featureReport + System.lineSeparator() + "The following bundle(s) are not active and they are contained in feature '" + feature.getName() + "'";
                    first = false;
                }
                featureReport = featureReport + System.lineSeparator() + "\t" + this.getBundleReport(bundleService, bundleStateServices, bundle).replaceAll("\n", "\n\t");
            }
        }
        if (feature.getDependencies() != null) {
            first = true;
            for (Dependency dependency : feature.getDependencies()) {
                String dependencyName = dependency.getName();
                String dependencyVersion = dependency.getVersion();
                Feature dependencyFeature = dependencyVersion != null && !dependencyVersion.isEmpty() ? featuresService.getFeature(dependencyName, dependencyVersion) : featuresService.getFeature(dependencyName);
                if (dependencyFeature != null && !featuresService.isInstalled(dependencyFeature)) {
                    if (first) {
                        featureReport = featureReport + System.lineSeparator() + "The following feature(s) are not active and they are contained in feature '" + feature.getName() + "'";
                        first = false;
                    }
                    featureReport = featureReport + System.lineSeparator() + "\t" + this.getFeatureReport(featuresService, bundleService, bundleStateServices, dependencyFeature).replaceAll("\n", "\n\t");
                }
                first = false;
            }
        }
        return featureReport;
    }

    private List<BundleStateService> getBundleStateServices() throws InvalidSyntaxException {
        ArrayList<BundleStateService> bundleStateServices = new ArrayList<BundleStateService>();
        Collection serviceReferenceBundleStateService = this.bundleContext.getServiceReferences(BundleStateService.class, null);
        for (ServiceReference bundleStateService : serviceReferenceBundleStateService) {
            bundleStateServices.add((BundleStateService)this.bundleContext.getService(bundleStateService));
        }
        return bundleStateServices;
    }

    private String getBundleReport(BundleService bundleService, List<BundleStateService> bundleStateServices, Bundle bundle) {
        BundleState bundleState = bundleService.getInfo(bundle).getState();
        long bundleId = bundle.getBundleId();
        String bundleName = bundle.getSymbolicName();
        String bundleReport = "Bundle '" + bundleName + "':" + System.lineSeparator() + "\t Bundle State: " + bundleState + System.lineSeparator() + "\t Bundle ID: " + bundleId;
        for (BundleStateService bundleStateService : bundleStateServices) {
            String part = bundleStateService.getDiag(bundle);
            if (part == null) continue;
            bundleReport = bundleReport + bundleStateService.getName() + "\n";
            bundleReport = bundleReport + part.replaceAll("\n", "\n\t");
        }
        List missingDependencies = bundleService.getUnsatisfiedRequirements(bundle, null);
        if (missingDependencies != null && !missingDependencies.isEmpty()) {
            bundleReport = bundleReport + System.lineSeparator() + "\t Unsatisfied Requirements:";
            for (BundleRequirement missDependency : missingDependencies) {
                bundleReport = bundleReport + System.lineSeparator() + "\t\t" + missDependency;
            }
        }
        return bundleReport;
    }
}

