/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.blueprint.collection.utils;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class RankedList<T> {
    public static final String SERVICE_RANKING = "service.ranking";
    private final Comparator<T> comparator;
    private final Set<RankedItem> set;
    private List<T> list;

    public RankedList(Comparator<T> comparator) {
        this.comparator = comparator;
        this.set = new TreeSet<RankedItem>();
        this.list = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemAdded(T item, Map config) {
        if (item == null) {
            return;
        }
        Integer ranking = null;
        if (config != null) {
            ranking = (Integer)config.get(SERVICE_RANKING);
        }
        if (ranking == null) {
            ranking = 0;
        }
        if (!(ranking instanceof Number)) {
            ranking = Integer.parseInt(((Object)ranking).toString());
        }
        Set<RankedItem> set = this.set;
        synchronized (set) {
            this.set.add(new RankedItem(((Number)ranking).intValue(), item));
            this.list = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemRemoved(T item) {
        if (item == null) {
            return;
        }
        Set<RankedItem> set = this.set;
        synchronized (set) {
            this.set.removeAll(this.set.stream().filter(rankedItem -> rankedItem.item.equals(item)).collect(Collectors.toList()));
            this.list = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<T> getList() {
        Set<RankedItem> set = this.set;
        synchronized (set) {
            if (this.list == null) {
                this.list = Collections.unmodifiableList(this.set.stream().map(RankedItem::getItem).collect(Collectors.toList()));
            }
            return this.list;
        }
    }

    @VisibleForTesting
    String getToString(int rank, T item) {
        return new RankedItem(rank, item).toString();
    }

    private class RankedItem
    implements Comparable<RankedItem> {
        final int rank;
        final T item;

        RankedItem(int rank, T item) {
            this.rank = rank;
            this.item = item;
        }

        int getRank() {
            return this.rank;
        }

        T getItem() {
            return this.item;
        }

        public String toString() {
            return "(" + this.rank + ") " + this.item;
        }

        @Override
        public int compareTo(RankedItem o) {
            return Comparator.comparingInt(RankedItem::getRank).reversed().thenComparing(RankedItem::getItem, RankedList.this.comparator).compare(this, o);
        }
    }
}

