/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.api.cluster.service.locator.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.pentaho.big.data.api.shims.LegacyShimLocator;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterServiceFactory;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterServiceLocator;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedClusterServiceLocatorImpl
implements NamedClusterServiceLocator {
    @VisibleForTesting
    final Map<String, Map<Class<?>, List<NamedClusterServiceFactory<?>>>> serviceVendorTypeMapping;
    private final ReadWriteLock readWriteLock;
    @VisibleForTesting
    final String internalShim;
    private final MetastoreLocator metastoreLocator;
    private final NamedClusterService namedClusterManager;
    private static final Logger logger = LoggerFactory.getLogger(NamedClusterServiceLocatorImpl.class);

    public NamedClusterServiceLocatorImpl(String internalShim, MetastoreLocator metastoreLocator, NamedClusterService namedClusterManager) {
        this.internalShim = Objects.requireNonNull(internalShim, "Set internal.shim in karaf/etc/pentaho.shim.cfg");
        this.metastoreLocator = metastoreLocator;
        this.namedClusterManager = namedClusterManager;
        this.readWriteLock = new ReentrantReadWriteLock();
        this.serviceVendorTypeMapping = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void factoryAdded(NamedClusterServiceFactory<?> namedClusterServiceFactory, Map properties) {
        String shim = (String)properties.get("shim");
        if (namedClusterServiceFactory == null || namedClusterServiceFactory.getServiceClass() == null || shim == null) {
            logger.debug("Undefined NamedClusterServiceFactory added.");
            return;
        }
        Lock writeLock = this.readWriteLock.writeLock();
        try {
            writeLock.lock();
            this.serviceVendorTypeMapping.putIfAbsent(shim, new HashMap());
            Map<Class<?>, List<NamedClusterServiceFactory<?>>> classServiceMap = this.serviceVendorTypeMapping.get(shim);
            Class serviceClass = namedClusterServiceFactory.getServiceClass();
            classServiceMap.putIfAbsent(serviceClass, new ArrayList());
            Objects.requireNonNull(classServiceMap).get(serviceClass).add(namedClusterServiceFactory);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void factoryRemoved(NamedClusterServiceFactory<?> namedClusterServiceFactory, Map properties) {
        if (namedClusterServiceFactory == null) {
            logger.debug("Undefined NamedClusterServiceFactory removed.");
            return;
        }
        Class serviceClass = namedClusterServiceFactory.getServiceClass();
        Lock writeLock = this.readWriteLock.writeLock();
        try {
            writeLock.lock();
            String shim = (String)properties.get("shim");
            Optional.ofNullable(this.serviceVendorTypeMapping.get(shim)).ifPresent(serviceFactories -> {
                List cfr_ignored_0 = (List)serviceFactories.remove(serviceClass);
            });
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getService(NamedCluster namedCluster, Class<T> serviceClass) {
        block5: {
            Lock readLock = this.readWriteLock.readLock();
            try {
                List<NamedClusterServiceFactory<?>> serviceFactoryList;
                readLock.lock();
                String shim = Objects.requireNonNull(this.getShimForService(namedCluster));
                logger.debug("NamedClusterServiceLocator.getService({}, {})", (Object)namedCluster, serviceClass);
                Map<Class<?>, List<NamedClusterServiceFactory<?>>> serviceMap = this.serviceVendorTypeMapping.get(shim);
                if (serviceMap == null || (serviceFactoryList = serviceMap.get(serviceClass)) == null) break block5;
                for (NamedClusterServiceFactory<?> serviceFactory : serviceFactoryList) {
                    if (!serviceFactory.canHandle(namedCluster)) continue;
                    T t = serviceClass.cast(serviceFactory.create(namedCluster));
                    return t;
                }
            }
            finally {
                readLock.unlock();
            }
        }
        logger.error("Could not find service for {} associated with named cluster {}", serviceClass, (Object)namedCluster);
        return null;
    }

    private String getShimForService(NamedCluster namedCluster) {
        if (namedCluster == null) {
            return this.internalShim;
        }
        String shim = namedCluster.getShimIdentifier();
        NamedCluster storedNamedCluster = this.namedClusterManager.getNamedClusterByName(namedCluster.getName(), this.metastoreLocator.getMetastore());
        if (shim == null && storedNamedCluster != null) {
            shim = storedNamedCluster.getShimIdentifier();
        }
        if (shim == null) {
            try {
                shim = LegacyShimLocator.getLegacyDefaultShimName();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (shim == null) {
            shim = this.internalShim;
        }
        return shim;
    }

    public List<String> getVendorShimList() {
        return new ArrayList<String>(this.serviceVendorTypeMapping.keySet());
    }
}

