/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.api.jdbc.impl;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.pentaho.big.data.api.jdbc.impl.HasDeregisterDriver;
import org.pentaho.big.data.api.jdbc.impl.HasRegisterDriver;
import org.pentaho.hadoop.shim.api.jdbc.DriverLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverLocatorImpl
implements DriverLocator {
    private static final Logger logger = LoggerFactory.getLogger(DriverLocatorImpl.class);
    public static final String DATA_SOURCE_TYPE_BIGDATA = "(dataSourceType=bigdata)";
    private final BundleContext bundleContext;
    private final HasRegisterDriver hasRegisterDriver;
    private final HasDeregisterDriver hasDeregisterDriver;
    private final Map<ServiceReference<Driver>, List<Driver>> registeredDrivers;

    public DriverLocatorImpl(BundleContext bundleContext) {
        this(bundleContext, DriverManager::registerDriver, DriverManager::deregisterDriver, new HashMap<ServiceReference<Driver>, List<Driver>>());
    }

    public DriverLocatorImpl(BundleContext bundleContext, HasRegisterDriver hasRegisterDriver, HasDeregisterDriver hasDeregisterDriver, Map<ServiceReference<Driver>, List<Driver>> registeredDrivers) {
        this.bundleContext = bundleContext;
        this.hasRegisterDriver = hasRegisterDriver;
        this.hasDeregisterDriver = hasDeregisterDriver;
        this.registeredDrivers = registeredDrivers;
        this.bundleContext.addServiceListener(event -> {
            List drivers;
            ServiceReference serviceReference = event.getServiceReference();
            if (serviceReference != null && (drivers = (List)registeredDrivers.remove(serviceReference)) != null) {
                for (Driver driver : drivers) {
                    try {
                        hasDeregisterDriver.deregisterDriver(driver);
                    }
                    catch (SQLException e) {
                        logger.error("Unable to deregister driver " + driver, (Throwable)e);
                    }
                }
            }
        });
    }

    public Iterator<Map.Entry<ServiceReference<Driver>, Driver>> getDrivers() {
        try {
            return this.bundleContext.getServiceReferences(Driver.class, DATA_SOURCE_TYPE_BIGDATA).stream().map(driverServiceReference -> new Map.Entry<ServiceReference<Driver>, Driver>(){

                @Override
                public ServiceReference<Driver> getKey() {
                    return driverServiceReference;
                }

                @Override
                public Driver getValue() {
                    return (Driver)DriverLocatorImpl.this.bundleContext.getService(driverServiceReference);
                }

                @Override
                public Driver setValue(Driver value) {
                    throw new UnsupportedOperationException();
                }
            }).iterator();
        }
        catch (InvalidSyntaxException e) {
            logger.error(e.getFilter(), (Throwable)e);
            return Collections.emptyList().iterator();
        }
    }

    public Driver getDriver(String url) {
        Iterator<Map.Entry<ServiceReference<Driver>, Driver>> drivers = this.getDrivers();
        while (drivers.hasNext()) {
            Driver driver = drivers.next().getValue();
            try {
                if (!driver.acceptsURL(url)) continue;
                return driver;
            }
            catch (SQLException e) {
                logger.error(String.format("Unable to see if driver %s acceptsURL %s", driver, url));
            }
        }
        return null;
    }

    public synchronized void registerDriverServiceReferencePair(ServiceReference<Driver> serviceReference, Driver driver, boolean shouldRegisterExternally) {
        try {
            if (shouldRegisterExternally) {
                this.hasRegisterDriver.registerDriver(driver);
            }
            this.registeredDrivers.compute(serviceReference, (serviceReference1, drivers) -> {
                if (drivers == null) {
                    return Collections.singletonList(driver);
                }
                ArrayList<Driver> result = new ArrayList<Driver>((Collection<Driver>)drivers);
                result.add(driver);
                return Collections.unmodifiableList(result);
            });
        }
        catch (SQLException e) {
            logger.error("Unable to register driver " + driver, (Throwable)e);
        }
    }
}

