/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.api.jdbc.impl;

import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.hadoop.shim.api.jdbc.JdbcUrl;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;

public class JdbcUrlImpl
implements JdbcUrl {
    public static final String PENTAHO_NAMED_CLUSTER = "pentahoNamedCluster";
    private String scheme;
    private String host;
    private String port;
    private String path;
    private final Map<String, String> queryParams;
    private final NamedClusterService namedClusterService;
    private final MetastoreLocator metastoreLocator;
    private Pattern uriPattern = Pattern.compile("^(.*)://([^:]*):?(\\d*)?/(.*)$");

    public JdbcUrlImpl(String url, NamedClusterService namedClusterService, MetastoreLocator metastoreLocator) throws URISyntaxException {
        this.namedClusterService = namedClusterService;
        this.metastoreLocator = metastoreLocator;
        if (!url.startsWith("jdbc:")) {
            throw new URISyntaxException(url, "Should start with \"jdbc:\"");
        }
        Matcher m = this.uriPattern.matcher(url.substring(5));
        if (m.matches()) {
            int beginIndex;
            this.scheme = m.group(1);
            this.host = m.group(2);
            this.port = m.group(3);
            this.path = m.group(4);
            String query = null;
            if (this.path != null && (beginIndex = this.path.indexOf(59)) >= 0) {
                query = this.path.substring(beginIndex);
            }
            this.queryParams = query == null ? new HashMap<String, String>() : this.queryStringToParamMap(query);
        } else {
            throw new URISyntaxException(url, "Could not parse URL");
        }
    }

    private Map<String, String> queryStringToParamMap(String query) {
        return Arrays.asList(query.split(";")).stream().map(s -> {
            int i = s.indexOf(61);
            if (i < 0 || i >= s.length() - 1) {
                return null;
            }
            return new String[]{s.substring(0, i), s.substring(i + 1)};
        }).filter(Objects::nonNull).collect(Collectors.toMap(r -> r[0], t -> t[1]));
    }

    public String toString() {
        String queryParameters = this.queryParams.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).filter(Objects::nonNull).sorted(String::compareToIgnoreCase).collect(Collectors.joining(";"));
        String tempPath = this.path;
        int semicolon = tempPath.indexOf(59);
        if (semicolon >= 0) {
            tempPath = tempPath.substring(0, semicolon);
        }
        return "jdbc:" + this.scheme + "://" + this.host + (this.port == null || this.port.equals("") ? "" : ":" + this.port) + "/" + tempPath + (queryParameters != null && queryParameters.length() > 0 ? ";" + queryParameters : "");
    }

    public void setQueryParam(String key, String value) {
        this.queryParams.put(key, value);
    }

    public String getQueryParam(String key) {
        return this.queryParams.get(key);
    }

    public NamedCluster getNamedCluster() throws MetaStoreException {
        IMetaStore metaStore = this.metastoreLocator.getMetastore();
        if (metaStore == null) {
            return null;
        }
        String queryParam = this.getQueryParam(PENTAHO_NAMED_CLUSTER);
        if (queryParam == null) {
            return null;
        }
        return this.namedClusterService.read(queryParam, metaStore);
    }

    public String getHost() {
        return this.host;
    }
}

