/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.api.jdbc.impl;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import org.osgi.framework.ServiceReference;
import org.pentaho.big.data.api.jdbc.impl.DriverLocatorImpl;
import org.pentaho.big.data.api.jdbc.impl.HasDeregisterDriver;
import org.pentaho.big.data.api.jdbc.impl.HasRegisterDriver;
import org.pentaho.di.core.database.DelegatingDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyDelegatingDriver
implements Driver {
    private final DriverLocatorImpl driverLocator;
    private final HasRegisterDriver hasRegisterDriver;
    private final HasDeregisterDriver hasDeregisterDriver;
    private Driver delegate;
    DelegatingDriver delegatingDriver;
    LazyDelegatingDriver lazyDelegatingDriver;
    protected static Logger logger = LoggerFactory.getLogger(LazyDelegatingDriver.class);

    public LazyDelegatingDriver(DriverLocatorImpl driverLocator) throws SQLException {
        this(driverLocator, DriverManager::registerDriver, DriverManager::deregisterDriver);
    }

    public LazyDelegatingDriver(DriverLocatorImpl driverLocator, HasRegisterDriver hasRegisterDriver, HasDeregisterDriver hasDeregisterDriver) throws SQLException {
        this.driverLocator = driverLocator;
        this.hasRegisterDriver = hasRegisterDriver;
        this.hasDeregisterDriver = hasDeregisterDriver;
        this.delegatingDriver = new DelegatingDriver((Driver)this);
        hasRegisterDriver.registerDriver((Driver)this.delegatingDriver);
    }

    public void destroy() {
        try {
            if (this.delegatingDriver != null) {
                this.hasDeregisterDriver.deregisterDriver((Driver)this.delegatingDriver);
            }
        }
        catch (SQLException e) {
            logger.warn("Failed to deregister " + LazyDelegatingDriver.class.getName(), (Throwable)e);
        }
        finally {
            this.delegatingDriver = null;
        }
        if (this.lazyDelegatingDriver != null) {
            this.lazyDelegatingDriver.destroy();
            this.lazyDelegatingDriver = null;
        }
    }

    private synchronized <T> T findAndProcess(FunctionWithSQLException<Driver, T> attempt, Predicate<T> success, T defaultVal) throws SQLException {
        if (this.delegate == null) {
            Iterator<Map.Entry<ServiceReference<Driver>, Driver>> drivers = this.driverLocator.getDrivers();
            while (drivers.hasNext()) {
                Map.Entry<ServiceReference<Driver>, Driver> driverEntry = drivers.next();
                ServiceReference<Driver> serviceReference = driverEntry.getKey();
                Driver driver = driverEntry.getValue();
                T result = attempt.apply(driver);
                if (!success.test(result)) continue;
                this.delegate = driver;
                this.lazyDelegatingDriver = new LazyDelegatingDriver(this.driverLocator, this.hasRegisterDriver, this.hasDeregisterDriver);
                this.driverLocator.registerDriverServiceReferencePair(serviceReference, (Driver)this.delegatingDriver, false);
                return result;
            }
        } else {
            T result = attempt.apply(this.delegate);
            if (success.test(result)) {
                return result;
            }
        }
        return defaultVal;
    }

    private synchronized <T> T process(Function<Driver, T> function, T defaultVal) {
        if (this.delegate == null) {
            return defaultVal;
        }
        return function.apply(this.delegate);
    }

    private synchronized <T> T processSQLException(FunctionWithSQLException<Driver, T> function, T defaultVal) throws SQLException {
        if (this.delegate == null) {
            return defaultVal;
        }
        return function.apply(this.delegate);
    }

    private synchronized <T> T processSQLFeatureNotSupportedException(FunctionWithSQLFeatureNotSupportedException<Driver, T> function, T defaultVal) throws SQLFeatureNotSupportedException {
        if (this.delegate == null) {
            return defaultVal;
        }
        return function.apply(this.delegate);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.findAndProcess(driver -> driver.connect(url, info), Objects::nonNull, null);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.findAndProcess(driver -> driver.acceptsURL(url), bool -> bool, false);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.processSQLException(driver -> driver.getPropertyInfo(url, info), new DriverPropertyInfo[0]);
    }

    @Override
    public int getMajorVersion() {
        return this.process(driver -> driver.getMajorVersion(), 0);
    }

    @Override
    public int getMinorVersion() {
        return this.process(driver -> driver.getMinorVersion(), 0);
    }

    @Override
    public boolean jdbcCompliant() {
        return this.process(driver -> driver.jdbcCompliant(), false);
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.processSQLFeatureNotSupportedException(driver -> driver.getParentLogger(), null);
    }

    private static interface FunctionWithSQLFeatureNotSupportedException<T, R> {
        public R apply(T var1) throws SQLFeatureNotSupportedException;
    }

    private static interface FunctionWithSQLException<T, R> {
        public R apply(T var1) throws SQLException;
    }
}

