/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.api.shims;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.plugins.LifecyclePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.hadoop.shim.api.ShimIdentifierInterface;

public class LegacyShimLocator {
    private static final String ACTIVE_HADOOP_CONFIGURATION = "active.hadoop.configuration";
    private static final String HADOOP_CONFIGURATIONS_PATH = "hadoop.configurations.path";
    private static final String BIG_DATA_PLUGIN_PROPERTIES = "plugin.properties";
    public static final String HADOOP_SPOON_PLUGIN = "HadoopSpoonPlugin";
    private List<ShimIdentifierInterface> registeredShims;
    private static LegacyShimLocator instance;

    public LegacyShimLocator(List<ShimIdentifierInterface> shims) {
        LegacyShimLocator.getInstance().registeredShims = shims;
    }

    private LegacyShimLocator() {
    }

    public static LegacyShimLocator getInstance() {
        if (instance == null) {
            instance = new LegacyShimLocator();
        }
        return instance;
    }

    public List<ShimIdentifierInterface> getRegisteredShims() {
        return this.registeredShims;
    }

    public static String getLegacyDefaultShimName() throws IOException {
        PluginInterface pluginInterface = PluginRegistry.getInstance().findPluginWithId(LifecyclePluginType.class, HADOOP_SPOON_PLUGIN);
        try {
            Properties legacyProperties = LegacyShimLocator.loadProperties(pluginInterface, BIG_DATA_PLUGIN_PROPERTIES);
            return legacyProperties.getProperty(ACTIVE_HADOOP_CONFIGURATION);
        }
        catch (NullPointerException | KettleFileException e) {
            throw new IOException(e);
        }
    }

    public static String getLegacyDefaultShimDir(String shimFolder) throws IOException {
        PluginInterface pluginInterface = PluginRegistry.getInstance().findPluginWithId(LifecyclePluginType.class, HADOOP_SPOON_PLUGIN);
        try {
            Properties legacyProperties = LegacyShimLocator.loadProperties(pluginInterface, BIG_DATA_PLUGIN_PROPERTIES);
            String legacyShimsFolder = legacyProperties.getProperty(HADOOP_CONFIGURATIONS_PATH);
            FileObject shimDirectoryObject = KettleVFS.getFileObject((String)(pluginInterface.getPluginDirectory().getPath() + Const.FILE_SEPARATOR + legacyShimsFolder + Const.FILE_SEPARATOR + shimFolder));
            return shimDirectoryObject.getURL().getPath();
        }
        catch (NullPointerException | KettleFileException e) {
            throw new IOException(e);
        }
    }

    public static Properties getLegacyBigDataProps() {
        PluginInterface pluginInterface = PluginRegistry.getInstance().findPluginWithId(LifecyclePluginType.class, HADOOP_SPOON_PLUGIN);
        try {
            return LegacyShimLocator.loadProperties(pluginInterface, BIG_DATA_PLUGIN_PROPERTIES);
        }
        catch (IOException | KettleFileException e) {
            return new Properties();
        }
    }

    private static Properties loadProperties(PluginInterface plugin, String relativeName) throws KettleFileException, IOException {
        if (plugin == null) {
            throw new NullPointerException();
        }
        FileObject propFile = KettleVFS.getFileObject((String)(plugin.getPluginDirectory().getPath() + Const.FILE_SEPARATOR + relativeName));
        if (!propFile.exists()) {
            throw new FileNotFoundException(propFile.toString());
        }
        try {
            Properties pluginProperties = new Properties();
            pluginProperties.load(new FileInputStream(propFile.getName().getPath()));
            return pluginProperties;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

