/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.formula.DefaultLocalizationContext;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaBoot;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.function.DefaultFunctionRegistry;
import org.pentaho.reporting.libraries.formula.function.FunctionRegistry;
import org.pentaho.reporting.libraries.formula.operators.DefaultOperatorFactory;
import org.pentaho.reporting.libraries.formula.operators.OperatorFactory;
import org.pentaho.reporting.libraries.formula.typing.DefaultTypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.AnyType;

public class DefaultFormulaContext
implements FormulaContext {
    private DefaultTypeRegistry typeRegistry;
    private DefaultFunctionRegistry functionRegistry;
    private DefaultOperatorFactory operatorFactory;
    private DefaultLocalizationContext localizationContext;
    private Configuration config;
    private HashMap references;

    public DefaultFormulaContext() {
        this(LibFormulaBoot.getInstance().getGlobalConfig());
    }

    public DefaultFormulaContext(Configuration config) {
        this(config, null, null);
    }

    public DefaultFormulaContext(Configuration config, Locale locale, TimeZone timeZone) {
        if (config == null) {
            throw new NullPointerException();
        }
        this.config = config;
        this.localizationContext = new DefaultLocalizationContext();
        this.localizationContext.initialize(config, locale, timeZone);
        this.typeRegistry = new DefaultTypeRegistry();
        this.typeRegistry.initialize(this);
        this.functionRegistry = new DefaultFunctionRegistry();
        this.functionRegistry.initialize(config);
        this.operatorFactory = new DefaultOperatorFactory();
        this.operatorFactory.initalize(config);
    }

    @Override
    public OperatorFactory getOperatorFactory() {
        return this.operatorFactory;
    }

    public void defineReference(Object name, Object value) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            if (this.references == null) {
                return;
            }
            this.references.remove(name);
            return;
        }
        if (this.references == null) {
            this.references = new HashMap();
        }
        this.references.put(name, value);
    }

    @Override
    public Object resolveReference(Object name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.references == null) {
            return null;
        }
        return this.references.get(name);
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public FunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    @Override
    public Type resolveReferenceType(Object name) {
        return AnyType.TYPE;
    }

    @Override
    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    @Override
    public LocalizationContext getLocalizationContext() {
        return this.localizationContext;
    }

    @Override
    public boolean isReferenceDirty(Object name) {
        return true;
    }

    @Override
    public Date getCurrentDate() {
        return new Date();
    }
}

