/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.math;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.function.math.SumFunction;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class AverageFunction
implements Function {
    private static final long serialVersionUID = -5057715506050635450L;
    private SumFunction sumFunction;

    public AverageFunction() {
        this(new SumFunction());
    }

    protected AverageFunction(SumFunction sumFunction) {
        this.sumFunction = sumFunction;
    }

    @Override
    public String getCanonicalName() {
        return "AVERAGE";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        TypeValuePair sum = this.sumFunction.evaluate(context, parameters);
        Number n = context.getTypeRegistry().convertToNumber(sum.getType(), sum.getValue());
        if (n == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        BigDecimal divident = NumberUtil.getAsBigDecimal(n);
        BigDecimal divisor = new BigDecimal(parameters.getParameterCount());
        BigDecimal avg = NumberUtil.divide(divident, divisor);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, avg);
    }
}

