/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.cluster;

import com.google.common.annotations.VisibleForTesting;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.provider.url.UrlFileName;
import org.apache.commons.vfs2.provider.url.UrlFileNameParser;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.osgi.api.NamedClusterOsgi;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.security.Base64TwoWayPasswordEncoder;
import org.pentaho.metastore.api.security.ITwoWayPasswordEncoder;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.pentaho.metastore.persist.MetaStoreElementType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@MetaStoreElementType(name="NamedCluster", description="A NamedCluster")
public class NamedClusterImpl
implements NamedCluster,
NamedClusterOsgi {
    public static final String HDFS_SCHEME = "hdfs";
    public static final String MAPRFS_SCHEME = "maprfs";
    public static final String WASB_SCHEME = "wasb";
    public static final String NC_SCHEME = "hc";
    public static final String INDENT = "  ";
    public static final String ROOT_INDENT = "    ";
    private static final Logger LOGGER = LoggerFactory.getLogger(NamedClusterImpl.class);
    private VariableSpace variables = new Variables();
    @MetaStoreAttribute
    private String name;
    @MetaStoreAttribute
    private String shimIdentifier;
    @MetaStoreAttribute
    private String storageScheme;
    @MetaStoreAttribute
    private String hdfsHost;
    @MetaStoreAttribute
    private String hdfsPort;
    @MetaStoreAttribute
    private String hdfsUsername;
    @MetaStoreAttribute(password=true)
    private String hdfsPassword;
    @MetaStoreAttribute
    private String jobTrackerHost;
    @MetaStoreAttribute
    private String jobTrackerPort;
    @MetaStoreAttribute
    private String zooKeeperHost;
    @MetaStoreAttribute
    private String zooKeeperPort;
    @MetaStoreAttribute
    private String oozieUrl;
    @MetaStoreAttribute
    @Deprecated
    private boolean mapr;
    @MetaStoreAttribute
    private String gatewayUrl;
    @MetaStoreAttribute
    private String gatewayUsername;
    @MetaStoreAttribute(password=true)
    private String gatewayPassword;
    @MetaStoreAttribute
    private boolean useGateway;
    @MetaStoreAttribute
    private String kafkaBootstrapServers;
    @MetaStoreAttribute
    private long lastModifiedDate = System.currentTimeMillis();
    private ITwoWayPasswordEncoder passwordEncoder = new Base64TwoWayPasswordEncoder();

    public NamedClusterImpl() {
        this.initializeVariablesFrom(null);
    }

    public NamedClusterImpl(NamedCluster namedCluster) {
        this();
        this.replaceMeta(namedCluster);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getShimIdentifier() {
        return this.shimIdentifier;
    }

    public void setShimIdentifier(String shimIdentifier) {
        this.shimIdentifier = shimIdentifier;
    }

    public String getStorageScheme() {
        if (this.storageScheme == null) {
            this.storageScheme = this.isMapr() ? MAPRFS_SCHEME : HDFS_SCHEME;
        }
        return this.storageScheme;
    }

    public void setStorageScheme(String storageScheme) {
        this.storageScheme = storageScheme;
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String fieldSubstitute(String aString, RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        return this.variables.fieldSubstitute(aString, rowMeta, rowData);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Utils.isEmpty((CharSequence)variableName) && !Utils.isEmpty((CharSequence)(value = this.environmentSubstitute(variableName)))) {
            return ValueMetaBase.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public void replaceMeta(NamedCluster nc) {
        this.setName(nc.getName());
        this.setShimIdentifier(nc.getShimIdentifier());
        this.setStorageScheme(nc.getStorageScheme());
        this.setHdfsHost(nc.getHdfsHost());
        this.setHdfsPort(nc.getHdfsPort());
        this.setHdfsUsername(nc.getHdfsUsername());
        this.setHdfsPassword(nc.getHdfsPassword());
        this.setJobTrackerHost(nc.getJobTrackerHost());
        this.setJobTrackerPort(nc.getJobTrackerPort());
        this.setZooKeeperHost(nc.getZooKeeperHost());
        this.setZooKeeperPort(nc.getZooKeeperPort());
        this.setOozieUrl(nc.getOozieUrl());
        this.setMapr(nc.isMapr());
        this.setGatewayUrl(nc.getGatewayUrl());
        this.setGatewayUsername(nc.getGatewayUsername());
        this.setGatewayPassword(nc.getGatewayPassword());
        this.setUseGateway(nc.isUseGateway());
        this.setKafkaBootstrapServers(nc.getKafkaBootstrapServers());
        this.lastModifiedDate = System.currentTimeMillis();
    }

    public NamedClusterImpl clone() {
        return new NamedClusterImpl(this);
    }

    public String processURLsubstitution(String incomingURL, IMetaStore metastore, VariableSpace variableSpace) {
        if (this.isUseGateway()) {
            if (incomingURL.startsWith(NC_SCHEME)) {
                return incomingURL;
            }
            StringBuilder builder = new StringBuilder("hc://");
            builder.append(this.getName());
            builder.append(incomingURL.startsWith("/") ? incomingURL : "/" + incomingURL);
            return builder.toString();
        }
        if (this.isMapr()) {
            String url = this.processURLsubstitution(incomingURL, MAPRFS_SCHEME, metastore, variableSpace);
            if (url != null && !url.startsWith(MAPRFS_SCHEME)) {
                url = "maprfs://" + url;
            }
            return url;
        }
        return this.processURLsubstitution(incomingURL, this.getStorageScheme(), metastore, variableSpace);
    }

    private String processURLsubstitution(String incomingURL, String hdfsScheme, IMetaStore metastore, VariableSpace variableSpace) {
        String outgoingURL = null;
        String clusterURL = null;
        if (!hdfsScheme.equals(MAPRFS_SCHEME)) {
            clusterURL = this.generateURL(hdfsScheme, metastore, variableSpace);
        }
        try {
            if (clusterURL == null || this.isHdfsHostEmpty(variableSpace)) {
                outgoingURL = incomingURL;
            } else if (incomingURL.equals("/")) {
                outgoingURL = clusterURL;
            } else if (clusterURL != null) {
                String noVariablesURL = incomingURL.replaceAll("[${}]", "/");
                String fullyQualifiedIncomingURL = incomingURL;
                if (!incomingURL.startsWith(hdfsScheme) && !incomingURL.startsWith(NC_SCHEME)) {
                    fullyQualifiedIncomingURL = clusterURL + incomingURL;
                    noVariablesURL = clusterURL + incomingURL.replaceAll("[${}]", "/");
                }
                UrlFileNameParser parser = new UrlFileNameParser();
                FileName fileName = parser.parseUri(null, null, noVariablesURL);
                String root = fileName.getRootURI();
                String path = fullyQualifiedIncomingURL.substring(root.length() - 1);
                StringBuffer buffer = new StringBuffer();
                boolean prependCluster = true;
                if (variableSpace != null) {
                    String filePath = variableSpace.environmentSubstitute(path);
                    StringBuilder pattern = new StringBuilder();
                    pattern.append("^(").append(HDFS_SCHEME).append("|").append(WASB_SCHEME).append("|").append(MAPRFS_SCHEME).append("|").append(NC_SCHEME).append("):\\/\\/");
                    Pattern r = Pattern.compile(pattern.toString());
                    Matcher m = r.matcher(filePath);
                    boolean bl = prependCluster = !m.find();
                }
                if (prependCluster) {
                    buffer.append(clusterURL);
                }
                buffer.append(path);
                outgoingURL = buffer.toString();
            }
        }
        catch (Exception e) {
            outgoingURL = null;
        }
        return outgoingURL;
    }

    @VisibleForTesting
    boolean isHdfsHostEmpty(VariableSpace variableSpace) {
        String hostNameParsed = this.getHostNameParsed(variableSpace);
        return hostNameParsed == null || hostNameParsed.trim().isEmpty();
    }

    public String getHostNameParsed(VariableSpace variableSpace) {
        if (StringUtil.isVariable((String)this.hdfsHost)) {
            if (variableSpace == null) {
                return null;
            }
            return variableSpace.getVariable(StringUtil.getVariableName((String)this.getHdfsHost()));
        }
        return this.hdfsHost != null ? this.hdfsHost.trim() : null;
    }

    @VisibleForTesting
    String generateURL(String scheme, IMetaStore metastore, VariableSpace variableSpace) {
        String clusterURL = null;
        try {
            if (!Utils.isEmpty((CharSequence)scheme)) {
                String ncPassword;
                String ncHostname = this.getHdfsHost() != null ? this.getHdfsHost() : "";
                String ncPort = this.getHdfsPort() != null ? this.getHdfsPort() : "";
                String ncUsername = this.getHdfsUsername() != null ? this.getHdfsUsername() : "";
                String string = ncPassword = this.getHdfsPassword() != null ? this.getHdfsPassword() : "";
                if (variableSpace != null) {
                    variableSpace.initializeVariablesFrom(this.getParentVariableSpace());
                    if (StringUtil.isVariable((String)scheme)) {
                        String string2 = scheme = variableSpace.getVariable(StringUtil.getVariableName((String)scheme)) != null ? variableSpace.environmentSubstitute(scheme) : null;
                    }
                    if (StringUtil.isVariable((String)ncHostname)) {
                        String string3 = ncHostname = variableSpace.getVariable(StringUtil.getVariableName((String)ncHostname)) != null ? variableSpace.environmentSubstitute(ncHostname) : null;
                    }
                    if (StringUtil.isVariable((String)ncPort)) {
                        String string4 = ncPort = variableSpace.getVariable(StringUtil.getVariableName((String)ncPort)) != null ? variableSpace.environmentSubstitute(ncPort) : null;
                    }
                    if (StringUtil.isVariable((String)ncUsername)) {
                        String string5 = ncUsername = variableSpace.getVariable(StringUtil.getVariableName((String)ncUsername)) != null ? variableSpace.environmentSubstitute(ncUsername) : null;
                    }
                    if (StringUtil.isVariable((String)ncPassword)) {
                        ncPassword = variableSpace.getVariable(StringUtil.getVariableName((String)ncPassword)) != null ? variableSpace.environmentSubstitute(ncPassword) : null;
                    }
                }
                String string6 = ncHostname = ncHostname != null ? ncHostname.trim() : "";
                if (ncPort == null) {
                    ncPort = "-1";
                } else if (Utils.isEmpty((CharSequence)(ncPort = ncPort.trim()))) {
                    ncPort = "-1";
                }
                ncUsername = ncUsername != null ? ncUsername.trim() : "";
                ncPassword = ncPassword != null ? ncPassword.trim() : "";
                UrlFileName file = new UrlFileName(scheme, ncHostname, Integer.parseInt(ncPort), -1, ncUsername, ncPassword, null, null, null);
                clusterURL = file.getURI();
                if (clusterURL.endsWith("/")) {
                    clusterURL = clusterURL.substring(0, clusterURL.lastIndexOf("/"));
                }
            }
        }
        catch (Exception e) {
            clusterURL = null;
        }
        return clusterURL;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedCluster other = (NamedCluster)obj;
        return !(this.name == null ? other.getName() != null : !this.name.equals(other.getName()));
    }

    public String getHdfsHost() {
        return this.hdfsHost;
    }

    public void setHdfsHost(String hdfsHost) {
        this.hdfsHost = hdfsHost;
    }

    public String getHdfsPort() {
        return this.hdfsPort;
    }

    public void setHdfsPort(String hdfsPort) {
        this.hdfsPort = hdfsPort;
    }

    public String getHdfsUsername() {
        return this.hdfsUsername;
    }

    public void setHdfsUsername(String hdfsUsername) {
        this.hdfsUsername = hdfsUsername;
    }

    public String getHdfsPassword() {
        return this.hdfsPassword;
    }

    public void setHdfsPassword(String hdfsPassword) {
        this.hdfsPassword = hdfsPassword;
    }

    public String getJobTrackerHost() {
        return this.jobTrackerHost;
    }

    public void setJobTrackerHost(String jobTrackerHost) {
        this.jobTrackerHost = jobTrackerHost;
    }

    public String getJobTrackerPort() {
        return this.jobTrackerPort;
    }

    public void setJobTrackerPort(String jobTrackerPort) {
        this.jobTrackerPort = jobTrackerPort;
    }

    public String getZooKeeperHost() {
        return this.zooKeeperHost;
    }

    public void setZooKeeperHost(String zooKeeperHost) {
        this.zooKeeperHost = zooKeeperHost;
    }

    public String getZooKeeperPort() {
        return this.zooKeeperPort;
    }

    public void setZooKeeperPort(String zooKeeperPort) {
        this.zooKeeperPort = zooKeeperPort;
    }

    public String getOozieUrl() {
        return this.oozieUrl;
    }

    public void setOozieUrl(String oozieUrl) {
        this.oozieUrl = oozieUrl;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setMapr(boolean mapr) {
        if (mapr) {
            this.setStorageScheme(MAPRFS_SCHEME);
        }
    }

    @Deprecated
    public boolean isMapr() {
        if (this.storageScheme == null) {
            return this.mapr;
        }
        return this.storageScheme.equals(MAPRFS_SCHEME);
    }

    public String toString() {
        return "Named cluster: " + this.getName();
    }

    public String toXmlForEmbed(String rootTag) {
        BeanMap m = new BeanMap((Object)this);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builder = dbf.newDocumentBuilder();
            doc = builder.newDocument();
            Element rootNode = doc.createElement(rootTag);
            doc.appendChild(rootNode);
            Iterator i = m.entryIterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                String elementName = (String)entry.getKey();
                if ("class".equals(elementName) || "parentVariableSpace".equals(elementName)) continue;
                String value = "";
                String type = "String";
                Object o = entry.getValue();
                if (o != null) {
                    if (o instanceof Long) {
                        value = Long.toString((Long)o);
                    } else if (o instanceof Boolean) {
                        value = Boolean.toString((Boolean)o);
                    } else {
                        try {
                            value = (String)entry.getValue();
                            if (elementName.toLowerCase().contains("password")) {
                                value = this.passwordEncoder.encode((CharSequence)value);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                rootNode.appendChild(this.createChildElement(doc, elementName, type, value));
            }
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            String s = writer.toString();
            s = s.substring(s.indexOf(">") + 1);
            return s;
        }
        catch (ParserConfigurationException | TransformerException e1) {
            LOGGER.error("Could not parse embedded cluster xml" + e1.toString());
            return "";
        }
    }

    public NamedCluster fromXmlForEmbed(Node node) {
        NamedClusterImpl returnCluster = this.clone();
        List fields = XMLHandler.getNodes((Node)node, (String)"child");
        for (Node field : fields) {
            String fieldName = XMLHandler.getTagValue((Node)field, (String)"id");
            String fieldValue = XMLHandler.getTagValue((Node)field, (String)"value");
            if (fieldName.toLowerCase().contains("password")) {
                fieldValue = this.passwordEncoder.decode((CharSequence)fieldValue);
            }
            try {
                BeanUtils.setProperty((Object)returnCluster, (String)fieldName, (Object)fieldValue);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.error("Could not serialize NamedCluster to xml: " + e.toString());
            }
        }
        return returnCluster;
    }

    private Node createChildElement(Document doc, String elementName, String elementType, String elementValue) {
        Element childNode = doc.createElement("child");
        childNode.appendChild(this.createTextNode(doc, "id", elementName));
        childNode.appendChild(this.createTextNode(doc, "value", elementValue));
        childNode.appendChild(this.createTextNode(doc, "type", elementType));
        return childNode;
    }

    private Node createTextNode(Document doc, String tagName, String value) {
        Element node = doc.createElement(tagName);
        node.appendChild(doc.createTextNode(value));
        return node;
    }

    public String getGatewayUrl() {
        return this.gatewayUrl;
    }

    public void setGatewayUrl(String gatewayUrl) {
        this.gatewayUrl = gatewayUrl;
    }

    public String getGatewayUsername() {
        return this.gatewayUsername;
    }

    public void setGatewayUsername(String gatewayUsername) {
        this.gatewayUsername = gatewayUsername;
    }

    public String getGatewayPassword() {
        return this.gatewayPassword;
    }

    public void setGatewayPassword(String gatewayPassword) {
        this.gatewayPassword = gatewayPassword;
    }

    public boolean isUseGateway() {
        return this.useGateway;
    }

    public void setUseGateway(boolean useGateway) {
        this.useGateway = useGateway;
    }

    public String getKafkaBootstrapServers() {
        return this.kafkaBootstrapServers;
    }

    public void setKafkaBootstrapServers(String kafkaBootstrapServers) {
        this.kafkaBootstrapServers = kafkaBootstrapServers;
    }

    public NamedClusterOsgi nonOsgiFromXmlForEmbed(Node node) {
        return (NamedClusterOsgi)this.fromXmlForEmbed(node);
    }
}

