/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.cluster;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.pentaho.big.data.impl.cluster.NamedClusterImpl;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.attributes.metastore.EmbeddedMetaStore;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.plugins.LifecyclePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.persist.MetaStoreFactory;
import org.pentaho.metastore.stores.xml.XmlMetaStore;

public class NamedClusterManager
implements NamedClusterService {
    public static final String BIG_DATA_SLAVE_METASTORE_DIR = "hadoop.configurations.path";
    private static final Class<?> PKG = NamedClusterManager.class;
    private BundleContext bundleContext;
    private Map<IMetaStore, MetaStoreFactory<NamedClusterImpl>> factoryMap = new HashMap<IMetaStore, MetaStoreFactory<NamedClusterImpl>>();
    private NamedCluster clusterTemplate;
    private LogChannel log = new LogChannel((Object)this);
    private Map<String, Object> properties = new HashMap<String, Object>();
    private static final String LOCALHOST = "localhost";

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.initProperties();
    }

    protected void initProperties() {
        ServiceReference serviceReference = this.getBundleContext().getServiceReference(ConfigurationAdmin.class.getName());
        if (serviceReference != null) {
            try {
                ConfigurationAdmin admin = (ConfigurationAdmin)this.getBundleContext().getService(serviceReference);
                Configuration configuration = admin.getConfiguration("pentaho.big.data.impl.cluster");
                Dictionary rawProperties = configuration.getProperties();
                Enumeration keys = rawProperties.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    this.properties.put(key, rawProperties.get(key));
                }
            }
            catch (Exception e) {
                this.properties = new HashMap<String, Object>();
            }
        }
    }

    @VisibleForTesting
    MetaStoreFactory<NamedClusterImpl> getMetaStoreFactory(IMetaStore metastore) {
        MetaStoreFactory namedClusterMetaStoreFactory = null;
        if (!(metastore instanceof EmbeddedMetaStore)) {
            return new MetaStoreFactory(NamedClusterImpl.class, metastore, "pentaho");
        }
        namedClusterMetaStoreFactory = this.factoryMap.computeIfAbsent(metastore, m -> new MetaStoreFactory(NamedClusterImpl.class, m, "NamedClusters"));
        return namedClusterMetaStoreFactory;
    }

    @VisibleForTesting
    void putMetaStoreFactory(IMetaStore metastore, MetaStoreFactory<NamedClusterImpl> metaStoreFactory) {
        this.factoryMap.put(metastore, metaStoreFactory);
    }

    public void close(IMetaStore metastore) {
        this.factoryMap.remove(metastore);
    }

    public NamedCluster getClusterTemplate() {
        if (this.clusterTemplate == null) {
            this.clusterTemplate = new NamedClusterImpl();
            this.clusterTemplate.setName("");
            this.clusterTemplate.setHdfsHost(LOCALHOST);
            this.clusterTemplate.setHdfsPort("8020");
            this.clusterTemplate.setHdfsUsername("user");
            this.clusterTemplate.setHdfsPassword("password");
            this.clusterTemplate.setJobTrackerHost(LOCALHOST);
            this.clusterTemplate.setJobTrackerPort("8032");
            this.clusterTemplate.setZooKeeperHost(LOCALHOST);
            this.clusterTemplate.setZooKeeperPort("2181");
            this.clusterTemplate.setOozieUrl("http://localhost:8080/oozie");
        }
        return this.clusterTemplate.clone();
    }

    public void setClusterTemplate(NamedCluster clusterTemplate) {
        this.clusterTemplate = clusterTemplate;
    }

    public void create(NamedCluster namedCluster, IMetaStore metastore) throws MetaStoreException {
        this.getMetaStoreFactory(metastore).saveElement((Object)new NamedClusterImpl(namedCluster));
    }

    public NamedCluster read(String clusterName, IMetaStore metastore) throws MetaStoreException {
        IMetaStore slaveMetastore;
        MetaStoreFactory<NamedClusterImpl> factory = this.getMetaStoreFactory(metastore);
        if ((metastore == null || !this.listNames(metastore).contains(clusterName)) && (slaveMetastore = this.getSlaveServerMetastore()) != null && this.listNames(slaveMetastore).contains(clusterName)) {
            factory = this.getMetaStoreFactory(slaveMetastore);
        }
        NamedCluster namedCluster = null;
        try {
            namedCluster = (NamedCluster)factory.loadElement(clusterName);
        }
        catch (MetaStoreException e) {
            namedCluster = (NamedCluster)factory.loadElement(clusterName, false);
        }
        return namedCluster;
    }

    public void update(NamedCluster namedCluster, IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedClusterImpl> factory = this.getMetaStoreFactory(metastore);
        List<NamedCluster> namedClusters = this.list(metastore);
        for (NamedCluster nc : namedClusters) {
            if (!namedCluster.getName().equals(nc.getName())) continue;
            factory.deleteElement(nc.getName());
            factory.saveElement((Object)new NamedClusterImpl(namedCluster));
        }
    }

    public void delete(String clusterName, IMetaStore metastore) throws MetaStoreException {
        this.getMetaStoreFactory(metastore).deleteElement(clusterName);
    }

    public List<NamedCluster> list(IMetaStore metastore) throws MetaStoreException {
        ArrayList<NamedCluster> namedClusters;
        MetaStoreFactory<NamedClusterImpl> factory = this.getMetaStoreFactory(metastore);
        try {
            namedClusters = new ArrayList<NamedCluster>(factory.getElements(true));
        }
        catch (MetaStoreException ex) {
            namedClusters = new ArrayList(factory.getElements(false));
        }
        return namedClusters;
    }

    public List<String> listNames(IMetaStore metastore) throws MetaStoreException {
        return this.getMetaStoreFactory(metastore).getElementNames(false);
    }

    public boolean contains(String clusterName, IMetaStore metastore) throws MetaStoreException {
        IMetaStore slaveMetastore;
        boolean found = false;
        if (metastore != null) {
            found = this.listNames(metastore).contains(clusterName);
        }
        if (!found && (slaveMetastore = this.getSlaveServerMetastore()) != null) {
            found = this.listNames(slaveMetastore).contains(clusterName);
        }
        return found;
    }

    public NamedCluster getNamedClusterByName(String namedClusterName, IMetaStore metastore) {
        IMetaStore slaveMetastore;
        NamedCluster namedCluster = null;
        if (metastore != null) {
            namedCluster = this.searchMetastoreByName(namedClusterName, metastore);
        }
        if (namedCluster == null && (slaveMetastore = this.getSlaveServerMetastore()) != null) {
            namedCluster = this.searchMetastoreByName(namedClusterName, slaveMetastore);
        }
        return namedCluster;
    }

    private NamedCluster searchMetastoreByName(String namedCluster, IMetaStore metastore) {
        try {
            List<NamedCluster> namedClusters = this.list(metastore);
            for (NamedCluster nc : namedClusters) {
                if (!nc.getName().equals(namedCluster)) continue;
                return nc;
            }
        }
        catch (MetaStoreException e) {
            return null;
        }
        return null;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public NamedCluster getNamedClusterByHost(String hostName, IMetaStore metastore) {
        IMetaStore slaveMetastore;
        NamedCluster namedCluster = null;
        if (hostName == null) {
            return null;
        }
        if (metastore != null) {
            namedCluster = this.searchMetastoreByHost(hostName, metastore);
        }
        if (namedCluster == null && (slaveMetastore = this.getSlaveServerMetastore()) != null) {
            namedCluster = this.searchMetastoreByHost(hostName, slaveMetastore);
        }
        return namedCluster;
    }

    private NamedCluster searchMetastoreByHost(String hostName, IMetaStore metastore) {
        try {
            List<NamedCluster> namedClusters = this.list(metastore);
            for (NamedCluster nc : namedClusters) {
                if (!hostName.equals(nc.getHdfsHost())) continue;
                return nc;
            }
        }
        catch (MetaStoreException e) {
            return null;
        }
        return null;
    }

    public void updateNamedClusterTemplate(String hostName, int port, boolean isMapr) {
        if (this.clusterTemplate == null) {
            this.getClusterTemplate();
        }
        this.clusterTemplate.setHdfsHost(hostName);
        if (port > 0) {
            this.clusterTemplate.setHdfsPort(String.valueOf(port));
        } else {
            this.clusterTemplate.setHdfsPort("");
        }
        this.clusterTemplate.setMapr(isMapr);
    }

    private String getSlaveServerMetastoreDir() throws IOException {
        PluginInterface pluginInterface = PluginRegistry.getInstance().findPluginWithId(LifecyclePluginType.class, "HadoopSpoonPlugin");
        try {
            Properties legacyProperties = this.loadProperties(pluginInterface, "plugin.properties");
            String slaveMetaStorePath = legacyProperties.getProperty(BIG_DATA_SLAVE_METASTORE_DIR);
            if (this.useSlaveMetastorePathFromProperties(slaveMetaStorePath)) {
                return slaveMetaStorePath;
            }
            slaveMetaStorePath = pluginInterface.getPluginDirectory().getPath();
            FileObject slaveMetastoreDir = KettleVFS.getFileObject((String)(slaveMetaStorePath + File.separator + "metastore"));
            if (null != slaveMetastoreDir && slaveMetastoreDir.exists() && slaveMetastoreDir.getType().equals((Object)FileType.FOLDER) && KettleClientEnvironment.getInstance().getClient().equals((Object)KettleClientEnvironment.ClientType.CARTE)) {
                return slaveMetaStorePath;
            }
            slaveMetaStorePath = System.getProperty("user.home") + File.separator + ".pentaho";
            slaveMetastoreDir = KettleVFS.getFileObject((String)slaveMetaStorePath);
            if (null != slaveMetastoreDir && slaveMetastoreDir.exists() && slaveMetastoreDir.getType().equals((Object)FileType.FOLDER)) {
                return slaveMetaStorePath;
            }
            return null;
        }
        catch (NullPointerException | KettleFileException e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"NamedClusterManager.ErrorFindingUserMetastore", (String[])new String[0]), e);
            throw new IOException(e);
        }
    }

    private boolean useSlaveMetastorePathFromProperties(String slaveMetaStorePath) throws FileSystemException {
        try {
            FileObject slaveMetastoreDir = KettleVFS.getFileObject((String)(slaveMetaStorePath + File.separator + "metastore"));
            return null != slaveMetaStorePath && !slaveMetaStorePath.equals("") && null != slaveMetastoreDir && slaveMetastoreDir.exists();
        }
        catch (KettleFileException e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"NamedClusterManager.ErrorFindingUserMetastore", (String[])new String[0]), (Throwable)e);
            return false;
        }
    }

    @VisibleForTesting
    IMetaStore getSlaveServerMetastore() {
        try {
            String metastoreDir = this.getSlaveServerMetastoreDir();
            if (null != metastoreDir) {
                return new XmlMetaStore(this.getSlaveServerMetastoreDir());
            }
            return null;
        }
        catch (IOException | MetaStoreException e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"NamedClusterManager.ErrorReadingMetastore", (String[])new String[0]), e);
            return null;
        }
    }

    private Properties loadProperties(PluginInterface plugin, String relativeName) throws KettleFileException, IOException {
        if (plugin == null) {
            throw new NullPointerException();
        }
        FileObject propFile = KettleVFS.getFileObject((String)(plugin.getPluginDirectory().getPath() + Const.FILE_SEPARATOR + relativeName));
        if (!propFile.exists()) {
            throw new FileNotFoundException(propFile.toString());
        }
        try {
            Properties pluginProperties = new Properties();
            pluginProperties.load(new FileInputStream(propFile.getName().getPath()));
            return pluginProperties;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

