/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.telemetry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.telemetry.ITelemetryHandler;
import org.pentaho.telemetry.ITelemetryService;
import org.pentaho.telemetry.TelemetryEvent;

public class TelemetryService
implements ITelemetryService {
    private static final String TELEMETRY_NOT_ENABLED_MESSAGE = "Telemetry is not enabled for plugin: ";
    private static final String TELEMETRY_HANDLER_NOT_DEFINED_MESSAGE = "Telemetry handler is not defined for plugin: ";
    private static final Log logger = LogFactory.getLog(TelemetryService.class);
    private String pluginName;
    private String pluginVersion;
    private String platformVersion;
    private String telemetryUrl;
    private boolean telemetryEnabled;
    private ITelemetryHandler telemetryHandler;

    protected Log getLogger() {
        return logger;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    protected void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    protected void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    protected void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public String getTelemetryUrl() {
        return this.telemetryUrl;
    }

    protected void setTelemetryUrl(String telemetryUrl) {
        this.telemetryUrl = telemetryUrl;
    }

    public boolean isTelemetryEnabled() {
        return this.telemetryEnabled;
    }

    protected void setTelemetryEnabled(boolean telemetryEnabled) {
        this.telemetryEnabled = telemetryEnabled;
    }

    public ITelemetryHandler getTelemetryHandler() {
        return this.telemetryHandler;
    }

    protected void setTelemetryHandler(ITelemetryHandler telemetryHandler) {
        this.telemetryHandler = telemetryHandler;
    }

    public TelemetryService(String pluginName, String pluginVersion, String platformVersion, String telemetryUrl, boolean telemetryEnabled, ITelemetryHandler telemetryHandler) {
        this.setPluginName(pluginName);
        this.setPluginVersion(pluginVersion);
        this.setPlatformVersion(platformVersion);
        this.setTelemetryUrl(telemetryUrl);
        this.setTelemetryEnabled(telemetryEnabled);
        this.setTelemetryHandler(telemetryHandler);
    }

    @Override
    public TelemetryEvent createEvent(TelemetryEvent.Type eventType) {
        return new TelemetryEvent(eventType, this.getPluginName(), this.getPluginVersion(), this.getPlatformVersion(), this.getTelemetryUrl());
    }

    @Override
    public boolean publishEvent(TelemetryEvent event) {
        if (!this.isTelemetryEnabled()) {
            this.getLogger().info((Object)(TELEMETRY_NOT_ENABLED_MESSAGE + this.getPluginName()));
            return false;
        }
        if (this.getTelemetryHandler() == null) {
            this.getLogger().warn((Object)(TELEMETRY_HANDLER_NOT_DEFINED_MESSAGE + this.getPluginName()));
            return false;
        }
        event.setEventTimestamp(System.currentTimeMillis());
        return this.getTelemetryHandler().queueEvent(event);
    }
}

