/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.osgi;

import com.google.common.annotations.VisibleForTesting;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.pentaho.di.core.util.ExecutorUtil;
import org.pentaho.di.osgi.KettleLifecycleEvent;
import org.pentaho.di.osgi.OSGIPluginTracker;
import org.pentaho.di.osgi.service.lifecycle.LifecycleEvent;
import org.pentaho.di.osgi.service.notifier.DelayedServiceNotifierListener;
import org.pentaho.osgi.api.IKarafBlueprintWatcher;
import org.pentaho.osgi.api.IKarafFeatureWatcher;
import org.pentaho.platform.servicecoordination.api.IPhasedLifecycleEvent;
import org.pentaho.platform.servicecoordination.api.IPhasedLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafLifecycleListener
implements IPhasedLifecycleListener<KettleLifecycleEvent> {
    private static KarafLifecycleListener instance;
    private static Logger logger;
    private final long timeout;
    private final OSGIPluginTracker osgiPluginTracker;
    private AtomicBoolean listenerActive = new AtomicBoolean(false);
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private BundleContext bundleContext;
    private IPhasedLifecycleEvent<KettleLifecycleEvent> event;
    private final Integer frameworkBeginningStartLevel;
    private FrameworkStartLevel frameworkStartLevel;

    @VisibleForTesting
    KarafLifecycleListener() {
        this(KarafLifecycleListener.getSystemProperty(KarafLifecycleListener.class.getCanonicalName() + ".timeout", TimeUnit.SECONDS.toMillis(100L), Long::parseLong));
    }

    @VisibleForTesting
    KarafLifecycleListener(long timeout) {
        this(timeout, OSGIPluginTracker.getInstance());
    }

    @VisibleForTesting
    KarafLifecycleListener(long timeout, OSGIPluginTracker osgiPluginTracker) {
        this(timeout, osgiPluginTracker, KarafLifecycleListener.getSystemProperty("org.osgi.framework.startlevel.beginning", 100, Integer::parseInt));
    }

    @VisibleForTesting
    KarafLifecycleListener(long timeout, OSGIPluginTracker osgiPluginTracker, int frameworkBeginningStartLevel) {
        this.timeout = timeout;
        this.osgiPluginTracker = osgiPluginTracker;
        this.frameworkBeginningStartLevel = frameworkBeginningStartLevel;
    }

    private static <T> T getSystemProperty(String propertyKey, T defaultValue, Function<String, T> parseFunction) {
        String propertyValue = System.getProperty(propertyKey);
        T result = defaultValue;
        try {
            result = parseFunction.apply(propertyValue);
        }
        catch (Exception e) {
            logger.warn("Failed to parse {} property of value {}, returning default value of {}.", new Object[]{propertyKey, propertyValue, defaultValue});
        }
        return result;
    }

    public static synchronized KarafLifecycleListener getInstance() {
        if (instance == null) {
            instance = new KarafLifecycleListener();
        }
        return instance;
    }

    public void onPhaseChange(IPhasedLifecycleEvent<KettleLifecycleEvent> event) {
        this.event = event;
        if (((KettleLifecycleEvent)((Object)event.getNotificationObject())).equals((Object)KettleLifecycleEvent.INIT)) {
            this.listenerActive.set(true);
            this.startTimeoutThread();
            this.maybeStartWatchers();
        } else {
            event.accept();
        }
    }

    private void startTimeoutThread() {
        Thread t = new Thread(new Runnable(){

            protected void finalize() throws Throwable {
                super.finalize();
            }

            @Override
            public void run() {
                long endWaitTime = System.currentTimeMillis() + KarafLifecycleListener.this.timeout;
                while (!KarafLifecycleListener.this.initialized.get() && endWaitTime - System.currentTimeMillis() > 0L) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                if (!KarafLifecycleListener.this.initialized.get()) {
                    logger.error("The Kettle Karaf Lifecycle Listener failed to execute properly after waiting for {} seconds. Releasing lifecycle hold, but some services may be unavailable.", (Object)TimeUnit.MILLISECONDS.toSeconds(KarafLifecycleListener.this.timeout));
                    KarafLifecycleListener.this.event.accept();
                }
            }
        });
        t.setDaemon(true);
        t.setName("KarafLifecycleListener Timeout Thread");
        t.start();
    }

    private void maybeStartWatchers() {
        if (this.bundleContext != null && this.listenerActive.get()) {
            Thread thread = new Thread(() -> {
                this.waitForBundlesStarted();
                this.waitForBlueprints();
                this.acceptEventOnDelayedServiceNotifiersDone();
            });
            thread.setDaemon(true);
            thread.start();
            this.initialized.set(true);
        }
    }

    private void waitForBundlesStarted() {
        this.waitForFeatures();
        this.waitForFrameworkStarted();
    }

    private <T> T getOsgiService(Class<T> serviceClass) {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(serviceClass);
        if (serviceReference == null) {
            return null;
        }
        return (T)this.bundleContext.getService(serviceReference);
    }

    private void waitForFeatures() {
        IKarafFeatureWatcher karafFeatureWatcher = this.getOsgiService(IKarafFeatureWatcher.class);
        try {
            if (karafFeatureWatcher == null) {
                throw new IKarafFeatureWatcher.FeatureWatcherException("No IKarafFeatureWatcher service available.");
            }
            karafFeatureWatcher.waitForFeatures();
        }
        catch (IKarafFeatureWatcher.FeatureWatcherException e) {
            logger.error("Error in Feature Watcher", (Throwable)e);
        }
    }

    private void waitForBlueprints() {
        IKarafBlueprintWatcher karafBlueprintWatcher = this.getOsgiService(IKarafBlueprintWatcher.class);
        try {
            if (karafBlueprintWatcher == null) {
                throw new IKarafBlueprintWatcher.BlueprintWatcherException("No IKarafBlueprintWatcher service available.");
            }
            karafBlueprintWatcher.waitForBlueprint();
        }
        catch (IKarafBlueprintWatcher.BlueprintWatcherException e) {
            logger.error("Error in Blueprint Watcher", (Throwable)e);
        }
    }

    private void acceptEventOnDelayedServiceNotifiersDone() {
        final AtomicBoolean accepted = new AtomicBoolean(false);
        DelayedServiceNotifierListener delayedServiceNotifierListener = new DelayedServiceNotifierListener(){

            @Override
            public void onRun(LifecycleEvent lifecycleEvent, Object serviceObject) {
                if (KarafLifecycleListener.this.osgiPluginTracker.getOutstandingServiceNotifierListeners() == 0 && !accepted.getAndSet(true)) {
                    logger.debug("Done waiting on delayed service notifiers");
                    KarafLifecycleListener.this.event.accept();
                    KarafLifecycleListener.this.osgiPluginTracker.removeDelayedServiceNotifierListener(this);
                }
            }
        };
        logger.debug("About to start waiting on delayed service notifiers");
        this.osgiPluginTracker.addDelayedServiceNotifierListener(delayedServiceNotifierListener);
        delayedServiceNotifierListener.onRun(null, null);
    }

    private void waitForFrameworkStarted() {
        while (this.frameworkStartLevel.getStartLevel() < this.frameworkBeginningStartLevel) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.debug("Thread interrupted while waiting for OSGi framework start level to reach the beginning start level.");
                Thread.currentThread().interrupt();
            }
        }
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        bundleContext.registerService(ExecutorService.class, (Object)ExecutorUtil.getExecutor(), new Hashtable());
        this.frameworkStartLevel = (FrameworkStartLevel)bundleContext.getBundle(0L).adapt(FrameworkStartLevel.class);
        this.maybeStartWatchers();
    }

    static {
        logger = LoggerFactory.getLogger(KarafLifecycleListener.class);
    }
}

