/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.browse.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.big.data.impl.browse.model.NamedClusterFile;
import org.pentaho.di.plugins.fileopensave.api.providers.Directory;

public class NamedClusterDirectory
extends NamedClusterFile
implements Directory {
    private boolean hasChildren;
    private boolean canAddChildren;
    private List<NamedClusterFile> children = new ArrayList<NamedClusterFile>();
    public static final String DIRECTORY = "folder";

    @Override
    public String getType() {
        return DIRECTORY;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public List<NamedClusterFile> getChildren() {
        return this.children;
    }

    public void setChildren(List<NamedClusterFile> children) {
        this.children = children;
    }

    public void addChild(NamedClusterFile file) {
        this.children.add(file);
    }

    public boolean isHasChildren() {
        return this.hasChildren;
    }

    public void setCanAddChildren(boolean canAddChildren) {
        this.canAddChildren = canAddChildren;
    }

    public boolean isCanAddChildren() {
        return this.canAddChildren;
    }

    public static NamedClusterDirectory create(String parent, FileObject fileObject) {
        NamedClusterDirectory namedClusterDirectory = new NamedClusterDirectory();
        namedClusterDirectory.setName(fileObject.getName().getBaseName());
        namedClusterDirectory.setPath(fileObject.getName().getFriendlyURI());
        namedClusterDirectory.setParent(parent);
        namedClusterDirectory.setRoot("Hadoop Clusters");
        namedClusterDirectory.setCanEdit(true);
        namedClusterDirectory.setHasChildren(true);
        namedClusterDirectory.setCanAddChildren(true);
        try {
            namedClusterDirectory.setDate(new Date(fileObject.getContent().getLastModifiedTime()));
        }
        catch (FileSystemException e) {
            namedClusterDirectory.setDate(new Date());
        }
        return namedClusterDirectory;
    }
}

