/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.parser;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;

public abstract class AbstractReadHandlerFactory<T extends XmlReadHandler> {
    private HashMap<TagDefinitionKey, TagDefinitionValue> tagData = new HashMap();
    private String defaultNamespace;

    protected AbstractReadHandlerFactory() {
    }

    public void configureGlobal(Configuration config, String prefix) {
        Iterator propertyKeys = config.findPropertyKeys(prefix);
        while (propertyKeys.hasNext()) {
            String key = (String)propertyKeys.next();
            String value = config.getConfigProperty(key);
            if (value == null) continue;
            this.configure(config, value);
        }
    }

    public void configure(Configuration conf, String prefix) {
        String globalDefaultKey;
        String globalValue;
        HashMap<String, String> knownNamespaces = new HashMap<String, String>();
        String nsConfPrefix = prefix + "namespace.";
        Iterator namespaces = conf.findPropertyKeys(nsConfPrefix);
        while (namespaces.hasNext()) {
            String key = (String)namespaces.next();
            String nsPrefix = key.substring(nsConfPrefix.length());
            String nsUri = conf.getConfigProperty(key);
            knownNamespaces.put(nsPrefix, nsUri);
        }
        Log legacyWarningLog = LogFactory.getLog(this.getClass());
        boolean warnedLegacyConfig = false;
        String legacyDefaultNamespace = (String)knownNamespaces.get(conf.getConfigProperty(prefix + "namespace"));
        if (legacyDefaultNamespace != null) {
            if (!warnedLegacyConfig) {
                legacyWarningLog.warn((Object)"Configured configuration-properties based override for global read-hander. Change your code to use proper module-initializers instead. This method of configuring the parser will go away in the next major version.");
                warnedLegacyConfig = true;
            }
            this.setDefaultNamespace(legacyDefaultNamespace);
        }
        if (this.isValidHandler(globalValue = conf.getConfigProperty(globalDefaultKey = prefix + "default"))) {
            this.tagData.put(new TagDefinitionKey(null, null), new TagDefinitionValue(globalValue, true));
            if (!warnedLegacyConfig) {
                legacyWarningLog.warn((Object)"Configured configuration-properties based override for global read-hander. Change your code to use proper module-initializers instead. This method of configuring the parser will go away in the next major version.");
                warnedLegacyConfig = true;
            }
        }
        String nsDefaultPrefix = prefix + "default.";
        Iterator defaults = conf.findPropertyKeys(nsDefaultPrefix);
        while (defaults.hasNext()) {
            String tagData;
            String key = (String)defaults.next();
            String nsPrefix = key.substring(nsDefaultPrefix.length());
            String nsUri = (String)knownNamespaces.get(nsPrefix);
            if (nsUri == null || (tagData = conf.getConfigProperty(key)) == null || !this.isValidHandler(tagData)) continue;
            if (!warnedLegacyConfig) {
                legacyWarningLog.warn((Object)"Configured configuration-properties based override for global read-hander. Change your code to use proper module-initializers instead. This method of configuring the parser will go away in the next major version.");
                warnedLegacyConfig = true;
            }
            this.tagData.put(new TagDefinitionKey(nsUri, null), new TagDefinitionValue(tagData, true));
        }
        String nsTagsPrefix = prefix + "tag.";
        Iterator tags = conf.findPropertyKeys(nsTagsPrefix);
        while (tags.hasNext()) {
            int delim;
            String key = (String)tags.next();
            String tagDef = key.substring(nsTagsPrefix.length());
            String tagData = conf.getConfigProperty(key);
            if (tagData == null || !this.isValidHandler(tagData)) continue;
            if (!warnedLegacyConfig) {
                legacyWarningLog.warn((Object)"Configured configuration-properties based override for global read-hander. Change your code to use proper module-initializers instead. This method of configuring the parser will go away in the next major version.");
                warnedLegacyConfig = true;
            }
            if ((delim = tagDef.indexOf(46)) == -1) {
                this.tagData.put(new TagDefinitionKey(null, tagDef), new TagDefinitionValue(tagData, true));
                continue;
            }
            String nsPrefix = tagDef.substring(0, delim);
            String nsUri = (String)knownNamespaces.get(nsPrefix);
            if (nsUri == null) continue;
            String tagName = tagDef.substring(delim + 1);
            this.tagData.put(new TagDefinitionKey(nsUri, tagName), new TagDefinitionValue(tagData, true));
        }
    }

    public void setNamespaceHandler(String namespaceUri, Class<? extends T> hasCData) {
        TagDefinitionKey key = new TagDefinitionKey(namespaceUri, null);
        this.setValueIfNotDefinedAsLegacy(key, hasCData);
    }

    public void setElementHandler(String namespaceUri, String tagName, Class<? extends T> hasCData) {
        if (namespaceUri == null) {
            throw new NullPointerException();
        }
        if (tagName == null) {
            throw new NullPointerException();
        }
        TagDefinitionKey key = new TagDefinitionKey(namespaceUri, tagName);
        this.setValueIfNotDefinedAsLegacy(key, hasCData);
    }

    public void setElementHandler(String tagName, Class<? extends T> hasCData) {
        if (tagName == null) {
            throw new NullPointerException();
        }
        TagDefinitionKey key = new TagDefinitionKey(this.defaultNamespace, tagName);
        this.setValueIfNotDefinedAsLegacy(key, hasCData);
    }

    private void setValueIfNotDefinedAsLegacy(TagDefinitionKey key, Class<? extends T> hasCData) {
        TagDefinitionValue existingValue = this.tagData.get(key);
        if (existingValue != null && existingValue.isLegacyOverride()) {
            Log legacyWarningLog = LogFactory.getLog(this.getClass());
            legacyWarningLog.debug((Object)("Module-Configuration ignored as a legacy properties-based configuration exists for " + key));
            return;
        }
        this.tagData.put(key, new TagDefinitionValue(hasCData.getName(), false));
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    private boolean isValidHandler(String className) {
        if (className == null) {
            return false;
        }
        XmlReadHandler o = (XmlReadHandler)ObjectUtilities.loadAndInstantiate((String)className, this.getClass(), this.getTargetClass());
        return o != null;
    }

    protected abstract Class<T> getTargetClass();

    public T getHandler(String namespace, String tagname) {
        TagDefinitionKey key;
        TagDefinitionValue tagVal;
        if (namespace == null) {
            namespace = this.defaultNamespace;
        }
        if ((tagVal = this.tagData.get(key = new TagDefinitionKey(namespace, tagname))) != null) {
            return (T)((XmlReadHandler)ObjectUtilities.loadAndInstantiate((String)tagVal.getClassName(), this.getClass(), this.getTargetClass()));
        }
        TagDefinitionKey defaultKey = new TagDefinitionKey(namespace, null);
        TagDefinitionValue className = this.tagData.get(defaultKey);
        if (className != null) {
            return (T)((XmlReadHandler)ObjectUtilities.loadAndInstantiate((String)className.getClassName(), this.getClass(), this.getTargetClass()));
        }
        TagDefinitionKey fallbackKey = new TagDefinitionKey(null, null);
        TagDefinitionValue fallbackName = this.tagData.get(fallbackKey);
        if (fallbackName == null) {
            return null;
        }
        XmlReadHandler fallbackValue = (XmlReadHandler)ObjectUtilities.loadAndInstantiate((String)fallbackName.getClassName(), this.getClass(), this.getTargetClass());
        if (fallbackValue != null) {
            return (T)fallbackValue;
        }
        return null;
    }

    private static class TagDefinitionValue {
        private String className;
        private boolean legacyOverride;

        private TagDefinitionValue(String className, boolean legacyOverride) {
            this.className = className;
            this.legacyOverride = legacyOverride;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isLegacyOverride() {
            return this.legacyOverride;
        }
    }

    private static class TagDefinitionKey {
        private String namespace;
        private String tagName;

        private TagDefinitionKey(String namespace, String tagName) {
            this.namespace = namespace;
            this.tagName = tagName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TagDefinitionKey that = (TagDefinitionKey)o;
            if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
                return false;
            }
            return !(this.tagName != null ? !this.tagName.equals(that.tagName) : that.tagName != null);
        }

        public int hashCode() {
            int result = this.namespace != null ? this.namespace.hashCode() : 0;
            result = 29 * result + (this.tagName != null ? this.tagName.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            if (this.namespace == null) {
                sb.append("<null>");
            } else {
                sb.append(this.namespace);
            }
            sb.append('\'');
            sb.append("|");
            if (this.tagName == null) {
                sb.append("<null>");
            } else {
                sb.append(this.tagName);
            }
            sb.append('\'');
            sb.append(']');
            return sb.toString();
        }
    }
}

