/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport.outputs;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import org.jfree.ui.RefineryUtilities;
import org.pentaho.platform.plugin.action.jfreereport.outputs.AbstractGenerateContentComponent;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.ReportController;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;

public class JFreeReportPreviewSwingComponent
extends AbstractGenerateContentComponent {
    private static final long serialVersionUID = -8158403113060631980L;
    private static final String PROGRESS_DIALOG_ENABLED_KEY = "org.jfree.report.modules.gui.base.ProgressDialogEnabled";
    private static final String PROGRESS_BAR_ENABLED_KEY = "org.jfree.report.modules.gui.base.ProgressBarEnabled";

    @Override
    protected boolean performExport(MasterReport report) {
        ModifiableConfiguration reportConfiguration = report.getReportConfiguration();
        boolean progressBar = this.getInputBooleanValue("progress-bar", "true".equals(reportConfiguration.getConfigProperty(PROGRESS_BAR_ENABLED_KEY)));
        boolean progressDialog = this.getInputBooleanValue("progress-dialog", "true".equals(reportConfiguration.getConfigProperty(PROGRESS_DIALOG_ENABLED_KEY)));
        reportConfiguration.setConfigProperty(PROGRESS_DIALOG_ENABLED_KEY, String.valueOf(progressDialog));
        reportConfiguration.setConfigProperty(PROGRESS_BAR_ENABLED_KEY, String.valueOf(progressBar));
        PreviewDialog dialog = this.createDialog(report);
        ReportController reportController = this.getReportController();
        if (reportController != null) {
            dialog.setReportController(reportController);
        }
        dialog.pack();
        if (dialog.getParent() != null) {
            RefineryUtilities.centerDialogInParent((Dialog)dialog);
        } else {
            RefineryUtilities.centerFrameOnScreen((Window)dialog);
        }
        dialog.setVisible(true);
        return true;
    }

    private ReportController getReportController() {
        Object controller;
        if (this.isDefinedInput("report-controler") && (controller = this.getInputValue("report-controler")) instanceof ReportController) {
            return (ReportController)controller;
        }
        return null;
    }

    private PreviewDialog createDialog(MasterReport report) {
        boolean modal = this.getInputBooleanValue("modal", true);
        if (this.isDefinedInput("parent-dialog")) {
            Object parent = this.getInputValue("parent-dialog");
            if (parent instanceof Dialog) {
                return new PreviewDialog(report, (Dialog)parent, modal);
            }
            if (parent instanceof Frame) {
                return new PreviewDialog(report, (Frame)parent, modal);
            }
        }
        PreviewDialog previewDialog = new PreviewDialog(report);
        previewDialog.setModal(modal);
        return previewDialog;
    }
}

