/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.mondrian;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import mondrian.olap.MondrianProperties;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.util.logging.Logger;

public class MondrianSystemListener
implements IPentahoSystemListener {
    public boolean startup(IPentahoSession session) {
        this.loadMondrianProperties(session);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMondrianProperties(IPentahoSession session) {
        String mondrianPropsFilename = "system" + File.separator + "mondrian" + File.separator + "mondrian.properties";
        File mondrianPropsFile = new File(PentahoSystem.getApplicationContext().getSolutionPath(mondrianPropsFilename));
        InputStream is = null;
        try {
            if (mondrianPropsFile.exists()) {
                is = new FileInputStream(mondrianPropsFile);
                MondrianProperties.instance().load(is);
                Logger.debug((String)MondrianSystemListener.class.getName(), (String)Messages.getInstance().getString("MondrianSystemListener.PROPERTY_FILE_LOADED", new Object[]{mondrianPropsFilename}));
            } else {
                Logger.warn((String)MondrianSystemListener.class.getName(), (String)Messages.getInstance().getString("MondrianSystemListener.PROPERTY_FILE_NOT_FOUND", new Object[]{mondrianPropsFilename}));
            }
        }
        catch (IOException ioe) {
            Logger.error((String)MondrianSystemListener.class.getName(), (String)Messages.getInstance().getString("MondrianSystemListener.ERROR_0002_PROPERTY_FILE_READ_FAILED", new Object[]{ioe.getMessage()}), (Throwable)ioe);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void shutdown() {
    }
}

