/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.pentaho.platform.api.mimetype.IMimeType;
import org.pentaho.platform.api.repository2.unified.IPlatformImportBundle;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.importer.IPlatformImportHandler;
import org.pentaho.platform.plugin.services.importer.IPlatformImporter;
import org.pentaho.platform.plugin.services.importer.LocaleFilesProcessor;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportFileHandler;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class PRPTImportHandler
extends RepositoryFileImportFileHandler
implements IPlatformImportHandler {
    public PRPTImportHandler(List<IMimeType> mimeTypes) {
        super(mimeTypes);
    }

    @Override
    public void importFile(IPlatformImportBundle bundle) throws PlatformImportException {
        RepositoryFileImportBundle importBundle = (RepositoryFileImportBundle)bundle;
        LocaleFilesProcessor localeFilesProcessor = new LocaleFilesProcessor();
        IPlatformImporter importer = (IPlatformImporter)PentahoSystem.get(IPlatformImporter.class);
        String fileName = importBundle.getName();
        String filePath = importBundle.getPath().equals("/") || importBundle.getPath().equals("\\") ? "" : importBundle.getPath();
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)bundle.getInputStream());
            ByteArrayInputStream bundleInputStream = new ByteArrayInputStream(bytes);
            importBundle.setInputStream(bundleInputStream);
            DocumentMetaData documentMetaData = this.extractMetaData(bytes);
            this.fillLocaleEntry(localeFilesProcessor, documentMetaData, filePath, fileName, importBundle.getFile());
            importBundle.setHidden(this.getMimeTypeMap().get(importBundle.getMimeType()).isHidden());
            super.importFile(importBundle);
            localeFilesProcessor.processLocaleFiles(importer);
        }
        catch (Exception ex) {
            throw new PlatformImportException(ex.getMessage(), ex);
        }
    }

    private void fillLocaleEntry(LocaleFilesProcessor localeFilesProcessor, DocumentMetaData metaData, String filePath, String fileName, RepositoryFile rf) throws IOException {
        String title;
        String description = (String)metaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "description");
        if (StringUtils.isEmpty((String)description, (boolean)true)) {
            description = null;
        }
        if (StringUtils.isEmpty((String)(title = (String)metaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "title")), (boolean)true)) {
            title = null;
        }
        if (title != null || description != null) {
            localeFilesProcessor.createLocaleEntry(filePath, fileName, title, description, rf, new ByteArrayInputStream("".getBytes()));
        }
    }

    protected DocumentMetaData extractMetaData(byte[] bytes) throws PlatformImportException {
        try {
            ResourceManager mgr = new ResourceManager();
            MasterReport report = (MasterReport)mgr.createDirectly((Object)bytes, MasterReport.class).getResource();
            return report.getBundle().getMetaData();
        }
        catch (ResourceException e) {
            throw new PlatformImportException("An unexpected error occurred while parsing a report definition", e);
        }
    }
}

